/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import smile.data.type.DataType;
import smile.data.type.StructField;
import smile.data.vector.ObjectVector;
import smile.math.MathEx;
import smile.util.Index;

public class NumberVector<T extends Number>
extends ObjectVector<T> {
    public NumberVector(StructField field, T[] vector) {
        if (!field.dtype().isNumeric()) {
            throw new IllegalArgumentException("Invalid data type: " + String.valueOf(field));
        }
        super(field, vector);
    }

    public double mean() {
        return this.doubleStream().filter(Double::isFinite).average().orElse(0.0);
    }

    public double stdev() {
        double[] data = this.doubleStream().filter(Double::isFinite).toArray();
        return MathEx.stdev(data);
    }

    public double min() {
        return this.doubleStream().filter(Double::isFinite).min().orElse(0.0);
    }

    public double max() {
        return this.doubleStream().filter(Double::isFinite).max().orElse(0.0);
    }

    public double median() {
        double[] data = this.doubleStream().filter(Double::isFinite).toArray();
        return MathEx.median(data);
    }

    public double q1() {
        double[] data = this.doubleStream().filter(Double::isFinite).toArray();
        return MathEx.q1(data);
    }

    public double q3() {
        double[] data = this.doubleStream().filter(Double::isFinite).toArray();
        return MathEx.q3(data);
    }

    public void fillna(double value) {
        Number number = switch (this.dtype().id()) {
            case DataType.ID.Byte -> (byte)value;
            case DataType.ID.Short -> (short)value;
            case DataType.ID.Int -> (int)value;
            case DataType.ID.Long -> (long)value;
            case DataType.ID.Float -> Float.valueOf((float)value);
            case DataType.ID.Double -> value;
            default -> throw new UnsupportedOperationException("Unsupported type: " + String.valueOf((Object)this.dtype().id()));
        };
        for (int i = 0; i < ((Number[])this.vector).length; ++i) {
            if (((Number[])this.vector)[i] == null) {
                ((Number[])this.vector)[i] = number;
                continue;
            }
            double x = ((Number[])this.vector)[i].doubleValue();
            if (!Double.isNaN(x) && !Double.isInfinite(x)) continue;
            ((Number[])this.vector)[i] = number;
        }
    }

    @Override
    public NumberVector<T> get(Index index) {
        Number[] data = Arrays.copyOf((Number[])this.vector, index.size());
        for (int i = 0; i < data.length; ++i) {
            data[i] = ((Number[])this.vector)[index.apply(i)];
        }
        return new NumberVector(this.field, data);
    }

    @Override
    public NumberVector<T> withName(String name) {
        return new NumberVector(this.field.withName(name), (Number[])this.vector);
    }

    @Override
    public IntStream intStream() {
        return Arrays.stream((Number[])this.vector).filter(Objects::nonNull).mapToInt(Number::intValue);
    }

    @Override
    public LongStream longStream() {
        return Arrays.stream((Number[])this.vector).filter(Objects::nonNull).mapToLong(Number::longValue);
    }

    @Override
    public DoubleStream doubleStream() {
        return Arrays.stream((Number[])this.vector).filter(Objects::nonNull).mapToDouble(Number::doubleValue);
    }
}

