/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.BitSet;
import java.util.stream.IntStream;
import smile.data.measure.NumericalMeasure;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.vector.NullablePrimitiveVector;
import smile.util.Index;

public class NullableCharVector
extends NullablePrimitiveVector {
    private final char[] vector;

    public NullableCharVector(String name, char[] vector, BitSet nullMask) {
        this(new StructField(name, DataTypes.NullableCharType), vector, nullMask);
    }

    public NullableCharVector(StructField field, char[] vector, BitSet nullMask) {
        if (field.dtype() != DataTypes.NullableCharType) {
            throw new IllegalArgumentException("Invalid data type: " + String.valueOf(field));
        }
        if (field.measure() instanceof NumericalMeasure) {
            throw new IllegalArgumentException("Invalid measure: " + String.valueOf(field.measure()));
        }
        super(field, nullMask);
        this.vector = vector;
    }

    @Override
    public int size() {
        return this.vector.length;
    }

    @Override
    public NullableCharVector withName(String name) {
        return new NullableCharVector(this.field.withName(name), this.vector, this.nullMask);
    }

    @Override
    public IntStream intStream() {
        return this.index().map(i -> this.nullMask.get(i) ? 0 : this.vector[i]);
    }

    @Override
    public void set(int i, Object value) {
        if (value == null) {
            this.nullMask.set(i);
        } else if (value instanceof Character) {
            Character c = (Character)value;
            this.vector[i] = c.charValue();
        } else {
            throw new IllegalArgumentException("Invalid value type: " + String.valueOf(value.getClass()));
        }
    }

    @Override
    public NullableCharVector get(Index index) {
        int n = index.size();
        char[] data = new char[n];
        BitSet mask = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            int idx = index.apply(i);
            data[i] = this.vector[idx];
            mask.set(i, this.nullMask.get(idx));
        }
        return new NullableCharVector(this.field, data, mask);
    }

    @Override
    public Character get(int i) {
        return this.nullMask.get(i) ? null : Character.valueOf(this.vector[i]);
    }

    @Override
    public char getChar(int i) {
        return this.vector[i];
    }

    @Override
    public boolean getBoolean(int i) {
        return this.vector[i] == 'T';
    }

    @Override
    public byte getByte(int i) {
        return (byte)this.vector[i];
    }

    @Override
    public short getShort(int i) {
        return (short)this.vector[i];
    }

    @Override
    public int getInt(int i) {
        return this.vector[i];
    }

    @Override
    public long getLong(int i) {
        return this.vector[i];
    }

    @Override
    public float getFloat(int i) {
        return this.nullMask.get(i) ? Float.NaN : (float)this.vector[i];
    }

    @Override
    public double getDouble(int i) {
        return this.nullMask.get(i) ? Double.NaN : (double)this.vector[i];
    }
}

