/*
 * Decompiled with CFR 0.152.
 */
package smile.data.type;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import java.util.Objects;
import smile.data.measure.CategoricalMeasure;
import smile.data.measure.Measure;
import smile.data.measure.NominalScale;
import smile.data.measure.NumericalMeasure;
import smile.data.type.DataType;

public record StructField(String name, DataType dtype, Measure measure) implements Serializable
{
    private static final long serialVersionUID = 3L;

    public StructField {
        if (measure instanceof NumericalMeasure && (dtype.isBoolean() || dtype.isChar() || dtype.isString())) {
            throw new IllegalArgumentException(String.format("%s values cannot be of measure %s", dtype, measure));
        }
        if (measure instanceof CategoricalMeasure && !dtype.isIntegral()) {
            throw new IllegalArgumentException(String.format("%s values cannot be of measure %s", dtype, measure));
        }
    }

    public StructField(String name, DataType dtype) {
        this(name, dtype, null);
    }

    @Override
    public String toString() {
        return this.measure != null ? String.format("%s: %s %s", this.name, this.dtype, this.measure) : String.format("%s: %s", this.name, this.dtype);
    }

    public String toString(Object o) {
        if (o == null) {
            return "null";
        }
        return this.measure != null ? this.measure.toString(o) : this.dtype.toString(o);
    }

    public Object valueOf(String s) {
        return this.measure != null ? this.measure.valueOf(s) : this.dtype.valueOf(s);
    }

    public StructField withName(String name) {
        return new StructField(name, this.dtype, this.measure);
    }

    public boolean isNumeric() {
        if (this.measure instanceof NominalScale) {
            return false;
        }
        return this.dtype.isFloating() || this.dtype.isIntegral();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof StructField) {
            StructField f = (StructField)o;
            return this.name.equals(f.name) && this.dtype.equals(f.dtype) && Objects.equals(this.measure, f.measure);
        }
        return false;
    }

    public static StructField of(PropertyDescriptor prop) {
        Class<?> clazz = prop.getPropertyType();
        DataType dtype = DataType.of(clazz);
        NominalScale scale = StructField.getScale(clazz);
        return new StructField(prop.getName(), dtype, scale);
    }

    public static StructField of(RecordComponent comp) {
        Class<?> clazz = comp.getType();
        DataType dtype = DataType.of(clazz);
        NominalScale scale = StructField.getScale(clazz);
        return new StructField(comp.getName(), dtype, scale);
    }

    private static NominalScale getScale(Class<?> clazz) {
        if (clazz.isEnum()) {
            ?[] levels = clazz.getEnumConstants();
            return new NominalScale((String[])Arrays.stream(levels).map(Object::toString).toArray(String[]::new));
        }
        return null;
    }
}

