/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import smile.data.Tuple;
import smile.data.formula.AbstractFunction;
import smile.data.formula.Feature;
import smile.data.formula.Term;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.util.function.Function;

public class DoubleFunction
extends AbstractFunction {
    private final Function lambda;

    public DoubleFunction(String name, Term x, Function lambda) {
        super(name, x);
        this.lambda = lambda;
    }

    @Override
    public List<Feature> bind(StructType schema) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (final Feature feature : this.x.bind(schema)) {
            final StructField xfield = feature.field();
            final DataType dtype = xfield.dtype();
            if (!dtype.isNumeric()) {
                throw new IllegalStateException(String.format("Invalid expression: %s(%s)", this.name, dtype));
            }
            features.add(new Feature(){
                final StructField field;
                final /* synthetic */ DoubleFunction this$0;
                {
                    DoubleFunction doubleFunction = this$0;
                    Objects.requireNonNull(doubleFunction);
                    this.this$0 = doubleFunction;
                    this.field = new StructField(String.format("%s(%s)", this.this$0.name, xfield.name()), dtype.isNullable() ? DataTypes.NullableDoubleType : DataTypes.DoubleType, xfield.measure());
                }

                @Override
                public StructField field() {
                    return this.field;
                }

                @Override
                public Double apply(Tuple o) {
                    Object y = feature.apply(o);
                    if (y == null) {
                        return null;
                    }
                    return this.this$0.lambda.apply(((Number)y).doubleValue());
                }

                @Override
                public double applyAsDouble(Tuple o) {
                    return this.this$0.lambda.apply(feature.applyAsDouble(o));
                }
            });
        }
        return features;
    }
}

