/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.protocol;

import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.utils.DateUtils;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.validator.ETag;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.validator.ValidatorType;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.annotation.Contract;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.EntityDetails;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.Header;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpException;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpRequest;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpRequestInterceptor;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.ProtocolException;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.util.Args;
import java.io.IOException;
import java.time.Instant;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestIfRange
implements HttpRequestInterceptor {
    public static final RequestIfRange INSTANCE = new RequestIfRange();

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        Header ifRangeHeader = request.getFirstHeader("If-Range");
        if (ifRangeHeader == null) {
            return;
        }
        if (!request.containsHeader("Range")) {
            throw new ProtocolException("Request with 'If-Range' header must also contain a 'Range' header.");
        }
        ETag eTag = ETag.get(request);
        if (eTag != null && eTag.getType() == ValidatorType.WEAK) {
            throw new ProtocolException("'If-Range' header must not contain a weak entity tag.");
        }
        Instant dateInstant = DateUtils.parseStandardDate(request, "Date");
        if (dateInstant == null) {
            return;
        }
        Instant lastModifiedInstant = DateUtils.parseStandardDate(request, "Last-Modified");
        if (lastModifiedInstant == null) {
            return;
        }
        if (lastModifiedInstant.plusSeconds(1L).isAfter(dateInstant) && eTag != null) {
            throw new ProtocolException("'If-Range' header with a Date must be a strong validator.");
        }
    }
}

