/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.services.service;

import com.franciaflex.faxtomail.persistence.entities.Client;
import com.franciaflex.faxtomail.persistence.entities.ClientImpl;
import com.franciaflex.faxtomail.persistence.entities.ClientTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.DemandType;
import com.franciaflex.faxtomail.persistence.entities.DemandTypeTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.EmailAccount;
import com.franciaflex.faxtomail.persistence.entities.EmailAccountTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.MailFilter;
import com.franciaflex.faxtomail.persistence.entities.MailFilterTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.Priority;
import com.franciaflex.faxtomail.persistence.entities.PriorityTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.Range;
import com.franciaflex.faxtomail.persistence.entities.RangeTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.WaitingState;
import com.franciaflex.faxtomail.persistence.entities.WaitingStateTopiaDao;
import com.franciaflex.faxtomail.services.FaxToMailServiceSupport;
import com.franciaflex.faxtomail.services.service.ReferentielService;
import com.franciaflex.faxtomail.services.service.imports.ClientImportBean;
import com.franciaflex.faxtomail.services.service.imports.ClientImportModel;
import com.franciaflex.faxtomail.services.service.imports.DemandTypeImportModel;
import com.franciaflex.faxtomail.services.service.imports.EmailAccountImportModel;
import com.franciaflex.faxtomail.services.service.imports.EmailFilterImportModel;
import com.franciaflex.faxtomail.services.service.imports.PriorityImportModel;
import com.franciaflex.faxtomail.services.service.imports.RangeImportModel;
import com.franciaflex.faxtomail.services.service.imports.WaitingStateImportModel;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class ReferentielServiceImpl
extends FaxToMailServiceSupport
implements ReferentielService {
    @Override
    public List<DemandType> getAllDemandType() {
        DemandTypeTopiaDao dao = this.getPersistenceContext().getDemandTypeDao();
        return dao.forAll().setOrderByArguments(new String[]{"label"}).findAll();
    }

    @Override
    public List<Priority> getAllPriority() {
        PriorityTopiaDao dao = this.getPersistenceContext().getPriorityDao();
        return dao.forAll().setOrderByArguments(new String[]{"label"}).findAll();
    }

    @Override
    public List<Range> getAllRange() {
        RangeTopiaDao dao = this.getPersistenceContext().getRangeDao();
        return dao.forAll().setOrderByArguments(new String[]{"label"}).findAll();
    }

    @Override
    public List<WaitingState> getAllWaitingState() {
        WaitingStateTopiaDao dao = this.getPersistenceContext().getWaitingStateDao();
        return dao.forAll().setOrderByArguments(new String[]{"label"}).findAll();
    }

    @Override
    public Map<String, Long> getWaitingStatesUsage() {
        WaitingStateTopiaDao dao = this.getPersistenceContext().getWaitingStateDao();
        Map result = dao.getWaitingStateCountByFolder();
        return result;
    }

    @Override
    public List<Client> importClients(InputStream inputStream) {
        ArrayList<Client> result = new ArrayList<Client>();
        ClientTopiaDao dao = this.getPersistenceContext().getClientDao();
        ClientImportModel clientImportModel = new ClientImportModel(';');
        Binder clientBinder = BinderFactory.newBinder(ClientImportBean.class, Client.class);
        Import importer = null;
        try {
            importer = Import.newImport((ImportModel)clientImportModel, (Reader)new InputStreamReader(inputStream, this.getApplicationConfig().getImportFileEncoding()));
            MultiKeyMap clientCache = new MultiKeyMap();
            for (ClientImportBean client : importer) {
                Client current = (Client)clientCache.get((Object)client.getCode(), (Object)client.getCompany());
                if (current == null) {
                    current = (Client)dao.forCodeEquals(client.getCode()).addEquals("company", (Object)client.getCompany()).findAnyOrNull();
                    if (current == null) {
                        current = new ClientImpl();
                    }
                    clientBinder.copyExcluding((Object)client, (Object)current, new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
                    current.setEmailAddresses(null);
                    current.setFaxNumbers(null);
                    clientCache.put((Object)client.getCode(), (Object)client.getCompany(), (Object)current);
                }
                if (StringUtils.isNotBlank((CharSequence)client.getEmailAddress())) {
                    ArrayList<String> currentAddresses = current.getEmailAddresses();
                    if (currentAddresses == null) {
                        currentAddresses = new ArrayList<String>();
                    }
                    currentAddresses.add(client.getEmailAddress());
                    current.setEmailAddresses(currentAddresses);
                }
                if (StringUtils.isNotBlank((CharSequence)client.getFaxNumber())) {
                    ArrayList<String> faxNumbers = current.getFaxNumbers();
                    if (faxNumbers == null) {
                        faxNumbers = new ArrayList<String>();
                    }
                    faxNumbers.add(client.getFaxNumber());
                    current.setFaxNumbers(faxNumbers);
                }
                current = client.isPersisted() ? (Client)dao.update((TopiaEntity)current) : (Client)dao.create((TopiaEntity)current);
                result.add(current);
            }
            this.getPersistenceContext().commit();
        }
        catch (UnsupportedEncodingException | ImportRuntimeException e) {
            try {
                String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                throw new ApplicationTechnicalException(message, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(importer);
                IOUtils.closeQuietly((InputStream)inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)importer);
        IOUtils.closeQuietly((InputStream)inputStream);
        return result;
    }

    @Override
    public List<EmailAccount> importEmailAccounts(InputStream inputStream) {
        ArrayList<EmailAccount> result = new ArrayList<EmailAccount>();
        EmailAccountTopiaDao dao = this.getPersistenceContext().getEmailAccountDao();
        EmailAccountImportModel emailAccountImportModel = new EmailAccountImportModel(';');
        try (Import importer = Import.newImport((ImportModel)emailAccountImportModel, (Reader)new InputStreamReader(inputStream, this.getApplicationConfig().getImportFileEncoding()));){
            for (EmailAccount emailAccount : importer) {
                result.add((EmailAccount)dao.create((TopiaEntity)emailAccount));
            }
            this.getPersistenceContext().commit();
        }
        catch (UnsupportedEncodingException | ImportRuntimeException e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new ApplicationTechnicalException(message, e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return result;
    }

    @Override
    public List<MailFilter> importEmailFilters(InputStream inputStream, Map<String, MailFolder> foldersByName) {
        ArrayList<MailFilter> result = new ArrayList<MailFilter>();
        MailFilterTopiaDao dao = this.getPersistenceContext().getMailFilterDao();
        EmailFilterImportModel emailFilterImportModel = new EmailFilterImportModel(';', foldersByName);
        try (Import importer = Import.newImport((ImportModel)emailFilterImportModel, (Reader)new InputStreamReader(inputStream, this.getApplicationConfig().getImportFileEncoding()));){
            for (MailFilter emailFilter : importer) {
                result.add((MailFilter)dao.create((TopiaEntity)emailFilter));
            }
            this.getPersistenceContext().commit();
        }
        catch (UnsupportedEncodingException | ImportRuntimeException e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new ApplicationTechnicalException(message, e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return result;
    }

    @Override
    public List<WaitingState> importWaitingStates(InputStream inputStream) {
        ArrayList<WaitingState> result = new ArrayList<WaitingState>();
        WaitingStateTopiaDao waitingStateTopiaDao = this.getPersistenceContext().getWaitingStateDao();
        WaitingStateImportModel importModel = new WaitingStateImportModel(';');
        try (Import importer = Import.newImport((ImportModel)importModel, (Reader)new InputStreamReader(inputStream, this.getApplicationConfig().getImportFileEncoding()));){
            for (WaitingState waitingState : importer) {
                WaitingState currentWaitingState = (WaitingState)waitingStateTopiaDao.forLabelEquals(waitingState.getLabel()).findAnyOrNull();
                if (currentWaitingState == null) {
                    currentWaitingState = (WaitingState)waitingStateTopiaDao.create((TopiaEntity)waitingState);
                }
                result.add(currentWaitingState);
            }
            this.getPersistenceContext().commit();
        }
        catch (UnsupportedEncodingException | ImportRuntimeException e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new ApplicationTechnicalException(message, e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return result;
    }

    @Override
    public List<Priority> importPriorities(InputStream inputStream) {
        ArrayList<Priority> result = new ArrayList<Priority>();
        PriorityTopiaDao priorityTopiaDao = this.getPersistenceContext().getPriorityDao();
        PriorityImportModel importModel = new PriorityImportModel(';');
        try (Import importer = Import.newImport((ImportModel)importModel, (Reader)new InputStreamReader(inputStream, this.getApplicationConfig().getImportFileEncoding()));){
            for (Priority priority : importer) {
                Priority currentPriority = (Priority)priorityTopiaDao.forLabelEquals(priority.getLabel()).findAnyOrNull();
                if (currentPriority == null) {
                    currentPriority = (Priority)priorityTopiaDao.create((TopiaEntity)priority);
                }
                result.add(currentPriority);
            }
            this.getPersistenceContext().commit();
        }
        catch (UnsupportedEncodingException | ImportRuntimeException e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new ApplicationTechnicalException(message, e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return result;
    }

    @Override
    public List<Range> importRanges(InputStream inputStream) {
        ArrayList<Range> result = new ArrayList<Range>();
        RangeTopiaDao rangeTopiaDao = this.getPersistenceContext().getRangeDao();
        RangeImportModel importModel = new RangeImportModel(';');
        try (Import importer = Import.newImport((ImportModel)importModel, (Reader)new InputStreamReader(inputStream, this.getApplicationConfig().getImportFileEncoding()));){
            for (Range range : importer) {
                Range currentRange = (Range)rangeTopiaDao.forLabelEquals(range.getLabel()).findAnyOrNull();
                if (currentRange == null) {
                    currentRange = (Range)rangeTopiaDao.create((TopiaEntity)range);
                }
                result.add(currentRange);
            }
            this.getPersistenceContext().commit();
        }
        catch (UnsupportedEncodingException | ImportRuntimeException e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new ApplicationTechnicalException(message, e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return result;
    }

    @Override
    public List<DemandType> importDemandTypes(InputStream inputStream) {
        ArrayList<DemandType> result = new ArrayList<DemandType>();
        DemandTypeTopiaDao demandTypeTopiaDao = this.getPersistenceContext().getDemandTypeDao();
        DemandTypeImportModel importModel = new DemandTypeImportModel(';');
        try (Import importer = Import.newImport((ImportModel)importModel, (Reader)new InputStreamReader(inputStream, this.getApplicationConfig().getImportFileEncoding()));){
            for (DemandType demandType : importer) {
                DemandType currentDemandType = (DemandType)demandTypeTopiaDao.forLabelEquals(demandType.getLabel()).findAnyOrNull();
                if (currentDemandType == null) {
                    currentDemandType = (DemandType)demandTypeTopiaDao.create((TopiaEntity)demandType);
                }
                result.add(currentDemandType);
            }
            this.getPersistenceContext().commit();
        }
        catch (UnsupportedEncodingException | ImportRuntimeException e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new ApplicationTechnicalException(message, e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return result;
    }
}

