package com.franciaflex.faxtomail.services.service;

/*
 * #%L
 * FaxToMail :: Service
 * $Id: UserService.java 122 2014-06-02 18:45:22Z echatellier $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.2/faxtomail-service/src/main/java/com/franciaflex/faxtomail/services/service/UserService.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.List;

import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroup;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroupTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserTopiaDao;
import com.franciaflex.faxtomail.services.FaxToMailServiceSupport;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since x.x
 */
public class UserService extends FaxToMailServiceSupport {

    public List<FaxToMailUser> getAllUsers() {
        FaxToMailUserTopiaDao dao = getPersistenceContext().getFaxToMailUserDao();
        return new ArrayList<>(dao.findAll());
    }

    public FaxToMailUser getUserByLogin(String login) {
        FaxToMailUserTopiaDao dao = getPersistenceContext().getFaxToMailUserDao();
        FaxToMailUser user = dao.forLoginEquals(login).findUnique();
        return user;
    }

    public List<FaxToMailUserGroup> getAllUserGroups() {
        FaxToMailUserGroupTopiaDao dao = getPersistenceContext().getFaxToMailUserGroupDao();
        return new ArrayList<>(dao.findAll());
    }
}
