/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.persistence.entities;

import com.franciaflex.faxtomail.persistence.entities.AbstractEmailTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.DemandType;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EmailFilter;
import com.franciaflex.faxtomail.persistence.entities.EmailGroup;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.History;
import com.franciaflex.faxtomail.persistence.entities.HistoryType;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.Priority;
import com.franciaflex.faxtomail.persistence.entities.Range;
import com.franciaflex.faxtomail.persistence.entities.RangeRow;
import com.franciaflex.faxtomail.persistence.entities.SearchFilter;
import com.franciaflex.faxtomail.persistence.entities.WaitingState;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.nuiton.topia.persistence.TopiaEntities;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.pagination.PaginationParameter;
import org.nuiton.util.pagination.PaginationResult;

public class EmailTopiaDao
extends AbstractEmailTopiaDao<Email> {
    private static final Log log = LogFactory.getLog(EmailTopiaDao.class);

    public PaginationResult<Email> search(SearchFilter searchFilter, Set<MailFolder> readMailFolders, PaginationParameter pagination) {
        List<Object> sortedEntities;
        List<Range> gamme;
        List<WaitingState> waitingStates;
        List<DemandStatus> demandStatus;
        List<Priority> priority;
        List<DemandType> demandType;
        Date date;
        StringBuilder query = new StringBuilder();
        HashMap<String, Object> args = new HashMap<String, Object>();
        query.append(" WHERE E.mailFolder in (:readMailFolders)");
        args.put("readMailFolders", readMailFolders);
        if (searchFilter.getMinReceptionDate() != null) {
            date = DateUtils.truncate((Date)searchFilter.getMinReceptionDate(), (int)5);
            query.append(" AND E.receptionDate >= :minReceptionDate");
            args.put("minReceptionDate", date);
        }
        if (searchFilter.getMaxReceptionDate() != null) {
            date = DateUtils.ceiling((Date)searchFilter.getMaxReceptionDate(), (int)5);
            query.append(" AND E.receptionDate <= :maxReceptionDate");
            args.put("maxReceptionDate", date);
        }
        if (searchFilter.getTakenBy() != null) {
            query.append(" AND E.takenBy = :takenBy");
            args.put("takenBy", searchFilter.getTakenBy());
        }
        if (searchFilter.getMinModificationDate() != null || searchFilter.getModifiedBy() != null) {
            query.append(" AND EXISTS (FROM " + History.class.getName() + " H WHERE H in elements(E." + "history" + ")");
            query.append("   AND H.type = :modificationType");
            args.put("modificationType", HistoryType.MODIFICATION);
            if (searchFilter.getMinModificationDate() != null) {
                date = DateUtils.truncate((Date)searchFilter.getMinModificationDate(), (int)5);
                query.append("   AND H.modificationDate >= :minModificationDate");
                args.put("minModificationDate", date);
            }
            if (searchFilter.getModifiedBy() != null) {
                query.append("   AND H.faxToMailUser = :modifiedBy");
                args.put("modifiedBy", searchFilter.getModifiedBy());
            }
            query.append(")");
        }
        if (searchFilter.getMaxModificationDate() != null || searchFilter.getModifiedBy() != null) {
            query.append(" AND EXISTS (FROM " + History.class.getName() + " H WHERE H in elements(E." + "history" + ")");
            query.append("   AND H.type = :modificationType");
            args.put("modificationType", HistoryType.MODIFICATION);
            if (searchFilter.getMaxModificationDate() != null) {
                date = DateUtils.ceiling((Date)searchFilter.getMaxModificationDate(), (int)5);
                query.append("   AND H.modificationDate <= :maxModificationDate");
                args.put("maxModificationDate", date);
            }
            if (searchFilter.getModifiedBy() != null) {
                query.append("   AND H.faxToMailUser = :modifiedBy");
                args.put("modifiedBy", searchFilter.getModifiedBy());
            }
            query.append(")");
        }
        if (searchFilter.getMinTransferDate() != null || searchFilter.getTransferBy() != null) {
            query.append(" AND EXISTS (FROM " + History.class.getName() + " H WHERE H in elements(E." + "history" + ")");
            query.append("   AND H.type = :transmissionType");
            args.put("transmissionType", HistoryType.TRANSMISSION);
            if (searchFilter.getMinTransferDate() != null) {
                date = DateUtils.truncate((Date)searchFilter.getMinTransferDate(), (int)5);
                query.append("   AND H.modificationDate >= :minTransferDate");
                args.put("minTransferDate", date);
            }
            if (searchFilter.getTransferBy() != null) {
                query.append("   AND H.faxToMailUser = :transferBy");
                args.put("transferBy", searchFilter.getTransferBy());
            }
            query.append(")");
        }
        if (searchFilter.getMaxTransferDate() != null || searchFilter.getTransferBy() != null) {
            query.append(" AND EXISTS (FROM " + History.class.getName() + " H WHERE H in elements(E." + "history" + ")");
            query.append("   AND H.type = :transmissionType");
            args.put("transmissionType", HistoryType.TRANSMISSION);
            if (searchFilter.getMaxTransferDate() != null) {
                date = DateUtils.ceiling((Date)searchFilter.getMaxTransferDate(), (int)5);
                query.append("   AND H.modificationDate <= :maxTransferDate");
                args.put("maxTransferDate", date);
            }
            if (searchFilter.getTransferBy() != null) {
                query.append("   AND H.faxToMailUser = :transferBy");
                args.put("transferBy", searchFilter.getTransferBy());
            }
            query.append(")");
        }
        if (searchFilter.getMinArchivedDate() != null || searchFilter.getArchivedBy() != null) {
            query.append(" AND EXISTS (FROM " + History.class.getName() + " H WHERE H in elements(E." + "history" + ")");
            query.append("   AND H.type = :archivedType");
            args.put("archivedType", HistoryType.ARCHIVED);
            if (searchFilter.getMinArchivedDate() != null) {
                date = DateUtils.truncate((Date)searchFilter.getMinArchivedDate(), (int)5);
                query.append("   AND H.modificationDate >= :minArchivedDate");
                args.put("minArchivedDate", date);
            }
            if (searchFilter.getArchivedBy() != null) {
                query.append("   AND H.faxToMailUser = :archivedBy");
                args.put("archivedBy", searchFilter.getArchivedBy());
            }
            query.append(")");
        }
        if (searchFilter.getMaxArchivedDate() != null || searchFilter.getArchivedBy() != null) {
            query.append(" AND EXISTS (FROM " + History.class.getName() + " H WHERE H in elements(E." + "history" + ")");
            query.append("   AND H.type = :archivedType");
            args.put("archivedType", HistoryType.ARCHIVED);
            if (searchFilter.getMaxArchivedDate() != null) {
                date = DateUtils.ceiling((Date)searchFilter.getMaxArchivedDate(), (int)5);
                query.append("   AND H.modificationDate <= :maxArchivedDate");
                args.put("maxArchivedDate", date);
            }
            if (searchFilter.getArchivedBy() != null) {
                query.append("   AND H.faxToMailUser = :archivedBy");
                args.put("archivedBy", searchFilter.getArchivedBy());
            }
            query.append(")");
        }
        if (searchFilter.getMinPrintingDate() != null || searchFilter.getPrintingBy() != null) {
            query.append(" AND EXISTS (FROM " + History.class.getName() + " H WHERE H in elements(E." + "history" + ")");
            query.append("   AND H.type = :printingType");
            args.put("printingType", HistoryType.PRINTING);
            if (searchFilter.getMinPrintingDate() != null) {
                date = DateUtils.truncate((Date)searchFilter.getMinPrintingDate(), (int)5);
                query.append("   AND H.modificationDate >= :minPrintingDate");
                args.put("minPrintingDate", date);
            }
            if (searchFilter.getPrintingBy() != null) {
                query.append("   AND H.faxToMailUser = :printingBy");
                args.put("printingBy", searchFilter.getPrintingBy());
            }
            query.append(")");
        }
        if (searchFilter.getMaxPrintingDate() != null || searchFilter.getPrintingBy() != null) {
            query.append(" AND EXISTS (FROM " + History.class.getName() + " H WHERE H in elements(E." + "history" + ")");
            query.append("   AND H.type = :printingType");
            args.put("printingType", HistoryType.PRINTING);
            if (searchFilter.getMaxPrintingDate() != null) {
                date = DateUtils.ceiling((Date)searchFilter.getMaxPrintingDate(), (int)5);
                query.append("   AND H.modificationDate <= :maxPrintingDate");
                args.put("maxPrintingDate", date);
            }
            if (searchFilter.getPrintingBy() != null) {
                query.append("   AND H.faxToMailUser = :printingBy");
                args.put("printingBy", searchFilter.getPrintingBy());
            }
            query.append(")");
        }
        if (searchFilter.getMinReplyDate() != null || searchFilter.getReplyBy() != null) {
            query.append(" AND EXISTS (FROM " + History.class.getName() + " H WHERE H in elements(E." + "history" + ")");
            query.append("   AND H.type = :replyType");
            args.put("replyType", HistoryType.REPLY);
            if (searchFilter.getMinReplyDate() != null) {
                date = DateUtils.truncate((Date)searchFilter.getMinReplyDate(), (int)5);
                query.append("   AND H.modificationDate >= :minReplyDate");
                args.put("minReplyDate", date);
            }
            if (searchFilter.getReplyBy() != null) {
                query.append("   AND H.faxToMailUser = :replyBy");
                args.put("replyBy", searchFilter.getReplyBy());
            }
            query.append(")");
        }
        if (searchFilter.getMaxReplyDate() != null || searchFilter.getReplyBy() != null) {
            query.append(" AND EXISTS (FROM " + History.class.getName() + " H WHERE H in elements(E." + "history" + ")");
            query.append("   AND H.type = :replyType");
            args.put("replyType", HistoryType.REPLY);
            if (searchFilter.getMaxReplyDate() != null) {
                date = DateUtils.ceiling((Date)searchFilter.getMaxReplyDate(), (int)5);
                query.append("   AND H.modificationDate <= :maxReplyDate");
                args.put("maxReplyDate", date);
            }
            if (searchFilter.getReplyBy() != null) {
                query.append("   AND H.faxToMailUser = :replyBy");
                args.put("replyBy", searchFilter.getReplyBy());
            }
            query.append(")");
        }
        if (StringUtils.isNotBlank((CharSequence)searchFilter.getSender())) {
            query.append(" AND lower(E.sender) LIKE lower(:sender)");
            args.put("sender", "%" + searchFilter.getSender() + "%");
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{searchFilter.getClientCode()})) {
            query.append(" AND lower(E.client.code) LIKE lower(:clientCode)");
            args.put("clientCode", "%" + searchFilter.getClientCode() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)searchFilter.getDemandObject())) {
            query.append(" AND lower(E.object) LIKE lower(:demandObject)");
            args.put("demandObject", "%" + searchFilter.getDemandObject() + "%");
        }
        if (CollectionUtils.isNotEmpty(demandType = searchFilter.getDemandType())) {
            query.append(" AND (E.demandType IN (:demandType)");
            args.put("demandType", demandType);
            if (demandType.contains(null)) {
                query.append(" OR E.demandType IS NULL");
            }
            query.append(")");
        }
        if (StringUtils.isNotBlank((CharSequence)searchFilter.getEdiCodeNumber())) {
            query.append(" AND lower(E.ediError) LIKE lower(:ediCodeNumber)");
            args.put("ediCodeNumber", "%" + searchFilter.getEdiCodeNumber() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)searchFilter.getProjectReference())) {
            query.append(" AND lower(E.projectReference) LIKE lower(:projectReference)");
            args.put("projectReference", "%" + searchFilter.getProjectReference() + "%");
        }
        if (CollectionUtils.isNotEmpty(priority = searchFilter.getPriority())) {
            query.append(" AND (E.priority IN (:priority)");
            args.put("priority", priority);
            if (priority.contains(null)) {
                query.append(" OR E.priority IS NULL");
            }
            query.append(")");
        }
        if (CollectionUtils.isNotEmpty(demandStatus = searchFilter.getDemandStatus())) {
            query.append(" AND (E.demandStatus IN (:demandStatus)");
            args.put("demandStatus", demandStatus);
            if (demandStatus.contains(null)) {
                query.append(" OR E.demandStatus IS NULL");
            }
            query.append(")");
        }
        if (CollectionUtils.isNotEmpty(waitingStates = searchFilter.getWaitingStates())) {
            query.append(" AND (E.waitingState IN (:WaitingStates)");
            args.put("WaitingStates", waitingStates);
            if (waitingStates.contains(null)) {
                query.append(" OR E.waitingState IS NULL");
            }
            query.append(")");
        }
        if (StringUtils.isNotBlank((CharSequence)searchFilter.getMessage())) {
            query.append(" AND lower(E.comment) LIKE lower(:message)");
            args.put("message", "%" + searchFilter.getMessage() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)searchFilter.getBody())) {
            query.append(" AND lower(E.originalEmail.content) LIKE lower(:body)");
            args.put("body", "%" + searchFilter.getBody() + "%");
        }
        if (CollectionUtils.isNotEmpty(gamme = searchFilter.getGamme())) {
            query.append(" AND ((EXISTS (FROM " + RangeRow.class.getName() + " RR WHERE RR in elements(E." + "rangeRow" + ")");
            query.append("   AND RR.range IN (:gamme))");
            args.put("gamme", gamme);
            if (gamme.contains(null)) {
                query.append(" OR NOT EXISTS (FROM " + RangeRow.class.getName() + " RR WHERE RR in elements(E." + "rangeRow" + "))");
            }
            query.append("))");
        }
        if (StringUtils.isNotBlank((CharSequence)searchFilter.getLocalReference())) {
            query.append(" AND (EXISTS (FROM " + RangeRow.class.getName() + " RR WHERE RR in elements(E." + "rangeRow" + ")");
            query.append("   AND lower(RR.commandNumber) LIKE lower(:localReference))");
            query.append(" OR lower(E.companyReference) LIKE lower(:localReference)");
            args.put("localReference", "%" + searchFilter.getLocalReference() + "%");
            query.append(")");
        }
        if (StringUtils.isNotBlank((CharSequence)searchFilter.getCommandNb())) {
            query.append(" AND (EXISTS (FROM " + RangeRow.class.getName() + " RR WHERE RR in elements(E." + "rangeRow" + ")");
            query.append("   AND lower(RR.commandNumber) LIKE lower(:commandNb))");
            query.append(" OR lower(E.companyReference) LIKE lower(:commandNb)");
            args.put("commandNb", "%" + searchFilter.getCommandNb() + "%");
            query.append(")");
        }
        String hqlForFetchStep1 = "SELECT E.topiaId FROM " + Email.class.getName() + " E " + "WHERE E." + "topiaId" + " IN (";
        hqlForFetchStep1 = searchFilter.isAddGroupDemands() ? hqlForFetchStep1 + "SELECT CASE WHEN G IS NULL THEN E.topiaId ELSE E2.topiaId END FROM " + Email.class.getName() + " E " + "LEFT OUTER JOIN E." + "emailGroup" + " AS G " + "LEFT OUTER JOIN G." + "email" + " AS E2 " : hqlForFetchStep1 + "select E.topiaId FROM " + Email.class.getName() + " E ";
        hqlForFetchStep1 = hqlForFetchStep1 + query.toString() + ")";
        String hqlForFetchStep2 = "select distinct E FROM " + Email.class.getName() + " E " + this.addAllFecthes("priority", "demandType", "client", "waitingState", "takenBy", "lastAttachmentOpener") + " WHERE E." + "topiaId" + " in ( :topiaIdsForFetch_ )";
        PaginationResult pageResult = this.findPage(hqlForFetchStep1, args, pagination);
        List step1ResultTopiaIds = pageResult.getElements();
        if (CollectionUtils.isEmpty((Collection)step1ResultTopiaIds)) {
            sortedEntities = Lists.newArrayList();
        } else {
            HashMap step2Args = Maps.newHashMap();
            step2Args.put("topiaIdsForFetch_", step1ResultTopiaIds);
            List entities = this.forHql(hqlForFetchStep2, step2Args).findAll();
            sortedEntities = this.sortAccordingToIds(entities, step1ResultTopiaIds);
        }
        PaginationResult result = PaginationResult.of((List)sortedEntities, (long)pageResult.getCount(), (PaginationParameter)pageResult.getCurrentPage());
        for (Email email : result.getElements()) {
            List<RangeRow> rangeRows = email.getRangeRow();
            if (rangeRows != null) {
                for (RangeRow rangeRow : rangeRows) {
                    Hibernate.initialize((Object)rangeRow.getRange());
                }
            }
            Hibernate.initialize(email.getReplies());
            Hibernate.initialize(email.getAttachment());
            EmailGroup emailGroup = email.getEmailGroup();
            if (emailGroup == null) continue;
            Hibernate.initialize(emailGroup.getEmail());
            for (Email groupedEmail : emailGroup.getEmail()) {
                Hibernate.initialize((Object)groupedEmail.getMailFolder());
                Hibernate.initialize(groupedEmail.getAttachment());
            }
        }
        return result;
    }

    public Collection<Email> findArchivedEmails(String commandQuotationNumber, Collection<MailFolder> folders) {
        StringBuilder query = new StringBuilder();
        HashMap<String, Object> args = new HashMap<String, Object>();
        HashSet<Email> result = new HashSet<Email>();
        query.append(this.newFromClause("E") + " WHERE E." + "mailFolder" + " in (:folders)");
        args.put("folders", folders);
        query.append(" AND E.demandStatus = :archiveStatus");
        args.put("archiveStatus", DemandStatus.ARCHIVED);
        StringBuilder query1 = new StringBuilder(query);
        query1.append(" AND (EXISTS (FROM " + RangeRow.class.getName() + " RR WHERE RR in elements(E." + "rangeRow" + ")");
        query1.append("   AND lower(RR.commandNumber) LIKE lower(:commandNb))");
        args.put("commandNb", "%" + commandQuotationNumber + "%");
        query1.append(")");
        result.addAll(this.findAll(query1.toString(), args));
        StringBuilder query2 = new StringBuilder(query);
        query2.append(" AND (lower(E.companyReference) LIKE lower(:commandNb)");
        query2.append(")");
        result.addAll(this.findAll(query2.toString(), args));
        return result;
    }

    public PaginationResult<Email> getEmailForFolder(EmailFilter emailFilter, MailFolder folder, PaginationParameter pagination) {
        List<Object> sortedEntities;
        List step1ResultTopiaIds;
        long start = new Date().getTime();
        HashMap<String, Object> args = new HashMap<String, Object>();
        String query = this.filteredDemandsOfFolderCondition(folder, emailFilter, args);
        String hqlForFetchStep1 = "select E.topiaId FROM " + Email.class.getName() + " E " + query;
        if (log.isTraceEnabled()) {
            log.trace((Object)("getEmailForFolder 1 - " + hqlForFetchStep1));
        }
        String hqlForFetchStep2 = "select distinct E FROM " + Email.class.getName() + " E " + this.addAllFecthes("priority", "demandType", "client", "waitingState", "takenBy", "lastAttachmentOpener") + " WHERE E." + "topiaId" + " in ( :topiaIdsForFetch_ )";
        if (log.isTraceEnabled()) {
            log.trace((Object)("getEmailForFolder 2 - " + hqlForFetchStep2));
        }
        long time = new Date().getTime();
        if (log.isTraceEnabled()) {
            log.trace((Object)("getEmailForFolder start query 1 : " + time));
        }
        PaginationResult pageResult = this.findPage(hqlForFetchStep1, args, pagination);
        long time2 = new Date().getTime();
        if (log.isTraceEnabled()) {
            log.trace((Object)("getEmailForFolder end query 1 : " + time2 + " (" + (time2 - time) + ")"));
        }
        if (CollectionUtils.isEmpty((Collection)(step1ResultTopiaIds = pageResult.getElements()))) {
            sortedEntities = Lists.newArrayList();
        } else {
            HashMap step2Args = Maps.newHashMap();
            step2Args.put("topiaIdsForFetch_", step1ResultTopiaIds);
            time = new Date().getTime();
            if (log.isTraceEnabled()) {
                log.trace((Object)("getEmailForFolder start query 2 : " + time));
            }
            List entities = this.forHql(hqlForFetchStep2, step2Args).findAll();
            time2 = new Date().getTime();
            if (log.isTraceEnabled()) {
                log.trace((Object)("getEmailForFolder end query 2 : " + time2 + " (" + (time2 - time) + ")"));
            }
            sortedEntities = this.sortAccordingToIds(entities, step1ResultTopiaIds);
            long time3 = new Date().getTime();
            if (log.isTraceEnabled()) {
                log.trace((Object)("getEmailForFolder sort query 2 : " + time3 + " (" + (time3 - time2) + ")"));
            }
        }
        time = new Date().getTime();
        if (log.isDebugEnabled()) {
            log.trace((Object)("getEmailForFolder init results : " + time));
        }
        PaginationResult result = PaginationResult.of((List)sortedEntities, (long)pageResult.getCount(), (PaginationParameter)pageResult.getCurrentPage());
        time2 = new Date().getTime();
        if (log.isTraceEnabled()) {
            log.trace((Object)("getEmailForFolder after pagination results : " + time2 + " (" + (time2 - time) + ")"));
        }
        for (Email email : result.getElements()) {
            List<RangeRow> rangeRows = email.getRangeRow();
            if (rangeRows != null) {
                for (RangeRow rangeRow : rangeRows) {
                    Hibernate.initialize((Object)rangeRow.getRange());
                }
            }
            Hibernate.initialize(email.getReplies());
            Hibernate.initialize(email.getAttachment());
            EmailGroup emailGroup = email.getEmailGroup();
            if (emailGroup == null) continue;
            Hibernate.initialize(emailGroup.getEmail());
            for (Email groupedEmail : emailGroup.getEmail()) {
                Hibernate.initialize((Object)groupedEmail.getMailFolder());
                Hibernate.initialize(groupedEmail.getAttachment());
            }
        }
        long time3 = new Date().getTime();
        if (log.isTraceEnabled()) {
            log.trace((Object)("getEmailForFolder after hibernate initializing : " + time3 + " (" + (time3 - time2) + ")"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getEmailFolder total : " + (time3 - start)));
        }
        return result;
    }

    protected String filteredDemandsOfFolderCondition(MailFolder folder, EmailFilter emailFilter, Map<String, Object> args) {
        Set<WaitingState> waitingStates;
        Set<String> references;
        Set<String> localReferences;
        Set<String> projectReferences;
        Set<Long> quotationQuantities;
        Set<Long> savQuantities;
        Set<Long> productQuantities;
        Set<Range> ranges;
        Set<Priority> priorities;
        Set<String> recipients;
        Set<FaxToMailUser> lastAttachmentOpeners;
        Set<FaxToMailUser> takenBys;
        Set<String> ediCodeNumbers;
        Set<DemandType> demandTypes;
        Set<String> demandObjects;
        Set<String> comments;
        Set<String> clientCodes;
        Set<String> clientBrands;
        Set<String> senders;
        Set<DemandStatus> demandStatus;
        StringBuilder query = new StringBuilder();
        query.append(" WHERE E.mailFolder = :folder AND E.demandStatus != :archiveStatus");
        args.put("folder", folder);
        args.put("archiveStatus", DemandStatus.ARCHIVED);
        Set<Date> receptionDates = emailFilter.getReceptionDates();
        if (receptionDates != null) {
            query.append(" AND (");
            int i = 0;
            for (Date date : receptionDates) {
                query.append(" E.receptionDate BETWEEN :receptionDates" + i + "Min");
                query.append(" AND :receptionDates" + i + "Max");
                args.put("receptionDates" + i + "Min", date);
                args.put("receptionDates" + i + "Max", DateUtils.addMinutes((Date)date, (int)1));
                if (i++ >= receptionDates.size() - 1) continue;
                query.append(" OR");
            }
            query.append(")");
        }
        if ((demandStatus = emailFilter.getDemandStatus()) != null) {
            query.append(" AND (E.demandStatus in (:demandStatus)");
            args.put("demandStatus", demandStatus);
            if (demandStatus.contains(null)) {
                query.append(" OR E.demandStatus IS NULL");
            }
            query.append(")");
        }
        if ((senders = emailFilter.getSenders()) != null) {
            query.append(" AND (E.sender in (:senders)");
            args.put("senders", senders);
            if (senders.contains(null)) {
                query.append(" OR E.sender IS NULL");
            }
            query.append(")");
        }
        if ((clientBrands = emailFilter.getClientBrands()) != null) {
            query.append(" AND (E.client.brand IN (:clientBrands)");
            args.put("clientBrands", clientBrands);
            if (clientBrands.contains(null)) {
                query.append(" OR E.client IS NULL");
                query.append(" OR E.client.brand IS NULL");
            }
            query.append(")");
        }
        if ((clientCodes = emailFilter.getClientCodes()) != null) {
            query.append(" AND (E.client.code IN (:clientCodes)");
            args.put("clientCodes", clientCodes);
            if (clientCodes.contains(null)) {
                query.append(" OR E.client IS NULL");
                query.append(" OR E.client.code IS NULL");
            }
            query.append(")");
        }
        if ((comments = emailFilter.getComments()) != null) {
            query.append(" AND (E.comment in (:comments)");
            args.put("comments", comments);
            if (comments.contains(null)) {
                query.append(" OR E.comment IS NULL");
            }
            query.append(")");
        }
        if ((demandObjects = emailFilter.getDemandObjects()) != null) {
            query.append(" AND (E.object in (:demandObjects)");
            args.put("demandObjects", demandObjects);
            if (demandObjects.contains(null)) {
                query.append(" OR E.object IS NULL");
            }
            query.append(")");
        }
        if ((demandTypes = emailFilter.getDemandTypes()) != null) {
            query.append(" AND (E.demandType in (:demandTypes)");
            args.put("demandTypes", demandTypes);
            if (demandTypes.contains(null)) {
                query.append(" OR E.demandType IS NULL");
            }
            query.append(")");
        }
        if ((ediCodeNumbers = emailFilter.getEdiCodeNumbers()) != null) {
            query.append(" AND (E.ediError in (:ediCodeNumbers)");
            args.put("ediCodeNumbers", ediCodeNumbers);
            if (ediCodeNumbers.contains(null)) {
                query.append(" OR E.ediError IS NULL");
            }
            query.append(")");
        }
        if ((takenBys = emailFilter.getTakenBys()) != null) {
            query.append(" AND (E.takenBy in (:takenBys)");
            args.put("takenBys", takenBys);
            if (takenBys.contains(null)) {
                query.append(" OR E.takenBy IS NULL");
            }
            query.append(")");
        }
        if ((lastAttachmentOpeners = emailFilter.getLastAttachmentOpeners()) != null) {
            query.append(" AND (E.lastAttachmentOpener in (:lastAttachmentOpeners)");
            args.put("lastAttachmentOpeners", lastAttachmentOpeners);
            if (lastAttachmentOpeners.contains(null)) {
                query.append(" OR E.lastAttachmentOpener IS NULL");
            }
            query.append(")");
        }
        if ((recipients = emailFilter.getRecipients()) != null) {
            query.append(" AND (E.recipient in (:recipients)");
            args.put("recipients", recipients);
            if (recipients.contains(null)) {
                query.append(" OR E.recipient IS NULL");
            }
            query.append(")");
        }
        if ((priorities = emailFilter.getPriorities()) != null) {
            query.append(" AND (E.priority in (:priorities)");
            args.put("priorities", priorities);
            if (priorities.contains(null)) {
                query.append(" OR E.priority IS NULL");
            }
            query.append(")");
        }
        if (CollectionUtils.isNotEmpty(ranges = emailFilter.getRanges())) {
            query.append(" AND ((EXISTS (FROM " + RangeRow.class.getName() + " RR WHERE RR in elements(E." + "rangeRow" + "))" + " AND (select count(*) FROM " + RangeRow.class.getName() + " RR" + " WHERE RR in elements(E." + "rangeRow" + ") AND RR." + "range" + " IN (:" + "ranges" + ")");
            query.append(") > 0");
            if (ranges.contains(null)) {
                query.append(" OR NOT EXISTS (FROM " + RangeRow.class.getName() + " RR WHERE RR in elements(E." + "rangeRow" + "))");
            }
            query.append("))");
            args.put("ranges", ranges);
        }
        if (CollectionUtils.isNotEmpty(productQuantities = emailFilter.getProductsQuantities())) {
            query.append(" AND ((EXISTS (FROM " + RangeRow.class.getName() + " RR WHERE RR in elements(E." + "rangeRow" + "))" + " AND (select sum(RR." + "productQuantity" + ") " + "FROM " + RangeRow.class.getName() + " RR WHERE RR in elements(E." + "rangeRow" + ")");
            query.append(") IN (:productsQuantities)");
            if (productQuantities.contains(null) || productQuantities.contains(0L)) {
                query.append(" OR NOT EXISTS (FROM " + RangeRow.class.getName() + " RR WHERE RR in elements(E." + "rangeRow" + "))");
            }
            query.append("))");
            args.put("productsQuantities", productQuantities);
        }
        if (CollectionUtils.isNotEmpty(savQuantities = emailFilter.getSavQuantities())) {
            query.append(" AND ((EXISTS (FROM " + RangeRow.class.getName() + " RR WHERE RR in elements(E." + "rangeRow" + "))" + " AND (select sum(RR." + "savQuantity" + ") " + "FROM " + RangeRow.class.getName() + " RR WHERE RR in elements(E." + "rangeRow" + ")");
            query.append(") IN (:savQuantities)");
            if (savQuantities.contains(null) || savQuantities.contains(0L)) {
                query.append(" OR NOT EXISTS (FROM " + RangeRow.class.getName() + " RR WHERE RR in elements(E." + "rangeRow" + "))");
            }
            query.append("))");
            args.put("savQuantities", savQuantities);
        }
        if (CollectionUtils.isNotEmpty(quotationQuantities = emailFilter.getQuotationQuantities())) {
            query.append(" AND ((EXISTS (FROM " + RangeRow.class.getName() + " RR WHERE RR in elements(E." + "rangeRow" + "))" + " AND (select sum(RR." + "quotationQuantity" + ") " + "FROM " + RangeRow.class.getName() + " RR WHERE RR in elements(E." + "rangeRow" + ")");
            query.append(") IN (:quotationQuantities)");
            if (quotationQuantities.contains(null) || quotationQuantities.contains(0L)) {
                query.append(" OR NOT EXISTS (FROM " + RangeRow.class.getName() + " RR WHERE RR in elements(E." + "rangeRow" + "))");
            }
            query.append("))");
            args.put("quotationQuantities", quotationQuantities);
        }
        if ((projectReferences = emailFilter.getProjectReferences()) != null) {
            query.append(" AND (E.projectReference in (:projectReferences)");
            args.put("projectReferences", projectReferences);
            if (projectReferences.contains(null)) {
                query.append(" OR E.projectReference IS NULL");
            }
            query.append(")");
        }
        if ((localReferences = emailFilter.getLocalReferences()) != null) {
            query.append(" AND (E.companyReference in (:localReferences)");
            args.put("localReferences", localReferences);
            if (localReferences.contains(null)) {
                query.append(" OR E.companyReference IS NULL");
            }
            query.append(")");
        }
        if ((references = emailFilter.getReferences()) != null) {
            query.append(" AND ((EXISTS (FROM " + RangeRow.class.getName() + " RR WHERE RR in elements(E." + "rangeRow" + ")");
            query.append("   AND RR.commandNumber IN (:localReferences))");
            query.append(" OR E.companyReference IN (:localReferences)");
            args.put("localReferences", references);
            if (references.contains(null)) {
                query.append(" OR (NOT EXISTS (FROM " + RangeRow.class.getName() + " RR WHERE RR in elements(E." + "rangeRow" + "))");
                query.append(" AND E.companyReference IS NULL)");
            }
            query.append("))");
        }
        if ((waitingStates = emailFilter.getWaitingStates()) != null) {
            query.append(" AND (E.waitingState in (:waitingStates)");
            args.put("waitingStates", waitingStates);
            if (waitingStates.contains(null)) {
                query.append(" OR E.waitingState IS NULL");
            }
            query.append(")");
        }
        return query.toString();
    }

    public Map<String, Long> getMailCountByFolder() {
        String query = "SELECT mailFolder.topiaId, count(*) FROM " + Email.class.getName() + " group by mailFolder.topiaId";
        HashMap<String, Long> result = new HashMap<String, Long>();
        List queryResuts = this.findAll(query);
        for (Object[] queryResut : queryResuts) {
            String mailFolder = (String)queryResut[0];
            Long count = (Long)queryResut[1];
            result.put(mailFolder, count);
        }
        return result;
    }

    public Map<String, Long[]> computeQuantitiesByRange(List<MailFolder> folders) {
        String query = "SELECT range.topiaId, SUM(rangeRow.productQuantity) AS prodQ, SUM(rangeRow.savQuantity) AS savQ, SUM(rangeRow.quotationQuantity) AS quotQ FROM " + Email.class.getName() + " AS email " + " INNER JOIN email." + "rangeRow" + " AS rangeRow" + " INNER JOIN rangeRow." + "range" + " AS range" + " WHERE email." + "mailFolder" + " IN :folders" + " GROUP BY range." + "topiaId";
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("folders", folders);
        LinkedHashMap<String, Long[]> result = new LinkedHashMap<String, Long[]>();
        List queryResuts = this.findAll(query, args);
        for (Object[] queryResut : queryResuts) {
            String range = (String)queryResut[0];
            Long[] sums = new Long[]{(Long)queryResut[1], (Long)queryResut[2], (Long)queryResut[3]};
            result.put(range, sums);
        }
        return result;
    }

    @Deprecated
    protected String addAllFecthes(String ... fetchProperties) {
        StringBuilder hqlFromClauseBuilder = new StringBuilder();
        int fetchedPropertiesAliasIndex = 0;
        HashMap aliases = Maps.newHashMap();
        for (String propertyName : fetchProperties) {
            StringBuilder path = new StringBuilder();
            for (String part : Splitter.on((char)'.').split((CharSequence)propertyName)) {
                String previousPath = path.toString();
                String previousAlias = (String)Objects.firstNonNull(aliases.get(previousPath), (Object)"E");
                if (path.length() > 0) {
                    path.append('.');
                }
                path.append(part);
                String currentPath = path.toString();
                String currentAlias = (String)aliases.get(currentPath);
                if (!Strings.isNullOrEmpty((String)currentAlias)) continue;
                currentAlias = String.format("fetchedProp%d_", fetchedPropertiesAliasIndex++);
                aliases.put(currentPath, currentAlias);
                String fetch = String.format(" LEFT JOIN FETCH %s.%s %s ", previousAlias, part, currentAlias);
                hqlFromClauseBuilder.append(fetch);
            }
        }
        return hqlFromClauseBuilder.toString();
    }

    @Deprecated
    protected <O extends TopiaEntity> List<O> sortAccordingToIds(List<O> entities, List<String> idsList) {
        ImmutableMap entitiesIndex = Maps.uniqueIndex(entities, (Function)TopiaEntities.getTopiaIdFunction());
        Iterable transformed = Iterables.transform(idsList, (Function)new Function<String, O>((Map)entitiesIndex){
            final /* synthetic */ Map val$entitiesIndex;
            {
                this.val$entitiesIndex = map;
            }

            public O apply(String input) {
                return (TopiaEntity)this.val$entitiesIndex.get(input);
            }
        });
        ArrayList result = Lists.newArrayList((Iterable)transformed);
        return result;
    }

    public Set<Object> getDistinctValues(MailFolder folder, String[] properties, boolean sum) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        String folderAndStatusCondition = " WHERE email.mailFolder = :folder AND email.demandStatus != :archiveStatus";
        args.put("folder", folder);
        args.put("archiveStatus", DemandStatus.ARCHIVED);
        String propertyList = sum ? "SUM(" + StringUtils.join((Object[])properties, (String)"), SUM(") + ")" : StringUtils.join((Object[])properties, (String)", ");
        String query = "SELECT DISTINCT " + propertyList + " FROM " + Email.class.getName() + " AS email";
        for (String property : properties) {
            if (!property.startsWith("client.")) continue;
            query = query + " LEFT OUTER JOIN email.client AS client";
            break;
        }
        for (String property : properties) {
            if (!property.startsWith("rangeRow.")) continue;
            query = query + " LEFT OUTER JOIN email.rangeRow AS rangeRow";
            break;
        }
        query = query + folderAndStatusCondition;
        if (sum) {
            query = query + " GROUP BY email.topiaId";
        }
        List queryResults = this.findAll(query, args);
        HashSet<Object> result = new HashSet<Object>();
        if (properties.length == 1) {
            result.addAll(queryResults);
        } else {
            for (Object o1 : queryResults) {
                Object[] objects;
                for (Object o2 : objects = (Object[])o1) {
                    result.add(o2);
                }
            }
        }
        if (sum && result.contains(null)) {
            result.remove(null);
            result.add(0L);
        } else if (!result.contains("")) {
            result.add(null);
        }
        return result;
    }
}

