/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.perl;

import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.UIManager;
import org.fife.rsta.ac.perl.PerlLanguageSupport;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.FunctionCompletion;

public class PerlFunctionCompletion
extends FunctionCompletion {
    public PerlFunctionCompletion(CompletionProvider provider, String name, String returnType) {
        super(provider, name, returnType);
    }

    public String getSummary() {
        String summary = null;
        File installLoc = PerlLanguageSupport.getPerlInstallLocation();
        if (installLoc != null && PerlLanguageSupport.getUseSystemPerldoc()) {
            summary = this.getSummaryFromPerldoc(installLoc);
        }
        if (summary == null) {
            summary = super.getSummary();
        }
        return summary;
    }

    private String getSummaryFromPerldoc(File installLoc) {
        File perldoc;
        Process p = null;
        String fileName = "bin/perldoc";
        if (File.separatorChar == '\\') {
            fileName = fileName + ".bat";
        }
        if (!(perldoc = new File(installLoc, fileName)).isFile()) {
            return null;
        }
        String[] cmd = new String[]{perldoc.getAbsolutePath(), "-f", this.getName()};
        try {
            p = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
        OutputCollector outputCollector = new OutputCollector(r);
        Thread t = new Thread(outputCollector);
        t.start();
        int rc = 0;
        try {
            rc = p.waitFor();
            t.join();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        StringBuffer output = null;
        if (rc == 0 && (output = outputCollector.getOutput()) != null && output.length() > 0) {
            output = PerlFunctionCompletion.perldocToHtml(output);
        }
        return output == null ? null : output.toString();
    }

    private static final StringBuffer perldocToHtml(StringBuffer text) {
        StringBuffer sb = null;
        Font font = UIManager.getFont("Label.font");
        sb = font != null ? new StringBuffer("<html><style>pre { font-family: ").append(font.getFamily()).append("; }</style><pre>") : new StringBuffer("<html><pre>");
        sb.append(text);
        return sb;
    }

    private static class OutputCollector
    implements Runnable {
        private BufferedReader r;
        private StringBuffer sb;

        public OutputCollector(BufferedReader r) {
            this.r = r;
            this.sb = new StringBuffer();
        }

        public StringBuffer getOutput() {
            return this.sb;
        }

        public void run() {
            String line = null;
            try {
                while ((line = this.r.readLine()) != null) {
                    this.sb.append(line).append('\n');
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

