/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.tree;

import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.fife.rsta.ac.java.IconFactory;
import org.fife.rsta.ac.java.rjc.ast.ASTNode;

class JavaTreeNode
extends DefaultMutableTreeNode {
    private ASTNode astNode;
    private Icon icon;

    protected JavaTreeNode(ASTNode node) {
        this(node, null);
    }

    protected JavaTreeNode(ASTNode node, String iconName) {
        super(node);
        this.astNode = node;
        if (iconName != null) {
            this.setIcon(IconFactory.get().getIcon(iconName));
        }
    }

    public JavaTreeNode(String text, String iconName) {
        super(text);
        if (iconName != null) {
            this.icon = IconFactory.get().getIcon(iconName);
        }
    }

    public ASTNode getASTNode() {
        return this.astNode;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getText(boolean selected) {
        Object obj = this.getUserObject();
        return obj != null ? obj.toString() : null;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public String toString() {
        return this.getText(false);
    }
}

