/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.rjc.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.fife.rsta.ac.java.rjc.ast.AbstractASTNode;
import org.fife.rsta.ac.java.rjc.ast.Member;
import org.fife.rsta.ac.java.rjc.ast.TypeDeclaration;
import org.fife.rsta.ac.java.rjc.lang.Modifiers;
import org.fife.rsta.ac.java.rjc.lexer.Offset;

public abstract class AbstractTypeDeclarationNode
extends AbstractASTNode
implements TypeDeclaration {
    private Modifiers modifiers;
    private List childTypes;
    private Offset bodyStartOffs;
    private Offset bodyEndOffs;
    private boolean deprecated;
    private String docComment;
    private List memberList;

    public AbstractTypeDeclarationNode(String name, Offset start) {
        super(name, start);
        this.init();
    }

    public AbstractTypeDeclarationNode(String name, Offset start, Offset end) {
        super(name, start, end);
        this.init();
    }

    public void addMember(Member member) {
        member.setParentTypeDeclaration(this);
        this.memberList.add(member);
    }

    public void addTypeDeclaration(TypeDeclaration type) {
        if (this.childTypes == null) {
            this.childTypes = new ArrayList(1);
        }
        this.childTypes.add(type);
    }

    public int getBodyEndOffset() {
        return this.bodyEndOffs != null ? this.bodyEndOffs.getOffset() : Integer.MAX_VALUE;
    }

    public int getBodyStartOffset() {
        return this.bodyStartOffs == null ? 0 : this.bodyStartOffs.getOffset();
    }

    public TypeDeclaration getChildType(int index) {
        return (TypeDeclaration)this.childTypes.get(index);
    }

    public int getChildTypeCount() {
        return this.childTypes == null ? 0 : this.childTypes.size();
    }

    public String getDocComment() {
        return this.docComment;
    }

    public int getMemberCount() {
        return this.memberList.size();
    }

    public Iterator getMemberIterator() {
        return this.memberList.iterator();
    }

    public Modifiers getModifiers() {
        return this.modifiers;
    }

    private void init() {
        this.memberList = new ArrayList();
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setBodyEndOffset(Offset end) {
        this.bodyEndOffs = end;
    }

    public void setBodyStartOffset(Offset start) {
        this.bodyStartOffs = start;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public void setDocComment(String comment) {
        this.docComment = comment;
    }

    public void setModifiers(Modifiers modifiers) {
        this.modifiers = modifiers;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.modifiers != null) {
            sb.append(this.modifiers.toString()).append(' ');
        }
        sb.append(this.getTypeString()).append(' ');
        sb.append(this.getName());
        return sb.toString();
    }
}

