/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.classreader.attributes;

import java.io.DataInputStream;
import java.io.IOException;
import org.fife.rsta.ac.java.classreader.ClassFile;
import org.fife.rsta.ac.java.classreader.ExceptionTableEntry;
import org.fife.rsta.ac.java.classreader.MethodInfo;
import org.fife.rsta.ac.java.classreader.attributes.AttributeInfo;
import org.fife.rsta.ac.java.classreader.attributes.UnsupportedAttribute;

public class Code
extends AttributeInfo {
    private MethodInfo mi;
    private int maxStack;
    private int maxLocals;
    private int[] code;
    private ExceptionTableEntry[] exceptionTable;
    private AttributeInfo[] attributes;

    public Code(MethodInfo mi) {
        super(mi.getClassFile());
        this.mi = mi;
    }

    public int getByte(int offset) {
        return this.code[offset];
    }

    public int getCodeLength() {
        return this.code.length;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public MethodInfo getMethodInfo() {
        return this.mi;
    }

    public static Code read(MethodInfo mi, DataInputStream in) throws IOException {
        int attrCount;
        Code code = new Code(mi);
        code.maxStack = in.readUnsignedShort();
        code.maxLocals = in.readUnsignedShort();
        code.code = new int[in.readInt()];
        for (int i = 0; i < code.code.length; ++i) {
            code.code[i] = in.readUnsignedByte();
        }
        int exceptionTableLength = in.readUnsignedShort();
        if (exceptionTableLength > 0) {
            code.exceptionTable = new ExceptionTableEntry[exceptionTableLength];
            for (int i = 0; i < exceptionTableLength; ++i) {
                ExceptionTableEntry ete;
                code.exceptionTable[i] = ete = ExceptionTableEntry.read(mi.getClassFile(), in);
            }
        }
        if ((attrCount = in.readUnsignedShort()) > 0) {
            code.attributes = new AttributeInfo[attrCount];
            for (int i = 0; i < attrCount; ++i) {
                AttributeInfo ai;
                code.attributes[i] = ai = code.readAttribute(in);
            }
        }
        return code;
    }

    private AttributeInfo readAttribute(DataInputStream in) throws IOException {
        UnsupportedAttribute ai = null;
        ClassFile cf = this.mi.getClassFile();
        int attributeNameIndex = in.readUnsignedShort();
        int attributeLength = in.readInt();
        String attrName = cf.getUtf8ValueFromConstantPool(attributeNameIndex);
        ai = AttributeInfo.readUnsupportedAttribute(cf, in, attrName, attributeLength);
        return ai;
    }
}

