/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.classreader;

import java.io.DataInputStream;
import java.io.IOException;
import org.fife.rsta.ac.java.classreader.ClassFile;
import org.fife.rsta.ac.java.classreader.attributes.AttributeInfo;
import org.fife.rsta.ac.java.classreader.attributes.UnsupportedAttribute;

public abstract class MemberInfo {
    protected ClassFile cf;
    private int accessFlags;
    private boolean deprecated;
    public static final String DEPRECATED = "Deprecated";

    protected MemberInfo(ClassFile cf, int accessFlags) {
        this.cf = cf;
        this.accessFlags = accessFlags;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public ClassFile getClassFile() {
        return this.cf;
    }

    public abstract String getName();

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isFinal() {
        return (this.getAccessFlags() & 0x10) > 0;
    }

    public boolean isStatic() {
        return (this.getAccessFlags() & 8) > 0;
    }

    protected AttributeInfo readAttribute(DataInputStream in, String attrName, int attrLength) throws IOException {
        UnsupportedAttribute ai = null;
        if (DEPRECATED.equals(attrName)) {
            this.deprecated = true;
        } else {
            ai = AttributeInfo.readUnsupportedAttribute(this.cf, in, attrName, attrLength);
        }
        return ai;
    }
}

