/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.fife.rsta.ac.java.classreader.ClassFile;
import org.fife.rsta.ac.java.rjc.ast.CompilationUnit;
import org.fife.rsta.ac.java.rjc.lexer.Scanner;
import org.fife.rsta.ac.java.rjc.parser.ASTFactory;

class Util {
    static final Pattern DOC_COMMENT_LINE_HEADER = Pattern.compile("\\s*\\n\\s*\\*[ \t\f]*[/]?");
    static final Pattern LINK_TAG_MEMBER_PATTERN = Pattern.compile("(?:\\w+\\.)*(?:\\w+)?(?:\\#\\w+(?:\\([^\\)]*\\))?)?");

    private Util() {
    }

    private static final void appendDocCommentTail(StringBuffer sb, StringBuffer tail) {
        StringBuffer params = null;
        StringBuffer returns = null;
        StringBuffer throwsItems = null;
        StringBuffer see = null;
        StringBuffer since = null;
        StringBuffer author = null;
        StringBuffer unknowns = null;
        boolean inParams = false;
        boolean inThrows = false;
        boolean inReturns = false;
        boolean inSeeAlso = false;
        boolean inSince = false;
        boolean inAuthor = false;
        boolean inUnknowns = false;
        String[] st = tail.toString().split("[ \t\r\n\f]+");
        String token = null;
        int i = 0;
        while (i < st.length && (token = st[i++]) != null) {
            if ("@param".equals(token) && i < st.length) {
                token = st[i++];
                if (params == null) {
                    params = new StringBuffer("<b>Parameters:</b><p class='indented'>");
                } else {
                    params.append("<br>");
                }
                params.append("<b>").append(token).append("</b> ");
                inSeeAlso = false;
                inParams = true;
                inReturns = false;
                inThrows = false;
                inSince = false;
                inAuthor = false;
                inUnknowns = false;
                continue;
            }
            if ("@return".equals(token) && i < st.length) {
                if (returns == null) {
                    returns = new StringBuffer("<b>Returns:</b><p class='indented'>");
                }
                inSeeAlso = false;
                inReturns = true;
                inParams = false;
                inThrows = false;
                inSince = false;
                inAuthor = false;
                inUnknowns = false;
                continue;
            }
            if ("@see".equals(token) && i < st.length) {
                if (see == null) {
                    see = new StringBuffer("<b>See Also:</b><p class='indented'>");
                } else {
                    see.append("<br>");
                }
                inSeeAlso = true;
                inReturns = false;
                inParams = false;
                inThrows = false;
                inSince = false;
                inAuthor = false;
                inUnknowns = false;
                continue;
            }
            if ("@throws".equals(token) || "@exception".equals(token) && i < st.length) {
                token = st[i++];
                if (throwsItems == null) {
                    throwsItems = new StringBuffer("<b>Throws:</b><p class='indented'>");
                } else {
                    throwsItems.append("<br>");
                }
                throwsItems.append("<b>").append(token).append("</b> ");
                inSeeAlso = false;
                inParams = false;
                inReturns = false;
                inThrows = true;
                inSince = false;
                inAuthor = false;
                inUnknowns = false;
                continue;
            }
            if ("@since".equals(token) && i < st.length) {
                if (since == null) {
                    since = new StringBuffer("<b>Since:</b><p class='indented'>");
                }
                inSeeAlso = false;
                inReturns = false;
                inParams = false;
                inThrows = false;
                inSince = true;
                inAuthor = false;
                inUnknowns = false;
                continue;
            }
            if ("@author".equals(token) && i < st.length) {
                if (author == null) {
                    author = new StringBuffer("<b>Author:</b><p class='indented'>");
                } else {
                    author.append("<br>");
                }
                inSeeAlso = false;
                inReturns = false;
                inParams = false;
                inThrows = false;
                inSince = false;
                inAuthor = true;
                inUnknowns = false;
                continue;
            }
            if (token.startsWith("@") && token.length() > 1) {
                if (unknowns == null) {
                    unknowns = new StringBuffer();
                } else {
                    unknowns.append("</p>");
                }
                unknowns.append("<b>").append(token).append("</b><p class='indented'>");
                inSeeAlso = false;
                inParams = false;
                inReturns = false;
                inThrows = false;
                inSince = false;
                inAuthor = false;
                inUnknowns = true;
                continue;
            }
            if (inParams) {
                params.append(token).append(' ');
                continue;
            }
            if (inReturns) {
                returns.append(token).append(' ');
                continue;
            }
            if (inSeeAlso) {
                see.append(token).append(' ');
                continue;
            }
            if (inThrows) {
                throwsItems.append(token).append(' ');
                continue;
            }
            if (inSince) {
                since.append(token).append(' ');
                continue;
            }
            if (inAuthor) {
                author.append(token).append(' ');
                continue;
            }
            if (!inUnknowns) continue;
            unknowns.append(token).append(' ');
        }
        sb.append("<p>");
        if (params != null) {
            sb.append(params).append("</p>");
        }
        if (returns != null) {
            sb.append(returns).append("</p>");
        }
        if (throwsItems != null) {
            sb.append(throwsItems).append("</p>");
        }
        if (see != null) {
            sb.append(see).append("</p>");
        }
        if (author != null) {
            sb.append(author).append("</p>");
        }
        if (since != null) {
            sb.append(since).append("</p>");
        }
        if (unknowns != null) {
            sb.append(unknowns).append("</p>");
        }
    }

    private static final void appendLinkTagText(StringBuffer appendTo, String linkContent) {
        appendTo.append("<a href='");
        Matcher m = LINK_TAG_MEMBER_PATTERN.matcher(linkContent);
        if (m.find() && m.start() == 0) {
            int hash;
            String match;
            String link = match = m.group(0);
            String text = null;
            if (match.length() == linkContent.length()) {
                int pound = match.indexOf(35);
                if (pound == 0) {
                    text = match.substring(1);
                } else if (pound > 0) {
                    String prefix = match.substring(0, pound);
                    if ("java.lang.Object".equals(prefix)) {
                        text = match.substring(pound + 1);
                    }
                } else {
                    text = match;
                }
            } else {
                int offs;
                for (offs = match.length(); offs < linkContent.length() && Character.isWhitespace(linkContent.charAt(offs)); ++offs) {
                }
                if (offs < linkContent.length()) {
                    text = linkContent.substring(offs);
                }
            }
            if (text == null) {
                text = linkContent;
            }
            if ((hash = text.indexOf(35)) > -1) {
                text = text.substring(0, hash) + "." + text.substring(hash + 1);
            }
            appendTo.append(link).append("'>").append(text);
        } else {
            appendTo.append("'>").append(linkContent);
        }
        appendTo.append("</a>");
    }

    public static final String docCommentToHtml(String dc) {
        Matcher m = DOC_COMMENT_LINE_HEADER.matcher(dc);
        dc = m.replaceAll("\n");
        StringBuffer html = new StringBuffer("<html><style> .indented { margin-top: 0px; padding-left: 30pt; } </style><body>");
        StringBuffer tailBuf = null;
        BufferedReader r = new BufferedReader(new StringReader(dc));
        try {
            int offs;
            String line = r.readLine().substring(3);
            line = Util.possiblyStripDocCommentTail(line);
            for (offs = 0; offs < line.length() && Character.isWhitespace(line.charAt(offs)); ++offs) {
            }
            if (offs < line.length()) {
                html.append(line.substring(offs)).append(" ");
            }
            while ((line = r.readLine()) != null) {
                line = Util.possiblyStripDocCommentTail(line);
                if (tailBuf != null) {
                    tailBuf.append(line).append(' ');
                    continue;
                }
                if (line.startsWith("@")) {
                    tailBuf = new StringBuffer();
                    tailBuf.append(line).append(' ');
                    continue;
                }
                html.append(line).append(' ');
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        html = Util.fixDocComment(html);
        if (tailBuf != null) {
            Util.appendDocCommentTail(html, Util.fixDocComment(tailBuf));
        }
        return html.toString();
    }

    private static final StringBuffer fixDocComment(StringBuffer text) {
        if (text.indexOf("{@") == -1) {
            return text;
        }
        StringBuffer sb = new StringBuffer();
        int textOffs = 0;
        int index = 0;
        while ((index = text.indexOf("{@", index)) > -1) {
            int closingBrace = Util.indexOf('}', text, index + 2);
            if (closingBrace <= -1) continue;
            sb.append(text.substring(textOffs, index));
            String content = text.substring(index + 2, closingBrace);
            index = textOffs = closingBrace + 1;
            if (content.startsWith("code ")) {
                sb.append("<code>").append(content.substring(5)).append("</code>");
                continue;
            }
            if (content.startsWith("link ")) {
                sb.append("<code>");
                Util.appendLinkTagText(sb, content.substring(5));
                sb.append("</code>");
                continue;
            }
            if (content.startsWith("linkplain ")) {
                Util.appendLinkTagText(sb, content.substring(10));
                continue;
            }
            if (content.startsWith("literal ")) {
                sb.append(content.substring(8));
                continue;
            }
            sb.append("<code>").append(content).append("</code>");
        }
        if (textOffs < text.length()) {
            sb.append(text.substring(textOffs));
        }
        return sb;
    }

    public static CompilationUnit getCompilationUnitFromDisk(File loc, ClassFile cf) {
        CompilationUnit cu = null;
        if (loc.isFile()) {
            String name = loc.getName();
            if (name.endsWith(".zip") || name.endsWith(".jar")) {
                try {
                    cu = Util.getCompilationUnitFromZip(loc, cf);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        } else if (loc.isDirectory()) {
            try {
                cu = Util.getCompilationUnitFromDir(loc, cf);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return cu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CompilationUnit getCompilationUnitFromDir(File dir, ClassFile cf) throws IOException {
        CompilationUnit cu = null;
        String entryName = cf.getClassName(true).replaceAll("\\.", "/");
        File file = new File(dir, entryName = entryName + ".java");
        if (!file.isFile()) {
            file = new File(dir, "src/" + entryName);
        }
        if (file.isFile()) {
            BufferedReader r = new BufferedReader(new FileReader(file));
            try {
                Scanner s = new Scanner(r);
                cu = new ASTFactory().getCompilationUnit(entryName, s);
            }
            finally {
                r.close();
            }
        }
        return cu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CompilationUnit getCompilationUnitFromZip(File zip, ClassFile cf) throws IOException {
        CompilationUnit cu = null;
        ZipFile zipFile = new ZipFile(zip);
        try {
            String entryName = cf.getClassName(true).replaceAll("\\.", "/");
            entryName = entryName + ".java";
            ZipEntry entry = zipFile.getEntry(entryName);
            if (entry == null) {
                entry = zipFile.getEntry("src/" + entryName);
            }
            if (entry != null) {
                InputStream in = zipFile.getInputStream(entry);
                Scanner s = new Scanner(new InputStreamReader(in));
                cu = new ASTFactory().getCompilationUnit(entryName, s);
            }
        }
        finally {
            zipFile.close();
        }
        return cu;
    }

    public static final String getUnqualified(String clazz) {
        int dot = clazz.lastIndexOf(46);
        if (dot > -1) {
            clazz = clazz.substring(dot + 1);
        }
        return clazz;
    }

    private static final int indexOf(char ch, CharSequence sb, int offs) {
        while (offs < sb.length()) {
            if (ch == sb.charAt(offs)) {
                return offs;
            }
            ++offs;
        }
        return -1;
    }

    public static final boolean isFullyQualified(String str) {
        return str.indexOf(46) > -1;
    }

    private static final String possiblyStripDocCommentTail(String str) {
        if (str.endsWith("*/")) {
            str = str.substring(0, str.length() - 2);
        }
        return str;
    }

    public static String[] splitOnChar(String str, int ch) {
        ArrayList<String> list = new ArrayList<String>(3);
        int pos = 0;
        int old = 0;
        while ((pos = str.indexOf(ch, old)) > -1) {
            list.add(str.substring(old, pos));
            old = pos + 1;
        }
        list.add(str.substring(old));
        String[] array = new String[list.size()];
        return list.toArray(array);
    }
}

