/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.fife.rsta.ac.java.ClassCompletion;
import org.fife.rsta.ac.java.JarInfo;
import org.fife.rsta.ac.java.PackageNameCompletion;
import org.fife.rsta.ac.java.Util;
import org.fife.rsta.ac.java.classreader.ClassFile;
import org.fife.ui.autocomplete.CompletionProvider;

class JarReader {
    private JarInfo info;
    private TreeMap packageMap;
    private long lastModified;

    public JarReader(JarInfo info) throws IOException {
        this.info = info;
        this.packageMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        this.loadCompletions();
    }

    public void addCompletions(CompletionProvider provider, String[] pkgNames, Set addTo) {
        this.checkLastModified();
        TreeMap map = this.packageMap;
        for (int i = 0; i < pkgNames.length - 1; ++i) {
            Object obj = map.get(pkgNames[i]);
            if (!(obj instanceof TreeMap)) {
                return;
            }
            map = (TreeMap)obj;
        }
        String fromKey = pkgNames[pkgNames.length - 1];
        String toKey = fromKey + '{';
        SortedMap sm = map.subMap(fromKey, toKey);
        Iterator<String> i = sm.keySet().iterator();
        while (i.hasNext()) {
            String obj = i.next();
            Object value = sm.get(obj);
            if (value instanceof ClassFile) {
                ClassFile cf = (ClassFile)value;
                boolean inPkg = false;
                if (!inPkg && !org.fife.rsta.ac.java.classreader.Util.isPublic(cf.getAccessFlags())) continue;
                addTo.add(new ClassCompletion(provider, cf));
                continue;
            }
            String[] items = new String[pkgNames.length];
            System.arraycopy(pkgNames, 0, items, 0, pkgNames.length - 1);
            items[items.length - 1] = obj.toString();
            ClassFile cf = this.getClassEntry(items);
            if (cf != null) {
                boolean inPkg = false;
                if (!inPkg && !org.fife.rsta.ac.java.classreader.Util.isPublic(cf.getAccessFlags())) continue;
                addTo.add(new ClassCompletion(provider, cf));
                continue;
            }
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < pkgNames.length - 1; ++j) {
                sb.append(pkgNames[j]).append('.');
            }
            sb.append(obj.toString());
            String text = sb.toString();
            addTo.add(new PackageNameCompletion(provider, text, fromKey));
        }
    }

    private void checkLastModified() {
        long newLastModified = this.info.getJarFile().lastModified();
        if (newLastModified != 0L && newLastModified != this.lastModified) {
            int count = 0;
            count = this.clearClassFiles(this.packageMap);
            System.out.println("DEBUG: Cleared " + count + " cached ClassFiles");
            this.lastModified = newLastModified;
        }
    }

    private int clearClassFiles(Map map) {
        int clearedCount = 0;
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Object value = entry.getValue();
            if (value instanceof ClassFile) {
                entry.setValue(null);
                ++clearedCount;
                continue;
            }
            if (!(value instanceof Map)) continue;
            clearedCount += this.clearClassFiles((Map)value);
        }
        return clearedCount;
    }

    public boolean containsClass(String className) {
        String[] items = className.split("\\.");
        TreeMap m = this.packageMap;
        for (int i = 0; i < items.length - 1; ++i) {
            Object value = m.get(items[i]);
            if (!(value instanceof TreeMap)) {
                return false;
            }
            m = (TreeMap)value;
        }
        return m.containsKey(items[items.length - 1]);
    }

    public boolean containsPackage(String pkgName) {
        String[] items = pkgName.split("\\.");
        TreeMap m = this.packageMap;
        for (int i = 0; i < items.length; ++i) {
            Object value = m.get(items[i]);
            if (!(value instanceof TreeMap)) {
                return false;
            }
            m = (TreeMap)value;
        }
        return true;
    }

    private ClassFile createClassFile(String entryName) throws IOException {
        File binLoc = this.info.getJarFile();
        if (binLoc.isFile()) {
            return this.createClassFileJar(entryName);
        }
        if (binLoc.isDirectory()) {
            return this.createClassFileDirectory(entryName);
        }
        return null;
    }

    private ClassFile createClassFileDirectory(String entryName) throws IOException {
        File file = new File(this.info.getJarFile(), entryName);
        if (!file.isFile()) {
            System.err.println("ERROR: Invalid class file: " + file.getAbsolutePath());
            return null;
        }
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        ClassFile cf = new ClassFile(in);
        in.close();
        return cf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassFile createClassFileJar(String entryName) throws IOException {
        JarFile jar = new JarFile(this.info.getJarFile());
        try {
            JarEntry entry = (JarEntry)jar.getEntry(entryName);
            if (entry == null) {
                System.err.println("ERROR: Invalid entry: " + entryName);
                ClassFile classFile = null;
                return classFile;
            }
            DataInputStream in = new DataInputStream(jar.getInputStream(entry));
            ClassFile cf = new ClassFile(in);
            in.close();
            ClassFile classFile = cf;
            return classFile;
        }
        finally {
            jar.close();
        }
    }

    public ClassFile getClassEntry(String[] items) {
        Object value;
        SortedMap<String, ClassFile> map = this.packageMap;
        for (int i = 0; i < items.length - 1; ++i) {
            if (map.containsKey(items[i])) {
                value = map.get(items[i]);
                if (!(value instanceof SortedMap)) {
                    return null;
                }
            } else {
                return null;
            }
            map = (SortedMap)value;
        }
        String className = items[items.length - 1];
        if (map.containsKey(className)) {
            value = map.get(className);
            if (value instanceof Map) {
                return null;
            }
            if (value instanceof ClassFile) {
                ClassFile cf = (ClassFile)value;
                return cf;
            }
            try {
                StringBuffer name = new StringBuffer(items[0]);
                for (int i = 1; i < items.length; ++i) {
                    name.append('/').append(items[i]);
                }
                name.append(".class");
                ClassFile cf = this.createClassFile(name.toString());
                map.put(className, cf);
                return cf;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return null;
    }

    public void getClassesInPackage(List addTo, String[] pkgs, boolean inPkg) {
        SortedMap map = this.packageMap;
        for (int i = 0; i < pkgs.length; ++i) {
            Object value;
            if (map.containsKey(pkgs[i])) {
                value = map.get(pkgs[i]);
                if (!(value instanceof SortedMap)) {
                    return;
                }
            } else {
                return;
            }
            map = (SortedMap)value;
        }
        TreeMap newClassFiles = null;
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Object value = entry.getValue();
            if (value == null) {
                StringBuffer name = new StringBuffer(pkgs[0]);
                for (int j = 1; j < pkgs.length; ++j) {
                    name.append('/').append(pkgs[j]);
                }
                name.append('/');
                name.append((String)entry.getKey()).append(".class");
                try {
                    ClassFile cf = this.createClassFile(name.toString());
                    if (newClassFiles == null) {
                        newClassFiles = new TreeMap();
                    }
                    newClassFiles.put(entry.getKey(), cf);
                    this.possiblyAddTo(addTo, cf, inPkg);
                    continue;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    break;
                }
            }
            if (!(value instanceof ClassFile)) continue;
            this.possiblyAddTo(addTo, (ClassFile)value, inPkg);
        }
        if (newClassFiles != null) {
            map.putAll(newClassFiles);
        }
    }

    public JarInfo getJarInfo() {
        return (JarInfo)this.info.clone();
    }

    public SortedMap getPackageEntry(String[] pkgs) {
        SortedMap map = this.packageMap;
        for (int i = 0; i < pkgs.length; ++i) {
            Object value;
            if (map.containsKey(pkgs[i])) {
                value = map.get(pkgs[i]);
                if (!(value instanceof SortedMap)) {
                    return null;
                }
            } else {
                return null;
            }
            map = (SortedMap)value;
        }
        return map;
    }

    private void loadCompletions() throws IOException {
        File binLoc = this.info.getJarFile();
        if (binLoc.isDirectory()) {
            this.loadCompletionsDirectory();
        } else if (binLoc.isFile()) {
            this.loadCompletionsJarFile();
        }
    }

    private void loadCompletionsDirectory() throws IOException {
        File root = this.info.getJarFile();
        this.loadCompletionsDirectoryImpl(root, null);
        this.lastModified = root.lastModified();
    }

    private void loadCompletionsDirectoryImpl(File dir, String pkg) throws IOException {
        File[] children = dir.listFiles();
        TreeMap m = null;
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            if (child.isFile() && child.getName().endsWith(".class")) {
                if (pkg != null && m == null) {
                    m = this.packageMap;
                    String[] items = Util.splitOnChar(pkg, 47);
                    for (int j = 0; j < items.length; ++j) {
                        TreeMap submap = (TreeMap)m.get(items[j]);
                        if (submap == null) {
                            submap = new TreeMap();
                            m.put(items[j], submap);
                        }
                        m = submap;
                    }
                }
                String className = child.getName().substring(0, child.getName().length() - 6);
                m.put(className, null);
                continue;
            }
            if (!child.isDirectory()) continue;
            String subpkg = pkg == null ? child.getName() : pkg + "/" + child.getName();
            this.loadCompletionsDirectoryImpl(child, subpkg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCompletionsJarFile() throws IOException {
        JarFile jar = new JarFile(this.info.getJarFile());
        try {
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(".class")) continue;
                entryName = entryName.substring(0, entryName.length() - 6);
                String[] items = Util.splitOnChar(entryName, 47);
                TreeMap m = this.packageMap;
                for (int i = 0; i < items.length - 1; ++i) {
                    TreeMap submap = (TreeMap)m.get(items[i]);
                    if (submap == null) {
                        submap = new TreeMap();
                        m.put(items[i], submap);
                    }
                    m = submap;
                }
                String className = items[items.length - 1];
                m.put(className, null);
            }
        }
        finally {
            jar.close();
        }
        this.lastModified = this.info.getJarFile().lastModified();
    }

    private void possiblyAddTo(Collection addTo, ClassFile cf, boolean inPkg) {
        if (inPkg || org.fife.rsta.ac.java.classreader.Util.isPublic(cf.getAccessFlags())) {
            addTo.add(cf);
        }
    }
}

