/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.fife.rsta.ac.java.JarInfo;
import org.fife.rsta.ac.java.JarReader;
import org.fife.rsta.ac.java.Util;
import org.fife.rsta.ac.java.classreader.ClassFile;
import org.fife.rsta.ac.java.rjc.ast.ImportDeclaration;
import org.fife.ui.autocomplete.CompletionProvider;

public class JarManager {
    private List jars = new ArrayList();
    private static boolean checkModified;

    public JarManager() {
        JarManager.setCheckModifiedDatestamps(true);
    }

    public void addCompletions(CompletionProvider p, String text, Set addTo) {
        String[] pkgNames = Util.splitOnChar(text, 46);
        for (int i = 0; i < this.jars.size(); ++i) {
            JarReader jar = (JarReader)this.jars.get(i);
            jar.addCompletions(p, pkgNames, addTo);
        }
    }

    public boolean addJar(JarInfo info) throws IOException {
        for (int i = 0; i < this.jars.size(); ++i) {
            JarReader jar = (JarReader)this.jars.get(i);
            JarInfo info2 = jar.getJarInfo();
            if (!info2.equals(info)) continue;
            File source = info.getSourceLocation();
            File source2 = info2.getSourceLocation();
            if (source == null && source2 != null || source != null && !source.equals(source2)) {
                this.jars.set(i, new JarReader((JarInfo)info.clone()));
                return true;
            }
            return false;
        }
        if (info == null) {
            info = JarInfo.getMainJREJarInfo();
        }
        this.jars.add(new JarReader(info));
        return true;
    }

    public void clearJars() {
        this.jars.clear();
    }

    public static boolean getCheckModifiedDatestamps() {
        return checkModified;
    }

    public ClassFile getClassEntry(String className) {
        String[] items = Util.splitOnChar(className, 46);
        for (int i = 0; i < this.jars.size(); ++i) {
            JarReader jar = (JarReader)this.jars.get(i);
            ClassFile cf = jar.getClassEntry(items);
            if (cf == null) continue;
            return cf;
        }
        return null;
    }

    public List getClassesWithUnqualifiedName(String name, List importDeclarations) {
        ArrayList<ClassFile> result = null;
        for (int i = 0; i < importDeclarations.size(); ++i) {
            ImportDeclaration idec = (ImportDeclaration)importDeclarations.get(i);
            if (idec.isStatic()) continue;
            if (idec.isWildcard()) {
                String qualified = idec.getName();
                qualified = qualified.substring(0, qualified.indexOf(42));
                ClassFile entry = this.getClassEntry(qualified = qualified + name);
                if (entry == null) continue;
                if (result == null) {
                    result = new ArrayList(1);
                }
                result.add(entry);
                continue;
            }
            String name2 = idec.getName();
            String unqualifiedName2 = name2.substring(name2.lastIndexOf(46) + 1);
            if (!unqualifiedName2.equals(name)) continue;
            ClassFile entry = this.getClassEntry(name2);
            if (entry != null) {
                if (result == null) {
                    result = new ArrayList(1);
                }
                result.add(entry);
                continue;
            }
            System.err.println("ERROR: Class not found! - " + name2);
        }
        String qualified = "java.lang." + name;
        ClassFile entry = this.getClassEntry(qualified);
        if (entry != null) {
            if (result == null) {
                result = new ArrayList<ClassFile>(1);
            }
            result.add(entry);
        }
        return result;
    }

    public List getClassesInPackage(String pkgName, boolean inPkg) {
        ArrayList list = new ArrayList();
        String[] pkgs = Util.splitOnChar(pkgName, 46);
        for (int i = 0; i < this.jars.size(); ++i) {
            JarReader jar = (JarReader)this.jars.get(i);
            jar.getClassesInPackage(list, pkgs, inPkg);
        }
        return list;
    }

    public List getJars() {
        ArrayList<Object> jarList = new ArrayList<Object>(this.jars.size());
        Iterator i = this.jars.iterator();
        while (i.hasNext()) {
            JarReader reader = (JarReader)i.next();
            jarList.add(reader.getJarInfo().clone());
        }
        return jarList;
    }

    public SortedMap getPackageEntry(String pkgName) {
        String[] pkgs = Util.splitOnChar(pkgName, 46);
        TreeMap map = new TreeMap();
        for (int i = 0; i < this.jars.size(); ++i) {
            JarReader jar = (JarReader)this.jars.get(i);
            SortedMap map2 = jar.getPackageEntry(pkgs);
            if (map2 == null) continue;
            this.mergeMaps(map, map2);
        }
        return map;
    }

    public File getSourceLocForClass(String className) {
        File sourceLoc = null;
        for (int i = 0; i < this.jars.size(); ++i) {
            JarReader jar = (JarReader)this.jars.get(i);
            if (!jar.containsClass(className)) continue;
            sourceLoc = jar.getJarInfo().getSourceLocation();
            break;
        }
        return sourceLoc;
    }

    private void mergeMaps(SortedMap map, SortedMap toAdd) {
        Iterator i = toAdd.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (map.containsKey(key)) {
                if (!(map.get(key) instanceof SortedMap) || !(value instanceof SortedMap)) continue;
                this.mergeMaps((SortedMap)map.get(key), (SortedMap)value);
                continue;
            }
            map.put(key, value);
        }
    }

    public boolean removeJar(File jar) {
        Iterator i = this.jars.iterator();
        while (i.hasNext()) {
            JarReader reader = (JarReader)i.next();
            JarInfo info = reader.getJarInfo();
            File jar2 = info.getJarFile();
            if (!jar.equals(jar2)) continue;
            i.remove();
            return true;
        }
        return false;
    }

    public static void setCheckModifiedDatestamps(boolean check) {
        checkModified = check;
    }
}

