/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.html;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import org.fife.rsta.ac.html.AttributeCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionCellRenderer;
import org.fife.ui.autocomplete.EmptyIcon;
import org.fife.ui.autocomplete.FunctionCompletion;
import org.fife.ui.autocomplete.MarkupTagCompletion;
import org.fife.ui.autocomplete.VariableCompletion;

public class HtmlCellRenderer
extends CompletionCellRenderer {
    private Icon tagIcon = this.getIcon("tag.png");
    private Icon attrIcon = this.getIcon("attribute.png");
    private Icon emptyIcon = new EmptyIcon(16);

    private Icon getIcon(String resource) {
        URL url = ((Object)((Object)this)).getClass().getResource(resource);
        if (url == null) {
            File file = new File(resource);
            try {
                url = file.toURI().toURL();
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
        }
        return url != null ? new ImageIcon(url) : null;
    }

    protected void prepareForFunctionCompletion(JList list, FunctionCompletion fc, int index, boolean selected, boolean hasFocus) {
        super.prepareForFunctionCompletion(list, fc, index, selected, hasFocus);
        this.setIcon(this.emptyIcon);
    }

    protected void prepareForMarkupTagCompletion(JList list, MarkupTagCompletion c, int index, boolean selected, boolean hasFocus) {
        super.prepareForMarkupTagCompletion(list, c, index, selected, hasFocus);
        this.setIcon(this.tagIcon);
    }

    protected void prepareForOtherCompletion(JList list, Completion c, int index, boolean selected, boolean hasFocus) {
        super.prepareForOtherCompletion(list, c, index, selected, hasFocus);
        if (c instanceof AttributeCompletion) {
            this.setIcon(this.attrIcon);
        } else {
            this.setIcon(this.emptyIcon);
        }
    }

    protected void prepareForVariableCompletion(JList list, VariableCompletion vc, int index, boolean selected, boolean hasFocus) {
        super.prepareForVariableCompletion(list, vc, index, selected, hasFocus);
        this.setIcon(this.emptyIcon);
    }
}

