/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.admin.model;

import com.docusign.admin.model.SubAccountCreateSubscriptionDetails;
import com.docusign.admin.model.SubAccountCreateTargetAccount;
import com.docusign.admin.model.SubAccountErrorDetails;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;

public class SubAccountCreateWorker
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="targetAccount")
    private SubAccountCreateTargetAccount targetAccount = null;
    @JsonProperty(value="subscriptionDetails")
    private SubAccountCreateSubscriptionDetails subscriptionDetails = null;
    @JsonProperty(value="assetGroupWorkId")
    private UUID assetGroupWorkId = null;
    @JsonProperty(value="assetGroupId")
    private UUID assetGroupId = null;
    @JsonProperty(value="assetGroupWorkType")
    private AssetGroupWorkTypeEnum assetGroupWorkType = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="orderId")
    private UUID orderId = null;
    @JsonProperty(value="attempts")
    private Integer attempts = null;
    @JsonProperty(value="createdDate")
    private String createdDate = null;
    @JsonProperty(value="createdByName")
    private String createdByName = null;
    @JsonProperty(value="createdByEmail")
    private String createdByEmail = null;
    @JsonProperty(value="message")
    private String message = null;
    @JsonProperty(value="createAccountProcessingFailureDetails")
    private SubAccountErrorDetails createAccountProcessingFailureDetails = null;

    public SubAccountCreateWorker targetAccount(SubAccountCreateTargetAccount targetAccount) {
        this.targetAccount = targetAccount;
        return this;
    }

    @Schema(required=true, description="The target account being created")
    public SubAccountCreateTargetAccount getTargetAccount() {
        return this.targetAccount;
    }

    public void setTargetAccount(SubAccountCreateTargetAccount targetAccount) {
        this.targetAccount = targetAccount;
    }

    public SubAccountCreateWorker subscriptionDetails(SubAccountCreateSubscriptionDetails subscriptionDetails) {
        this.subscriptionDetails = subscriptionDetails;
        return this;
    }

    @Schema(required=true, description="The subscription info to create the account")
    public SubAccountCreateSubscriptionDetails getSubscriptionDetails() {
        return this.subscriptionDetails;
    }

    public void setSubscriptionDetails(SubAccountCreateSubscriptionDetails subscriptionDetails) {
        this.subscriptionDetails = subscriptionDetails;
    }

    @Schema(example="00000000-0000-0000-0000-000000000000", description="The create account work id.")
    public UUID getAssetGroupWorkId() {
        return this.assetGroupWorkId;
    }

    @Schema(example="00000000-0000-0000-0000-000000000000", description="The asset group id the accounts belong to.")
    public UUID getAssetGroupId() {
        return this.assetGroupId;
    }

    @Schema(description="The type of asset group work.")
    public AssetGroupWorkTypeEnum getAssetGroupWorkType() {
        return this.assetGroupWorkType;
    }

    @Schema(description="The account creation status.")
    public StatusEnum getStatus() {
        return this.status;
    }

    @Schema(example="00000000-0000-0000-0000-000000000000", description="The order id created by the creation work.")
    public UUID getOrderId() {
        return this.orderId;
    }

    @Schema(description="The number of times the work has been attempted.")
    public Integer getAttempts() {
        return this.attempts;
    }

    @Schema(description="The date the account creation work is initiated.")
    public String getCreatedDate() {
        return this.createdDate;
    }

    @Schema(description="The name of the initiator of the account creation work.")
    public String getCreatedByName() {
        return this.createdByName;
    }

    @Schema(description="The email of the creator of the account creation work.")
    public String getCreatedByEmail() {
        return this.createdByEmail;
    }

    @Schema(description="The message associated with the account creation work.")
    public String getMessage() {
        return this.message;
    }

    @Schema(description="The processing failures if the work is in PendingError/ProcessingError status.")
    public SubAccountErrorDetails getCreateAccountProcessingFailureDetails() {
        return this.createAccountProcessingFailureDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubAccountCreateWorker subAccountCreateWorker = (SubAccountCreateWorker)o;
        return Objects.equals(this.targetAccount, subAccountCreateWorker.targetAccount) && Objects.equals(this.subscriptionDetails, subAccountCreateWorker.subscriptionDetails) && Objects.equals(this.assetGroupWorkId, subAccountCreateWorker.assetGroupWorkId) && Objects.equals(this.assetGroupId, subAccountCreateWorker.assetGroupId) && Objects.equals((Object)this.assetGroupWorkType, (Object)subAccountCreateWorker.assetGroupWorkType) && Objects.equals((Object)this.status, (Object)subAccountCreateWorker.status) && Objects.equals(this.orderId, subAccountCreateWorker.orderId) && Objects.equals(this.attempts, subAccountCreateWorker.attempts) && Objects.equals(this.createdDate, subAccountCreateWorker.createdDate) && Objects.equals(this.createdByName, subAccountCreateWorker.createdByName) && Objects.equals(this.createdByEmail, subAccountCreateWorker.createdByEmail) && Objects.equals(this.message, subAccountCreateWorker.message) && Objects.equals(this.createAccountProcessingFailureDetails, subAccountCreateWorker.createAccountProcessingFailureDetails);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.targetAccount, this.subscriptionDetails, this.assetGroupWorkId, this.assetGroupId, this.assetGroupWorkType, this.status, this.orderId, this.attempts, this.createdDate, this.createdByName, this.createdByEmail, this.message, this.createAccountProcessingFailureDetails});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubAccountCreateWorker {\n");
        sb.append("    targetAccount: ").append(this.toIndentedString(this.targetAccount)).append("\n");
        sb.append("    subscriptionDetails: ").append(this.toIndentedString(this.subscriptionDetails)).append("\n");
        sb.append("    assetGroupWorkId: ").append(this.toIndentedString(this.assetGroupWorkId)).append("\n");
        sb.append("    assetGroupId: ").append(this.toIndentedString(this.assetGroupId)).append("\n");
        sb.append("    assetGroupWorkType: ").append(this.toIndentedString((Object)this.assetGroupWorkType)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("    attempts: ").append(this.toIndentedString(this.attempts)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    createdByName: ").append(this.toIndentedString(this.createdByName)).append("\n");
        sb.append("    createdByEmail: ").append(this.toIndentedString(this.createdByEmail)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    createAccountProcessingFailureDetails: ").append(this.toIndentedString(this.createAccountProcessingFailureDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        UNDEFINED("Undefined"),
        PENDING("Pending"),
        PROCESSING("Processing"),
        PROCESSINGONHOLD("ProcessingOnHold"),
        PENDINGERROR("PendingError"),
        PROCESSINGERROR("ProcessingError"),
        COMPLETED("Completed"),
        CANCELED("Canceled"),
        PERMANENTFAILURE("PermanentFailure");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum AssetGroupWorkTypeEnum {
        UNDEFINED("Undefined"),
        GROUPASSETFULFILLMENT("GroupAssetFulfillment"),
        ACCOUNTASSETFULFILLMENT("AccountAssetFulfillment"),
        ACCOUNTASSETCLONE("AccountAssetClone"),
        ACCOUNTASSETCREATE("AccountAssetCreate"),
        SUBSCRIPTIONSYNC("SubscriptionSync");

        private String value;

        private AssetGroupWorkTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AssetGroupWorkTypeEnum fromValue(String value) {
            for (AssetGroupWorkTypeEnum b : AssetGroupWorkTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }
}

