/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.executor;

import com.dangdang.ddframe.job.api.ElasticJob;
import com.dangdang.ddframe.job.api.dataflow.DataflowJob;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import com.dangdang.ddframe.job.exception.JobConfigurationException;
import com.dangdang.ddframe.job.executor.AbstractElasticJobExecutor;
import com.dangdang.ddframe.job.executor.JobFacade;
import com.dangdang.ddframe.job.executor.type.DataflowJobExecutor;
import com.dangdang.ddframe.job.executor.type.ScriptJobExecutor;
import com.dangdang.ddframe.job.executor.type.SimpleJobExecutor;

public final class JobExecutorFactory {
    public static AbstractElasticJobExecutor getJobExecutor(ElasticJob elasticJob, JobFacade jobFacade) {
        if (null == elasticJob) {
            return new ScriptJobExecutor(jobFacade);
        }
        if (elasticJob instanceof SimpleJob) {
            return new SimpleJobExecutor((SimpleJob)elasticJob, jobFacade);
        }
        if (elasticJob instanceof DataflowJob) {
            return new DataflowJobExecutor((DataflowJob)elasticJob, jobFacade);
        }
        throw new JobConfigurationException("Cannot support job type '%s'", elasticJob.getClass().getCanonicalName());
    }

    private JobExecutorFactory() {
    }
}

