/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.serialization.json;

import com.box.sdkgen.serialization.json.Valuable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class EnumWrapper<E extends Enum<E>>
implements Valuable {
    private E value;
    private final String stringValue;

    public EnumWrapper(E enumValue) {
        this.stringValue = ((Valuable)enumValue).getValue();
        this.value = enumValue;
    }

    public EnumWrapper(String value) {
        this.stringValue = value;
    }

    public E getEnumValue() {
        return this.value;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    @Override
    public String getValue() {
        return this.stringValue;
    }

    public String toString() {
        return "EnumWrapper{value=" + this.value + ", stringValue='" + this.stringValue + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumWrapper casted = (EnumWrapper)o;
        return Objects.equals(this.stringValue, casted.stringValue);
    }

    public int hashCode() {
        return Objects.hash(this.stringValue);
    }

    public static <T extends Enum<T>> List<EnumWrapper<T>> wrapValuableEnumList(List<? extends Valuable> listField, Class<T> enumType) {
        if (listField == null || listField.isEmpty()) {
            return Collections.emptyList();
        }
        return listField.stream().map(field -> {
            if (field instanceof EnumWrapper) {
                return (EnumWrapper)field;
            }
            if (field.getClass().isAssignableFrom(enumType)) {
                return new EnumWrapper<Enum>((Enum)enumType.cast(field));
            }
            throw new IllegalArgumentException("Unsupported type: " + field.getClass());
        }).collect(Collectors.toList());
    }

    public static <T extends Enum<T>> List<List<EnumWrapper<T>>> wrapValuableEnumListOfLists(List<List<? extends Valuable>> listOfLists, Class<T> enumType) {
        if (listOfLists == null || listOfLists.isEmpty()) {
            return Collections.emptyList();
        }
        return listOfLists.stream().map(list -> EnumWrapper.wrapValuableEnumList(list, enumType)).collect(Collectors.toList());
    }

    public static <T extends Enum<T>> List<EnumWrapper<T>> wrapListOfEnums(List<T> enums) {
        return enums.stream().map(x$0 -> new EnumWrapper<Enum>((Enum)x$0)).collect(Collectors.toList());
    }

    public static <T extends Enum<T>> List<List<EnumWrapper<T>>> wrapListOfListsOfEnums(List<List<T>> listOfEnums) {
        return listOfEnums.stream().map(EnumWrapper::wrapListOfEnums).collect(Collectors.toList());
    }

    public static <T extends Enum<T>> String convertToString(EnumWrapper<T> enumValue) {
        if (enumValue == null) {
            return null;
        }
        return enumValue.getStringValue();
    }

    public static <T extends Enum<T>> List<String> convertToString(List<EnumWrapper<T>> enumValue) {
        if (enumValue == null) {
            return null;
        }
        return enumValue.stream().map(EnumWrapper::getStringValue).collect(Collectors.toList());
    }
}

