/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class StaticWebsite
implements XmlSerializable<StaticWebsite> {
    private boolean enabled;
    private String indexDocument;
    private String errorDocument404Path;
    private String defaultIndexDocumentPath;

    public boolean isEnabled() {
        return this.enabled;
    }

    public StaticWebsite setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getIndexDocument() {
        return this.indexDocument;
    }

    public StaticWebsite setIndexDocument(String indexDocument) {
        this.indexDocument = indexDocument;
        return this;
    }

    public String getErrorDocument404Path() {
        return this.errorDocument404Path;
    }

    public StaticWebsite setErrorDocument404Path(String errorDocument404Path) {
        this.errorDocument404Path = errorDocument404Path;
        return this;
    }

    public String getDefaultIndexDocumentPath() {
        return this.defaultIndexDocumentPath;
    }

    public StaticWebsite setDefaultIndexDocumentPath(String defaultIndexDocumentPath) {
        this.defaultIndexDocumentPath = defaultIndexDocumentPath;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "StaticWebsite" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeBooleanElement("Enabled", this.enabled);
        xmlWriter.writeStringElement("IndexDocument", this.indexDocument);
        xmlWriter.writeStringElement("ErrorDocument404Path", this.errorDocument404Path);
        xmlWriter.writeStringElement("DefaultIndexDocumentPath", this.defaultIndexDocumentPath);
        return xmlWriter.writeEndElement();
    }

    public static StaticWebsite fromXml(XmlReader xmlReader) throws XMLStreamException {
        return StaticWebsite.fromXml(xmlReader, null);
    }

    public static StaticWebsite fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "StaticWebsite" : rootElementName;
        return (StaticWebsite)xmlReader.readObject(finalRootElementName, reader -> {
            StaticWebsite deserializedStaticWebsite = new StaticWebsite();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Enabled".equals(elementName.getLocalPart())) {
                    deserializedStaticWebsite.enabled = reader.getBooleanElement();
                    continue;
                }
                if ("IndexDocument".equals(elementName.getLocalPart())) {
                    deserializedStaticWebsite.indexDocument = reader.getStringElement();
                    continue;
                }
                if ("ErrorDocument404Path".equals(elementName.getLocalPart())) {
                    deserializedStaticWebsite.errorDocument404Path = reader.getStringElement();
                    continue;
                }
                if ("DefaultIndexDocumentPath".equals(elementName.getLocalPart())) {
                    deserializedStaticWebsite.defaultIndexDocumentPath = reader.getStringElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedStaticWebsite;
        });
    }
}

