/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.data.tables.implementation.AzureTableImpl;
import com.azure.data.tables.implementation.models.TableServiceJsonErrorException;
import com.azure.data.tables.implementation.models.TransactionalBatchRequestBody;
import com.azure.data.tables.implementation.models.TransactionalBatchSubmitBatchHeaders;
import com.azure.data.tables.models.TableTransactionActionResponse;
import reactor.core.publisher.Mono;

public final class TransactionalBatchImpl {
    private final TransactionalBatchService service;
    private final AzureTableImpl client;

    public TransactionalBatchImpl(AzureTableImpl client, SerializerAdapter transactionalBatchSerializer) {
        this.service = (TransactionalBatchService)RestProxy.create(TransactionalBatchService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)transactionalBatchSerializer);
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<TransactionalBatchSubmitBatchHeaders, TableTransactionActionResponse[]>> submitTransactionalBatchWithRestResponseAsync(TransactionalBatchRequestBody body, String requestId, Context context) {
        String dataServiceVersion = "3.0";
        return this.service.submitTransactionalBatch(this.client.getUrl(), body.getContentType(), this.client.getVersion(), requestId, "3.0", body, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<TransactionalBatchSubmitBatchHeaders, TableTransactionActionResponse[]> submitTransactionalBatchWithRestResponse(TransactionalBatchRequestBody body, String requestId, Context context) {
        String dataServiceVersion = "3.0";
        return this.service.submitTransactionalBatchSync(this.client.getUrl(), body.getContentType(), this.client.getVersion(), requestId, "3.0", body, context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureTableServices")
    public static interface TransactionalBatchService {
        @Post(value="/$batch")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=TableServiceJsonErrorException.class)
        public Mono<ResponseBase<TransactionalBatchSubmitBatchHeaders, TableTransactionActionResponse[]>> submitTransactionalBatch(@HostParam(value="url") String var1, @HeaderParam(value="Content-Type") String var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="DataServiceVersion") String var5, @BodyParam(value="multipart/mixed") TransactionalBatchRequestBody var6, Context var7);

        @Post(value="/$batch")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=TableServiceJsonErrorException.class)
        public ResponseBase<TransactionalBatchSubmitBatchHeaders, TableTransactionActionResponse[]> submitTransactionalBatchSync(@HostParam(value="url") String var1, @HeaderParam(value="Content-Type") String var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="DataServiceVersion") String var5, @BodyParam(value="multipart/mixed") TransactionalBatchRequestBody var6, Context var7);
    }
}

