/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.data.tables.models.TableSignedIdentifier;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class TableSignedIdentifierWrapper
implements XmlSerializable<TableSignedIdentifierWrapper> {
    private final List<TableSignedIdentifier> signedIdentifiers;

    public TableSignedIdentifierWrapper(List<TableSignedIdentifier> signedIdentifiers) {
        this.signedIdentifiers = signedIdentifiers;
    }

    public List<TableSignedIdentifier> items() {
        return this.signedIdentifiers;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "SignedIdentifiers" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (this.signedIdentifiers != null) {
            for (TableSignedIdentifier element : this.signedIdentifiers) {
                xmlWriter.writeXml((XmlSerializable)element, "SignedIdentifier");
            }
        }
        return xmlWriter.writeEndElement();
    }

    public static TableSignedIdentifierWrapper fromXml(XmlReader xmlReader) throws XMLStreamException {
        return TableSignedIdentifierWrapper.fromXml(xmlReader, null);
    }

    public static TableSignedIdentifierWrapper fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "SignedIdentifiers" : rootElementName;
        return (TableSignedIdentifierWrapper)xmlReader.readObject(rootElementName, reader -> {
            ArrayList<TableSignedIdentifier> items = null;
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("SignedIdentifier".equals(elementName.getLocalPart())) {
                    if (items == null) {
                        items = new ArrayList<TableSignedIdentifier>();
                    }
                    items.add(TableSignedIdentifier.fromXml(reader));
                    continue;
                }
                reader.nextElement();
            }
            return new TableSignedIdentifierWrapper(items);
        });
    }
}

