// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.appconfiguration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

/**
 * The KeyValue model.
 */
@Fluent
public final class KeyValue implements JsonSerializable<KeyValue> {
    /*
     * The key of the key-value.
     */
    private String key;

    /*
     * The label the key-value belongs to.
     */
    private String label;

    /*
     * The content type of the value stored within the key-value.
     */
    private String contentType;

    /*
     * The value of the key-value.
     */
    private String value;

    /*
     * A date representing the last time the key-value was modified.
     */
    private OffsetDateTime lastModified;

    /*
     * The tags of the key-value
     */
    private Map<String, String> tags;

    /*
     * Indicates whether the key-value is locked.
     */
    private Boolean locked;

    /*
     * A value representing the current state of the resource.
     */
    private String etag;

    /**
     * Creates an instance of KeyValue class.
     */
    public KeyValue() {
    }

    /**
     * Get the key property: The key of the key-value.
     * 
     * @return the key value.
     */
    public String getKey() {
        return this.key;
    }

    /**
     * Set the key property: The key of the key-value.
     * 
     * @param key the key value to set.
     * @return the KeyValue object itself.
     */
    public KeyValue setKey(String key) {
        this.key = key;
        return this;
    }

    /**
     * Get the label property: The label the key-value belongs to.
     * 
     * @return the label value.
     */
    public String getLabel() {
        return this.label;
    }

    /**
     * Set the label property: The label the key-value belongs to.
     * 
     * @param label the label value to set.
     * @return the KeyValue object itself.
     */
    public KeyValue setLabel(String label) {
        this.label = label;
        return this;
    }

    /**
     * Get the contentType property: The content type of the value stored within the key-value.
     * 
     * @return the contentType value.
     */
    public String getContentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: The content type of the value stored within the key-value.
     * 
     * @param contentType the contentType value to set.
     * @return the KeyValue object itself.
     */
    public KeyValue setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the value property: The value of the key-value.
     * 
     * @return the value value.
     */
    public String getValue() {
        return this.value;
    }

    /**
     * Set the value property: The value of the key-value.
     * 
     * @param value the value value to set.
     * @return the KeyValue object itself.
     */
    public KeyValue setValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the lastModified property: A date representing the last time the key-value was modified.
     * 
     * @return the lastModified value.
     */
    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    /**
     * Set the lastModified property: A date representing the last time the key-value was modified.
     * 
     * @param lastModified the lastModified value to set.
     * @return the KeyValue object itself.
     */
    public KeyValue setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    /**
     * Get the tags property: The tags of the key-value.
     * 
     * @return the tags value.
     */
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: The tags of the key-value.
     * 
     * @param tags the tags value to set.
     * @return the KeyValue object itself.
     */
    public KeyValue setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the locked property: Indicates whether the key-value is locked.
     * 
     * @return the locked value.
     */
    public Boolean isLocked() {
        return this.locked;
    }

    /**
     * Set the locked property: Indicates whether the key-value is locked.
     * 
     * @param locked the locked value to set.
     * @return the KeyValue object itself.
     */
    public KeyValue setLocked(Boolean locked) {
        this.locked = locked;
        return this;
    }

    /**
     * Get the etag property: A value representing the current state of the resource.
     * 
     * @return the etag value.
     */
    public String getEtag() {
        return this.etag;
    }

    /**
     * Set the etag property: A value representing the current state of the resource.
     * 
     * @param etag the etag value to set.
     * @return the KeyValue object itself.
     */
    public KeyValue setEtag(String etag) {
        this.etag = etag;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key);
        jsonWriter.writeStringField("label", this.label);
        jsonWriter.writeStringField("content_type", this.contentType);
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("last_modified",
            this.lastModified == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModified));
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("locked", this.locked);
        jsonWriter.writeStringField("etag", this.etag);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyValue from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyValue if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the KeyValue.
     */
    public static KeyValue fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyValue deserializedKeyValue = new KeyValue();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("key".equals(fieldName)) {
                    deserializedKeyValue.key = reader.getString();
                } else if ("label".equals(fieldName)) {
                    deserializedKeyValue.label = reader.getString();
                } else if ("content_type".equals(fieldName)) {
                    deserializedKeyValue.contentType = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedKeyValue.value = reader.getString();
                } else if ("last_modified".equals(fieldName)) {
                    deserializedKeyValue.lastModified
                        = reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedKeyValue.tags = tags;
                } else if ("locked".equals(fieldName)) {
                    deserializedKeyValue.locked = reader.getNullable(JsonReader::getBoolean);
                } else if ("etag".equals(fieldName)) {
                    deserializedKeyValue.etag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyValue;
        });
    }
}
