/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.implementation.models;

import com.azure.data.appconfiguration.implementation.models.ErrorDetail;
import com.azure.data.appconfiguration.implementation.models.State;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;

public final class OperationDetails
implements JsonSerializable<OperationDetails> {
    private final String id;
    private final State status;
    private ErrorDetail error;

    public OperationDetails(String id, State status) {
        this.id = id;
        this.status = status;
    }

    public String getId() {
        return this.id;
    }

    public State getStatus() {
        return this.status;
    }

    public ErrorDetail getError() {
        return this.error;
    }

    public OperationDetails setError(ErrorDetail error) {
        this.error = error;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("status", Objects.toString((Object)this.status, null));
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static OperationDetails fromJson(JsonReader jsonReader) throws IOException {
        return (OperationDetails)jsonReader.readObject(reader -> {
            boolean idFound = false;
            String id = null;
            boolean statusFound = false;
            State status = null;
            ErrorDetail error = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    idFound = true;
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = State.fromString(reader.getString());
                    statusFound = true;
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = ErrorDetail.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (idFound && statusFound) {
                OperationDetails deserializedOperationDetails = new OperationDetails(id, status);
                deserializedOperationDetails.error = error;
                return deserializedOperationDetails;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!idFound) {
                missingProperties.add("id");
            }
            if (!statusFound) {
                missingProperties.add("status");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

