/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class ConfigurationSettingsFilter
implements JsonSerializable<ConfigurationSettingsFilter> {
    private final String key;
    private String label;

    public ConfigurationSettingsFilter(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public String getLabel() {
        return this.label;
    }

    public ConfigurationSettingsFilter setLabel(String label) {
        this.label = label;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key);
        jsonWriter.writeStringField("label", this.label);
        return jsonWriter.writeEndObject();
    }

    public static ConfigurationSettingsFilter fromJson(JsonReader jsonReader) throws IOException {
        return (ConfigurationSettingsFilter)jsonReader.readObject(reader -> {
            boolean keyFound = false;
            String key = null;
            String label = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    key = reader.getString();
                    keyFound = true;
                    continue;
                }
                if ("label".equals(fieldName)) {
                    label = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (keyFound) {
                ConfigurationSettingsFilter deserializedConfigurationSettingsFilter = new ConfigurationSettingsFilter(key);
                deserializedConfigurationSettingsFilter.label = label;
                return deserializedConfigurationSettingsFilter;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!keyFound) {
                missingProperties.add("key");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

