/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.data.appconfiguration.implementation.models.CheckKeyValueHeaders;
import com.azure.data.appconfiguration.implementation.models.CheckKeyValuesHeaders;
import com.azure.data.appconfiguration.implementation.models.CheckKeysHeaders;
import com.azure.data.appconfiguration.implementation.models.CheckLabelsHeaders;
import com.azure.data.appconfiguration.implementation.models.CheckRevisionsHeaders;
import com.azure.data.appconfiguration.implementation.models.CheckSnapshotHeaders;
import com.azure.data.appconfiguration.implementation.models.CheckSnapshotsHeaders;
import com.azure.data.appconfiguration.implementation.models.CreateSnapshotHeaders;
import com.azure.data.appconfiguration.implementation.models.DeleteKeyValueHeaders;
import com.azure.data.appconfiguration.implementation.models.DeleteLockHeaders;
import com.azure.data.appconfiguration.implementation.models.GetKeyValueHeaders;
import com.azure.data.appconfiguration.implementation.models.GetKeyValuesHeaders;
import com.azure.data.appconfiguration.implementation.models.GetKeyValuesNextHeaders;
import com.azure.data.appconfiguration.implementation.models.GetKeysHeaders;
import com.azure.data.appconfiguration.implementation.models.GetKeysNextHeaders;
import com.azure.data.appconfiguration.implementation.models.GetLabelsHeaders;
import com.azure.data.appconfiguration.implementation.models.GetLabelsNextHeaders;
import com.azure.data.appconfiguration.implementation.models.GetRevisionsHeaders;
import com.azure.data.appconfiguration.implementation.models.GetRevisionsNextHeaders;
import com.azure.data.appconfiguration.implementation.models.GetSnapshotHeaders;
import com.azure.data.appconfiguration.implementation.models.GetSnapshotsHeaders;
import com.azure.data.appconfiguration.implementation.models.GetSnapshotsNextHeaders;
import com.azure.data.appconfiguration.implementation.models.Key;
import com.azure.data.appconfiguration.implementation.models.KeyListResult;
import com.azure.data.appconfiguration.implementation.models.KeyValue;
import com.azure.data.appconfiguration.implementation.models.KeyValueListResult;
import com.azure.data.appconfiguration.implementation.models.Label;
import com.azure.data.appconfiguration.implementation.models.LabelFields;
import com.azure.data.appconfiguration.implementation.models.LabelListResult;
import com.azure.data.appconfiguration.implementation.models.OperationDetails;
import com.azure.data.appconfiguration.implementation.models.PutKeyValueHeaders;
import com.azure.data.appconfiguration.implementation.models.PutLockHeaders;
import com.azure.data.appconfiguration.implementation.models.SnapshotListResult;
import com.azure.data.appconfiguration.implementation.models.SnapshotUpdateParameters;
import com.azure.data.appconfiguration.implementation.models.UpdateSnapshotHeaders;
import com.azure.data.appconfiguration.models.ConfigurationSnapshot;
import com.azure.data.appconfiguration.models.ConfigurationSnapshotStatus;
import com.azure.data.appconfiguration.models.SettingFields;
import com.azure.data.appconfiguration.models.SnapshotFields;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class AzureAppConfigurationImpl {
    private final AzureAppConfigurationService service;
    private final String syncToken;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getSyncToken() {
        return this.syncToken;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public AzureAppConfigurationImpl(String syncToken, String endpoint, String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), syncToken, endpoint, apiVersion);
    }

    public AzureAppConfigurationImpl(HttpPipeline httpPipeline, String syncToken, String endpoint, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), syncToken, endpoint, apiVersion);
    }

    public AzureAppConfigurationImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String syncToken, String endpoint, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.syncToken = syncToken;
        this.endpoint = endpoint;
        this.apiVersion = apiVersion;
        this.service = (AzureAppConfigurationService)RestProxy.create(AzureAppConfigurationService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<Key>> getKeysSinglePageAsync(String name, String after, String acceptDatetime) {
        String accept = "application/vnd.microsoft.appconfig.keyset+json, application/problem+json";
        return FluxUtil.withContext(context -> this.service.getKeys(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, "application/vnd.microsoft.appconfig.keyset+json, application/problem+json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyListResult)res.getValue()).getItems(), ((KeyListResult)res.getValue()).getNextLink(), (Object)((GetKeysHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<Key>> getKeysSinglePageAsync(String name, String after, String acceptDatetime, Context context) {
        String accept = "application/vnd.microsoft.appconfig.keyset+json, application/problem+json";
        return this.service.getKeys(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, "application/vnd.microsoft.appconfig.keyset+json, application/problem+json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyListResult)res.getValue()).getItems(), ((KeyListResult)res.getValue()).getNextLink(), (Object)((GetKeysHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<Key> getKeysAsync(String name, String after, String acceptDatetime) {
        return new PagedFlux(() -> this.getKeysSinglePageAsync(name, after, acceptDatetime), nextLink -> this.getKeysNextSinglePageAsync((String)nextLink, acceptDatetime));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<Key> getKeysAsync(String name, String after, String acceptDatetime, Context context) {
        return new PagedFlux(() -> this.getKeysSinglePageAsync(name, after, acceptDatetime, context), nextLink -> this.getKeysNextSinglePageAsync((String)nextLink, acceptDatetime, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<Key> getKeysSinglePage(String name, String after, String acceptDatetime) {
        String accept = "application/vnd.microsoft.appconfig.keyset+json, application/problem+json";
        ResponseBase<GetKeysHeaders, KeyListResult> res = this.service.getKeysSync(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, "application/vnd.microsoft.appconfig.keyset+json, application/problem+json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyListResult)res.getValue()).getItems(), ((KeyListResult)res.getValue()).getNextLink(), (Object)((GetKeysHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<Key> getKeysSinglePage(String name, String after, String acceptDatetime, Context context) {
        String accept = "application/vnd.microsoft.appconfig.keyset+json, application/problem+json";
        ResponseBase<GetKeysHeaders, KeyListResult> res = this.service.getKeysSync(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, "application/vnd.microsoft.appconfig.keyset+json, application/problem+json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyListResult)res.getValue()).getItems(), ((KeyListResult)res.getValue()).getNextLink(), (Object)((GetKeysHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<Key> getKeys(String name, String after, String acceptDatetime) {
        return new PagedIterable(() -> this.getKeysSinglePage(name, after, acceptDatetime, Context.NONE), nextLink -> this.getKeysNextSinglePage((String)nextLink, acceptDatetime));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<Key> getKeys(String name, String after, String acceptDatetime, Context context) {
        return new PagedIterable(() -> this.getKeysSinglePage(name, after, acceptDatetime, context), nextLink -> this.getKeysNextSinglePage((String)nextLink, acceptDatetime, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CheckKeysHeaders, Void>> checkKeysWithResponseAsync(String name, String after, String acceptDatetime) {
        return FluxUtil.withContext(context -> this.service.checkKeys(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CheckKeysHeaders, Void>> checkKeysWithResponseAsync(String name, String after, String acceptDatetime, Context context) {
        return this.service.checkKeys(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> checkKeysAsync(String name, String after, String acceptDatetime) {
        return this.checkKeysWithResponseAsync(name, after, acceptDatetime).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> checkKeysAsync(String name, String after, String acceptDatetime, Context context) {
        return this.checkKeysWithResponseAsync(name, after, acceptDatetime, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<CheckKeysHeaders, Void> checkKeysWithResponse(String name, String after, String acceptDatetime, Context context) {
        return this.service.checkKeysSync(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void checkKeys(String name, String after, String acceptDatetime) {
        this.checkKeysWithResponse(name, after, acceptDatetime, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<KeyValue>> getKeyValuesSinglePageAsync(String key, String label, String after, String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch) {
        String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.getKeyValues(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, snapshot, ifMatch, ifNoneMatch, "application/vnd.microsoft.appconfig.kvset+json, application/problem+json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyValueListResult)res.getValue()).getItems(), ((KeyValueListResult)res.getValue()).getNextLink(), (Object)((GetKeyValuesHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<KeyValue>> getKeyValuesSinglePageAsync(String key, String label, String after, String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch, Context context) {
        String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.getKeyValues(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, snapshot, ifMatch, ifNoneMatch, "application/vnd.microsoft.appconfig.kvset+json, application/problem+json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyValueListResult)res.getValue()).getItems(), ((KeyValueListResult)res.getValue()).getNextLink(), (Object)((GetKeyValuesHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KeyValue> getKeyValuesAsync(String key, String label, String after, String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch) {
        return new PagedFlux(() -> this.getKeyValuesSinglePageAsync(key, label, after, acceptDatetime, select, snapshot, ifMatch, ifNoneMatch), nextLink -> this.getKeyValuesNextSinglePageAsync((String)nextLink, acceptDatetime, ifMatch, ifNoneMatch));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KeyValue> getKeyValuesAsync(String key, String label, String after, String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch, Context context) {
        return new PagedFlux(() -> this.getKeyValuesSinglePageAsync(key, label, after, acceptDatetime, select, snapshot, ifMatch, ifNoneMatch, context), nextLink -> this.getKeyValuesNextSinglePageAsync((String)nextLink, acceptDatetime, ifMatch, ifNoneMatch, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<KeyValue> getKeyValuesSinglePage(String key, String label, String after, String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch) {
        String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        ResponseBase<GetKeyValuesHeaders, KeyValueListResult> res = this.service.getKeyValuesSync(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, snapshot, ifMatch, ifNoneMatch, "application/vnd.microsoft.appconfig.kvset+json, application/problem+json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyValueListResult)res.getValue()).getItems(), ((KeyValueListResult)res.getValue()).getNextLink(), (Object)((GetKeyValuesHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<KeyValue> getKeyValuesSinglePage(String key, String label, String after, String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch, Context context) {
        String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        ResponseBase<GetKeyValuesHeaders, KeyValueListResult> res = this.service.getKeyValuesSync(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, snapshot, ifMatch, ifNoneMatch, "application/vnd.microsoft.appconfig.kvset+json, application/problem+json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyValueListResult)res.getValue()).getItems(), ((KeyValueListResult)res.getValue()).getNextLink(), (Object)((GetKeyValuesHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyValue> getKeyValues(String key, String label, String after, String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch) {
        return new PagedIterable(() -> this.getKeyValuesSinglePage(key, label, after, acceptDatetime, select, snapshot, ifMatch, ifNoneMatch, Context.NONE), nextLink -> this.getKeyValuesNextSinglePage((String)nextLink, acceptDatetime, ifMatch, ifNoneMatch));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyValue> getKeyValues(String key, String label, String after, String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch, Context context) {
        return new PagedIterable(() -> this.getKeyValuesSinglePage(key, label, after, acceptDatetime, select, snapshot, ifMatch, ifNoneMatch, context), nextLink -> this.getKeyValuesNextSinglePage((String)nextLink, acceptDatetime, ifMatch, ifNoneMatch, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CheckKeyValuesHeaders, Void>> checkKeyValuesWithResponseAsync(String key, String label, String after, String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch) {
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.checkKeyValues(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, snapshot, ifMatch, ifNoneMatch, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CheckKeyValuesHeaders, Void>> checkKeyValuesWithResponseAsync(String key, String label, String after, String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch, Context context) {
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.checkKeyValues(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, snapshot, ifMatch, ifNoneMatch, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> checkKeyValuesAsync(String key, String label, String after, String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch) {
        return this.checkKeyValuesWithResponseAsync(key, label, after, acceptDatetime, select, snapshot, ifMatch, ifNoneMatch).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> checkKeyValuesAsync(String key, String label, String after, String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch, Context context) {
        return this.checkKeyValuesWithResponseAsync(key, label, after, acceptDatetime, select, snapshot, ifMatch, ifNoneMatch, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<CheckKeyValuesHeaders, Void> checkKeyValuesWithResponse(String key, String label, String after, String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch, Context context) {
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.checkKeyValuesSync(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, snapshot, ifMatch, ifNoneMatch, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void checkKeyValues(String key, String label, String after, String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch) {
        this.checkKeyValuesWithResponse(key, label, after, acceptDatetime, select, snapshot, ifMatch, ifNoneMatch, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<GetKeyValueHeaders, KeyValue>> getKeyValueWithResponseAsync(String key, String label, String acceptDatetime, String ifMatch, String ifNoneMatch, List<SettingFields> select) {
        String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.getKeyValue(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), acceptDatetime, ifMatch, ifNoneMatch, selectConverted, "application/vnd.microsoft.appconfig.kv+json, application/problem+json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<GetKeyValueHeaders, KeyValue>> getKeyValueWithResponseAsync(String key, String label, String acceptDatetime, String ifMatch, String ifNoneMatch, List<SettingFields> select, Context context) {
        String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.getKeyValue(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), acceptDatetime, ifMatch, ifNoneMatch, selectConverted, "application/vnd.microsoft.appconfig.kv+json, application/problem+json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyValue> getKeyValueAsync(String key, String label, String acceptDatetime, String ifMatch, String ifNoneMatch, List<SettingFields> select) {
        return this.getKeyValueWithResponseAsync(key, label, acceptDatetime, ifMatch, ifNoneMatch, select).flatMap(res -> Mono.justOrEmpty((Object)((KeyValue)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyValue> getKeyValueAsync(String key, String label, String acceptDatetime, String ifMatch, String ifNoneMatch, List<SettingFields> select, Context context) {
        return this.getKeyValueWithResponseAsync(key, label, acceptDatetime, ifMatch, ifNoneMatch, select, context).flatMap(res -> Mono.justOrEmpty((Object)((KeyValue)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<GetKeyValueHeaders, KeyValue> getKeyValueWithResponse(String key, String label, String acceptDatetime, String ifMatch, String ifNoneMatch, List<SettingFields> select, Context context) {
        String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.getKeyValueSync(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), acceptDatetime, ifMatch, ifNoneMatch, selectConverted, "application/vnd.microsoft.appconfig.kv+json, application/problem+json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyValue getKeyValue(String key, String label, String acceptDatetime, String ifMatch, String ifNoneMatch, List<SettingFields> select) {
        return (KeyValue)this.getKeyValueWithResponse(key, label, acceptDatetime, ifMatch, ifNoneMatch, select, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PutKeyValueHeaders, KeyValue>> putKeyValueWithResponseAsync(String key, String label, String ifMatch, String ifNoneMatch, KeyValue entity) {
        String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return FluxUtil.withContext(context -> this.service.putKeyValue(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), ifMatch, ifNoneMatch, entity, "application/vnd.microsoft.appconfig.kv+json, application/problem+json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PutKeyValueHeaders, KeyValue>> putKeyValueWithResponseAsync(String key, String label, String ifMatch, String ifNoneMatch, KeyValue entity, Context context) {
        String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return this.service.putKeyValue(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), ifMatch, ifNoneMatch, entity, "application/vnd.microsoft.appconfig.kv+json, application/problem+json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyValue> putKeyValueAsync(String key, String label, String ifMatch, String ifNoneMatch, KeyValue entity) {
        return this.putKeyValueWithResponseAsync(key, label, ifMatch, ifNoneMatch, entity).flatMap(res -> Mono.justOrEmpty((Object)((KeyValue)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyValue> putKeyValueAsync(String key, String label, String ifMatch, String ifNoneMatch, KeyValue entity, Context context) {
        return this.putKeyValueWithResponseAsync(key, label, ifMatch, ifNoneMatch, entity, context).flatMap(res -> Mono.justOrEmpty((Object)((KeyValue)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<PutKeyValueHeaders, KeyValue> putKeyValueWithResponse(String key, String label, String ifMatch, String ifNoneMatch, KeyValue entity, Context context) {
        String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return this.service.putKeyValueSync(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), ifMatch, ifNoneMatch, entity, "application/vnd.microsoft.appconfig.kv+json, application/problem+json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyValue putKeyValue(String key, String label, String ifMatch, String ifNoneMatch, KeyValue entity) {
        return (KeyValue)this.putKeyValueWithResponse(key, label, ifMatch, ifNoneMatch, entity, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DeleteKeyValueHeaders, KeyValue>> deleteKeyValueWithResponseAsync(String key, String label, String ifMatch) {
        String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return FluxUtil.withContext(context -> this.service.deleteKeyValue(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), ifMatch, "application/vnd.microsoft.appconfig.kv+json, application/problem+json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DeleteKeyValueHeaders, KeyValue>> deleteKeyValueWithResponseAsync(String key, String label, String ifMatch, Context context) {
        String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return this.service.deleteKeyValue(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), ifMatch, "application/vnd.microsoft.appconfig.kv+json, application/problem+json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyValue> deleteKeyValueAsync(String key, String label, String ifMatch) {
        return this.deleteKeyValueWithResponseAsync(key, label, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((KeyValue)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyValue> deleteKeyValueAsync(String key, String label, String ifMatch, Context context) {
        return this.deleteKeyValueWithResponseAsync(key, label, ifMatch, context).flatMap(res -> Mono.justOrEmpty((Object)((KeyValue)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<DeleteKeyValueHeaders, KeyValue> deleteKeyValueWithResponse(String key, String label, String ifMatch, Context context) {
        String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return this.service.deleteKeyValueSync(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), ifMatch, "application/vnd.microsoft.appconfig.kv+json, application/problem+json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyValue deleteKeyValue(String key, String label, String ifMatch) {
        return (KeyValue)this.deleteKeyValueWithResponse(key, label, ifMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CheckKeyValueHeaders, Void>> checkKeyValueWithResponseAsync(String key, String label, String acceptDatetime, String ifMatch, String ifNoneMatch, List<SettingFields> select) {
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.checkKeyValue(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), acceptDatetime, ifMatch, ifNoneMatch, selectConverted, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CheckKeyValueHeaders, Void>> checkKeyValueWithResponseAsync(String key, String label, String acceptDatetime, String ifMatch, String ifNoneMatch, List<SettingFields> select, Context context) {
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.checkKeyValue(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), acceptDatetime, ifMatch, ifNoneMatch, selectConverted, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> checkKeyValueAsync(String key, String label, String acceptDatetime, String ifMatch, String ifNoneMatch, List<SettingFields> select) {
        return this.checkKeyValueWithResponseAsync(key, label, acceptDatetime, ifMatch, ifNoneMatch, select).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> checkKeyValueAsync(String key, String label, String acceptDatetime, String ifMatch, String ifNoneMatch, List<SettingFields> select, Context context) {
        return this.checkKeyValueWithResponseAsync(key, label, acceptDatetime, ifMatch, ifNoneMatch, select, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<CheckKeyValueHeaders, Void> checkKeyValueWithResponse(String key, String label, String acceptDatetime, String ifMatch, String ifNoneMatch, List<SettingFields> select, Context context) {
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.checkKeyValueSync(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), acceptDatetime, ifMatch, ifNoneMatch, selectConverted, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void checkKeyValue(String key, String label, String acceptDatetime, String ifMatch, String ifNoneMatch, List<SettingFields> select) {
        this.checkKeyValueWithResponse(key, label, acceptDatetime, ifMatch, ifNoneMatch, select, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ConfigurationSnapshot>> getSnapshotsSinglePageAsync(String name, String after, List<SnapshotFields> select, List<ConfigurationSnapshotStatus> status) {
        String accept = "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String statusConverted = status == null ? null : status.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.getSnapshots(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after, selectConverted, statusConverted, "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SnapshotListResult)res.getValue()).getItems(), ((SnapshotListResult)res.getValue()).getNextLink(), (Object)((GetSnapshotsHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ConfigurationSnapshot>> getSnapshotsSinglePageAsync(String name, String after, List<SnapshotFields> select, List<ConfigurationSnapshotStatus> status, Context context) {
        String accept = "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String statusConverted = status == null ? null : status.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.getSnapshots(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after, selectConverted, statusConverted, "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SnapshotListResult)res.getValue()).getItems(), ((SnapshotListResult)res.getValue()).getNextLink(), (Object)((GetSnapshotsHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ConfigurationSnapshot> getSnapshotsAsync(String name, String after, List<SnapshotFields> select, List<ConfigurationSnapshotStatus> status) {
        return new PagedFlux(() -> this.getSnapshotsSinglePageAsync(name, after, select, status), nextLink -> this.getSnapshotsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ConfigurationSnapshot> getSnapshotsAsync(String name, String after, List<SnapshotFields> select, List<ConfigurationSnapshotStatus> status, Context context) {
        return new PagedFlux(() -> this.getSnapshotsSinglePageAsync(name, after, select, status, context), nextLink -> this.getSnapshotsNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<ConfigurationSnapshot> getSnapshotsSinglePage(String name, String after, List<SnapshotFields> select, List<ConfigurationSnapshotStatus> status) {
        String accept = "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String statusConverted = status == null ? null : status.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        ResponseBase<GetSnapshotsHeaders, SnapshotListResult> res = this.service.getSnapshotsSync(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after, selectConverted, statusConverted, "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SnapshotListResult)res.getValue()).getItems(), ((SnapshotListResult)res.getValue()).getNextLink(), (Object)((GetSnapshotsHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<ConfigurationSnapshot> getSnapshotsSinglePage(String name, String after, List<SnapshotFields> select, List<ConfigurationSnapshotStatus> status, Context context) {
        String accept = "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String statusConverted = status == null ? null : status.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        ResponseBase<GetSnapshotsHeaders, SnapshotListResult> res = this.service.getSnapshotsSync(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after, selectConverted, statusConverted, "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SnapshotListResult)res.getValue()).getItems(), ((SnapshotListResult)res.getValue()).getNextLink(), (Object)((GetSnapshotsHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConfigurationSnapshot> getSnapshots(String name, String after, List<SnapshotFields> select, List<ConfigurationSnapshotStatus> status) {
        return new PagedIterable(() -> this.getSnapshotsSinglePage(name, after, select, status, Context.NONE), nextLink -> this.getSnapshotsNextSinglePage((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConfigurationSnapshot> getSnapshots(String name, String after, List<SnapshotFields> select, List<ConfigurationSnapshotStatus> status, Context context) {
        return new PagedIterable(() -> this.getSnapshotsSinglePage(name, after, select, status, context), nextLink -> this.getSnapshotsNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CheckSnapshotsHeaders, Void>> checkSnapshotsWithResponseAsync(String after) {
        return FluxUtil.withContext(context -> this.service.checkSnapshots(this.getEndpoint(), this.getSyncToken(), this.getApiVersion(), after, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CheckSnapshotsHeaders, Void>> checkSnapshotsWithResponseAsync(String after, Context context) {
        return this.service.checkSnapshots(this.getEndpoint(), this.getSyncToken(), this.getApiVersion(), after, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> checkSnapshotsAsync(String after) {
        return this.checkSnapshotsWithResponseAsync(after).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> checkSnapshotsAsync(String after, Context context) {
        return this.checkSnapshotsWithResponseAsync(after, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<CheckSnapshotsHeaders, Void> checkSnapshotsWithResponse(String after, Context context) {
        return this.service.checkSnapshotsSync(this.getEndpoint(), this.getSyncToken(), this.getApiVersion(), after, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void checkSnapshots(String after) {
        this.checkSnapshotsWithResponse(after, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<GetSnapshotHeaders, ConfigurationSnapshot>> getSnapshotWithResponseAsync(String name, String ifMatch, String ifNoneMatch, List<SnapshotFields> select) {
        String accept = "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.getSnapshot(this.getEndpoint(), this.getSyncToken(), this.getApiVersion(), name, ifMatch, ifNoneMatch, selectConverted, "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<GetSnapshotHeaders, ConfigurationSnapshot>> getSnapshotWithResponseAsync(String name, String ifMatch, String ifNoneMatch, List<SnapshotFields> select, Context context) {
        String accept = "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.getSnapshot(this.getEndpoint(), this.getSyncToken(), this.getApiVersion(), name, ifMatch, ifNoneMatch, selectConverted, "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSnapshot> getSnapshotAsync(String name, String ifMatch, String ifNoneMatch, List<SnapshotFields> select) {
        return this.getSnapshotWithResponseAsync(name, ifMatch, ifNoneMatch, select).flatMap(res -> Mono.justOrEmpty((Object)((ConfigurationSnapshot)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSnapshot> getSnapshotAsync(String name, String ifMatch, String ifNoneMatch, List<SnapshotFields> select, Context context) {
        return this.getSnapshotWithResponseAsync(name, ifMatch, ifNoneMatch, select, context).flatMap(res -> Mono.justOrEmpty((Object)((ConfigurationSnapshot)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<GetSnapshotHeaders, ConfigurationSnapshot> getSnapshotWithResponse(String name, String ifMatch, String ifNoneMatch, List<SnapshotFields> select, Context context) {
        String accept = "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.getSnapshotSync(this.getEndpoint(), this.getSyncToken(), this.getApiVersion(), name, ifMatch, ifNoneMatch, selectConverted, "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationSnapshot getSnapshot(String name, String ifMatch, String ifNoneMatch, List<SnapshotFields> select) {
        return (ConfigurationSnapshot)this.getSnapshotWithResponse(name, ifMatch, ifNoneMatch, select, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CreateSnapshotHeaders, ConfigurationSnapshot>> createSnapshotWithResponseAsync(String name, ConfigurationSnapshot entity) {
        String accept = "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json";
        return FluxUtil.withContext(context -> this.service.createSnapshot(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), entity, "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CreateSnapshotHeaders, ConfigurationSnapshot>> createSnapshotWithResponseAsync(String name, ConfigurationSnapshot entity, Context context) {
        String accept = "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json";
        return this.service.createSnapshot(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), entity, "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSnapshot> createSnapshotAsync(String name, ConfigurationSnapshot entity) {
        return this.createSnapshotWithResponseAsync(name, entity).flatMap(res -> Mono.justOrEmpty((Object)((ConfigurationSnapshot)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSnapshot> createSnapshotAsync(String name, ConfigurationSnapshot entity, Context context) {
        return this.createSnapshotWithResponseAsync(name, entity, context).flatMap(res -> Mono.justOrEmpty((Object)((ConfigurationSnapshot)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<CreateSnapshotHeaders, ConfigurationSnapshot> createSnapshotWithResponse(String name, ConfigurationSnapshot entity, Context context) {
        String accept = "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json";
        return this.service.createSnapshotSync(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), entity, "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationSnapshot createSnapshot(String name, ConfigurationSnapshot entity) {
        return (ConfigurationSnapshot)this.createSnapshotWithResponse(name, entity, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<UpdateSnapshotHeaders, ConfigurationSnapshot>> updateSnapshotWithResponseAsync(String name, SnapshotUpdateParameters entity, String ifMatch, String ifNoneMatch) {
        String accept = "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json";
        return FluxUtil.withContext(context -> this.service.updateSnapshot(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), ifMatch, ifNoneMatch, entity, "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<UpdateSnapshotHeaders, ConfigurationSnapshot>> updateSnapshotWithResponseAsync(String name, SnapshotUpdateParameters entity, String ifMatch, String ifNoneMatch, Context context) {
        String accept = "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json";
        return this.service.updateSnapshot(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), ifMatch, ifNoneMatch, entity, "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSnapshot> updateSnapshotAsync(String name, SnapshotUpdateParameters entity, String ifMatch, String ifNoneMatch) {
        return this.updateSnapshotWithResponseAsync(name, entity, ifMatch, ifNoneMatch).flatMap(res -> Mono.justOrEmpty((Object)((ConfigurationSnapshot)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSnapshot> updateSnapshotAsync(String name, SnapshotUpdateParameters entity, String ifMatch, String ifNoneMatch, Context context) {
        return this.updateSnapshotWithResponseAsync(name, entity, ifMatch, ifNoneMatch, context).flatMap(res -> Mono.justOrEmpty((Object)((ConfigurationSnapshot)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<UpdateSnapshotHeaders, ConfigurationSnapshot> updateSnapshotWithResponse(String name, SnapshotUpdateParameters entity, String ifMatch, String ifNoneMatch, Context context) {
        String accept = "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json";
        return this.service.updateSnapshotSync(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), ifMatch, ifNoneMatch, entity, "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationSnapshot updateSnapshot(String name, SnapshotUpdateParameters entity, String ifMatch, String ifNoneMatch) {
        return (ConfigurationSnapshot)this.updateSnapshotWithResponse(name, entity, ifMatch, ifNoneMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CheckSnapshotHeaders, Void>> checkSnapshotWithResponseAsync(String name, String ifMatch, String ifNoneMatch) {
        return FluxUtil.withContext(context -> this.service.checkSnapshot(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), ifMatch, ifNoneMatch, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CheckSnapshotHeaders, Void>> checkSnapshotWithResponseAsync(String name, String ifMatch, String ifNoneMatch, Context context) {
        return this.service.checkSnapshot(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), ifMatch, ifNoneMatch, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> checkSnapshotAsync(String name, String ifMatch, String ifNoneMatch) {
        return this.checkSnapshotWithResponseAsync(name, ifMatch, ifNoneMatch).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> checkSnapshotAsync(String name, String ifMatch, String ifNoneMatch, Context context) {
        return this.checkSnapshotWithResponseAsync(name, ifMatch, ifNoneMatch, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<CheckSnapshotHeaders, Void> checkSnapshotWithResponse(String name, String ifMatch, String ifNoneMatch, Context context) {
        return this.service.checkSnapshotSync(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), ifMatch, ifNoneMatch, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void checkSnapshot(String name, String ifMatch, String ifNoneMatch) {
        this.checkSnapshotWithResponse(name, ifMatch, ifNoneMatch, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<Label>> getLabelsSinglePageAsync(String name, String after, String acceptDatetime, List<LabelFields> select) {
        String accept = "application/vnd.microsoft.appconfig.labelset+json, application/problem+json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.getLabels(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, "application/vnd.microsoft.appconfig.labelset+json, application/problem+json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LabelListResult)res.getValue()).getItems(), ((LabelListResult)res.getValue()).getNextLink(), (Object)((GetLabelsHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<Label>> getLabelsSinglePageAsync(String name, String after, String acceptDatetime, List<LabelFields> select, Context context) {
        String accept = "application/vnd.microsoft.appconfig.labelset+json, application/problem+json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.getLabels(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, "application/vnd.microsoft.appconfig.labelset+json, application/problem+json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LabelListResult)res.getValue()).getItems(), ((LabelListResult)res.getValue()).getNextLink(), (Object)((GetLabelsHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<Label> getLabelsAsync(String name, String after, String acceptDatetime, List<LabelFields> select) {
        return new PagedFlux(() -> this.getLabelsSinglePageAsync(name, after, acceptDatetime, select), nextLink -> this.getLabelsNextSinglePageAsync((String)nextLink, acceptDatetime));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<Label> getLabelsAsync(String name, String after, String acceptDatetime, List<LabelFields> select, Context context) {
        return new PagedFlux(() -> this.getLabelsSinglePageAsync(name, after, acceptDatetime, select, context), nextLink -> this.getLabelsNextSinglePageAsync((String)nextLink, acceptDatetime, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<Label> getLabelsSinglePage(String name, String after, String acceptDatetime, List<LabelFields> select) {
        String accept = "application/vnd.microsoft.appconfig.labelset+json, application/problem+json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        ResponseBase<GetLabelsHeaders, LabelListResult> res = this.service.getLabelsSync(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, "application/vnd.microsoft.appconfig.labelset+json, application/problem+json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LabelListResult)res.getValue()).getItems(), ((LabelListResult)res.getValue()).getNextLink(), (Object)((GetLabelsHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<Label> getLabelsSinglePage(String name, String after, String acceptDatetime, List<LabelFields> select, Context context) {
        String accept = "application/vnd.microsoft.appconfig.labelset+json, application/problem+json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        ResponseBase<GetLabelsHeaders, LabelListResult> res = this.service.getLabelsSync(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, "application/vnd.microsoft.appconfig.labelset+json, application/problem+json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LabelListResult)res.getValue()).getItems(), ((LabelListResult)res.getValue()).getNextLink(), (Object)((GetLabelsHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<Label> getLabels(String name, String after, String acceptDatetime, List<LabelFields> select) {
        return new PagedIterable(() -> this.getLabelsSinglePage(name, after, acceptDatetime, select, Context.NONE), nextLink -> this.getLabelsNextSinglePage((String)nextLink, acceptDatetime));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<Label> getLabels(String name, String after, String acceptDatetime, List<LabelFields> select, Context context) {
        return new PagedIterable(() -> this.getLabelsSinglePage(name, after, acceptDatetime, select, context), nextLink -> this.getLabelsNextSinglePage((String)nextLink, acceptDatetime, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CheckLabelsHeaders, Void>> checkLabelsWithResponseAsync(String name, String after, String acceptDatetime, List<LabelFields> select) {
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.checkLabels(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CheckLabelsHeaders, Void>> checkLabelsWithResponseAsync(String name, String after, String acceptDatetime, List<LabelFields> select, Context context) {
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.checkLabels(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> checkLabelsAsync(String name, String after, String acceptDatetime, List<LabelFields> select) {
        return this.checkLabelsWithResponseAsync(name, after, acceptDatetime, select).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> checkLabelsAsync(String name, String after, String acceptDatetime, List<LabelFields> select, Context context) {
        return this.checkLabelsWithResponseAsync(name, after, acceptDatetime, select, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<CheckLabelsHeaders, Void> checkLabelsWithResponse(String name, String after, String acceptDatetime, List<LabelFields> select, Context context) {
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.checkLabelsSync(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void checkLabels(String name, String after, String acceptDatetime, List<LabelFields> select) {
        this.checkLabelsWithResponse(name, after, acceptDatetime, select, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PutLockHeaders, KeyValue>> putLockWithResponseAsync(String key, String label, String ifMatch, String ifNoneMatch) {
        String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return FluxUtil.withContext(context -> this.service.putLock(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), ifMatch, ifNoneMatch, "application/vnd.microsoft.appconfig.kv+json, application/problem+json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PutLockHeaders, KeyValue>> putLockWithResponseAsync(String key, String label, String ifMatch, String ifNoneMatch, Context context) {
        String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return this.service.putLock(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), ifMatch, ifNoneMatch, "application/vnd.microsoft.appconfig.kv+json, application/problem+json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyValue> putLockAsync(String key, String label, String ifMatch, String ifNoneMatch) {
        return this.putLockWithResponseAsync(key, label, ifMatch, ifNoneMatch).flatMap(res -> Mono.justOrEmpty((Object)((KeyValue)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyValue> putLockAsync(String key, String label, String ifMatch, String ifNoneMatch, Context context) {
        return this.putLockWithResponseAsync(key, label, ifMatch, ifNoneMatch, context).flatMap(res -> Mono.justOrEmpty((Object)((KeyValue)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<PutLockHeaders, KeyValue> putLockWithResponse(String key, String label, String ifMatch, String ifNoneMatch, Context context) {
        String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return this.service.putLockSync(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), ifMatch, ifNoneMatch, "application/vnd.microsoft.appconfig.kv+json, application/problem+json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyValue putLock(String key, String label, String ifMatch, String ifNoneMatch) {
        return (KeyValue)this.putLockWithResponse(key, label, ifMatch, ifNoneMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DeleteLockHeaders, KeyValue>> deleteLockWithResponseAsync(String key, String label, String ifMatch, String ifNoneMatch) {
        String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return FluxUtil.withContext(context -> this.service.deleteLock(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), ifMatch, ifNoneMatch, "application/vnd.microsoft.appconfig.kv+json, application/problem+json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DeleteLockHeaders, KeyValue>> deleteLockWithResponseAsync(String key, String label, String ifMatch, String ifNoneMatch, Context context) {
        String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return this.service.deleteLock(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), ifMatch, ifNoneMatch, "application/vnd.microsoft.appconfig.kv+json, application/problem+json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyValue> deleteLockAsync(String key, String label, String ifMatch, String ifNoneMatch) {
        return this.deleteLockWithResponseAsync(key, label, ifMatch, ifNoneMatch).flatMap(res -> Mono.justOrEmpty((Object)((KeyValue)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyValue> deleteLockAsync(String key, String label, String ifMatch, String ifNoneMatch, Context context) {
        return this.deleteLockWithResponseAsync(key, label, ifMatch, ifNoneMatch, context).flatMap(res -> Mono.justOrEmpty((Object)((KeyValue)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<DeleteLockHeaders, KeyValue> deleteLockWithResponse(String key, String label, String ifMatch, String ifNoneMatch, Context context) {
        String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return this.service.deleteLockSync(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), ifMatch, ifNoneMatch, "application/vnd.microsoft.appconfig.kv+json, application/problem+json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyValue deleteLock(String key, String label, String ifMatch, String ifNoneMatch) {
        return (KeyValue)this.deleteLockWithResponse(key, label, ifMatch, ifNoneMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<KeyValue>> getRevisionsSinglePageAsync(String key, String label, String after, String acceptDatetime, List<SettingFields> select) {
        String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.getRevisions(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, "application/vnd.microsoft.appconfig.kvset+json, application/problem+json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyValueListResult)res.getValue()).getItems(), ((KeyValueListResult)res.getValue()).getNextLink(), (Object)((GetRevisionsHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<KeyValue>> getRevisionsSinglePageAsync(String key, String label, String after, String acceptDatetime, List<SettingFields> select, Context context) {
        String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.getRevisions(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, "application/vnd.microsoft.appconfig.kvset+json, application/problem+json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyValueListResult)res.getValue()).getItems(), ((KeyValueListResult)res.getValue()).getNextLink(), (Object)((GetRevisionsHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KeyValue> getRevisionsAsync(String key, String label, String after, String acceptDatetime, List<SettingFields> select) {
        return new PagedFlux(() -> this.getRevisionsSinglePageAsync(key, label, after, acceptDatetime, select), nextLink -> this.getRevisionsNextSinglePageAsync((String)nextLink, acceptDatetime));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KeyValue> getRevisionsAsync(String key, String label, String after, String acceptDatetime, List<SettingFields> select, Context context) {
        return new PagedFlux(() -> this.getRevisionsSinglePageAsync(key, label, after, acceptDatetime, select, context), nextLink -> this.getRevisionsNextSinglePageAsync((String)nextLink, acceptDatetime, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<KeyValue> getRevisionsSinglePage(String key, String label, String after, String acceptDatetime, List<SettingFields> select) {
        String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        ResponseBase<GetRevisionsHeaders, KeyValueListResult> res = this.service.getRevisionsSync(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, "application/vnd.microsoft.appconfig.kvset+json, application/problem+json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyValueListResult)res.getValue()).getItems(), ((KeyValueListResult)res.getValue()).getNextLink(), (Object)((GetRevisionsHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<KeyValue> getRevisionsSinglePage(String key, String label, String after, String acceptDatetime, List<SettingFields> select, Context context) {
        String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        ResponseBase<GetRevisionsHeaders, KeyValueListResult> res = this.service.getRevisionsSync(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, "application/vnd.microsoft.appconfig.kvset+json, application/problem+json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyValueListResult)res.getValue()).getItems(), ((KeyValueListResult)res.getValue()).getNextLink(), (Object)((GetRevisionsHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyValue> getRevisions(String key, String label, String after, String acceptDatetime, List<SettingFields> select) {
        return new PagedIterable(() -> this.getRevisionsSinglePage(key, label, after, acceptDatetime, select, Context.NONE), nextLink -> this.getRevisionsNextSinglePage((String)nextLink, acceptDatetime));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyValue> getRevisions(String key, String label, String after, String acceptDatetime, List<SettingFields> select, Context context) {
        return new PagedIterable(() -> this.getRevisionsSinglePage(key, label, after, acceptDatetime, select, context), nextLink -> this.getRevisionsNextSinglePage((String)nextLink, acceptDatetime, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CheckRevisionsHeaders, Void>> checkRevisionsWithResponseAsync(String key, String label, String after, String acceptDatetime, List<SettingFields> select) {
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.checkRevisions(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CheckRevisionsHeaders, Void>> checkRevisionsWithResponseAsync(String key, String label, String after, String acceptDatetime, List<SettingFields> select, Context context) {
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.checkRevisions(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> checkRevisionsAsync(String key, String label, String after, String acceptDatetime, List<SettingFields> select) {
        return this.checkRevisionsWithResponseAsync(key, label, after, acceptDatetime, select).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> checkRevisionsAsync(String key, String label, String after, String acceptDatetime, List<SettingFields> select, Context context) {
        return this.checkRevisionsWithResponseAsync(key, label, after, acceptDatetime, select, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<CheckRevisionsHeaders, Void> checkRevisionsWithResponse(String key, String label, String after, String acceptDatetime, List<SettingFields> select, Context context) {
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.checkRevisionsSync(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void checkRevisions(String key, String label, String after, String acceptDatetime, List<SettingFields> select) {
        this.checkRevisionsWithResponse(key, label, after, acceptDatetime, select, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<OperationDetails>> getOperationDetailsWithResponseAsync(String snapshot) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getOperationDetails(this.getEndpoint(), this.getApiVersion(), snapshot, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<OperationDetails>> getOperationDetailsWithResponseAsync(String snapshot, Context context) {
        String accept = "application/json";
        return this.service.getOperationDetails(this.getEndpoint(), this.getApiVersion(), snapshot, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OperationDetails> getOperationDetailsAsync(String snapshot) {
        return this.getOperationDetailsWithResponseAsync(snapshot).flatMap(res -> Mono.justOrEmpty((Object)((OperationDetails)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OperationDetails> getOperationDetailsAsync(String snapshot, Context context) {
        return this.getOperationDetailsWithResponseAsync(snapshot, context).flatMap(res -> Mono.justOrEmpty((Object)((OperationDetails)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<OperationDetails> getOperationDetailsWithResponse(String snapshot, Context context) {
        String accept = "application/json";
        return this.service.getOperationDetailsSync(this.getEndpoint(), this.getApiVersion(), snapshot, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationDetails getOperationDetails(String snapshot) {
        return (OperationDetails)this.getOperationDetailsWithResponse(snapshot, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<Key>> getKeysNextSinglePageAsync(String nextLink, String acceptDatetime) {
        String accept = "application/vnd.microsoft.appconfig.keyset+json, application/problem+json";
        return FluxUtil.withContext(context -> this.service.getKeysNext(nextLink, this.getEndpoint(), this.getSyncToken(), acceptDatetime, "application/vnd.microsoft.appconfig.keyset+json, application/problem+json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyListResult)res.getValue()).getItems(), ((KeyListResult)res.getValue()).getNextLink(), (Object)((GetKeysNextHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<Key>> getKeysNextSinglePageAsync(String nextLink, String acceptDatetime, Context context) {
        String accept = "application/vnd.microsoft.appconfig.keyset+json, application/problem+json";
        return this.service.getKeysNext(nextLink, this.getEndpoint(), this.getSyncToken(), acceptDatetime, "application/vnd.microsoft.appconfig.keyset+json, application/problem+json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyListResult)res.getValue()).getItems(), ((KeyListResult)res.getValue()).getNextLink(), (Object)((GetKeysNextHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<Key> getKeysNextSinglePage(String nextLink, String acceptDatetime) {
        String accept = "application/vnd.microsoft.appconfig.keyset+json, application/problem+json";
        ResponseBase<GetKeysNextHeaders, KeyListResult> res = this.service.getKeysNextSync(nextLink, this.getEndpoint(), this.getSyncToken(), acceptDatetime, "application/vnd.microsoft.appconfig.keyset+json, application/problem+json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyListResult)res.getValue()).getItems(), ((KeyListResult)res.getValue()).getNextLink(), (Object)((GetKeysNextHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<Key> getKeysNextSinglePage(String nextLink, String acceptDatetime, Context context) {
        String accept = "application/vnd.microsoft.appconfig.keyset+json, application/problem+json";
        ResponseBase<GetKeysNextHeaders, KeyListResult> res = this.service.getKeysNextSync(nextLink, this.getEndpoint(), this.getSyncToken(), acceptDatetime, "application/vnd.microsoft.appconfig.keyset+json, application/problem+json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyListResult)res.getValue()).getItems(), ((KeyListResult)res.getValue()).getNextLink(), (Object)((GetKeysNextHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<KeyValue>> getKeyValuesNextSinglePageAsync(String nextLink, String acceptDatetime, String ifMatch, String ifNoneMatch) {
        String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        return FluxUtil.withContext(context -> this.service.getKeyValuesNext(nextLink, this.getEndpoint(), this.getSyncToken(), acceptDatetime, ifMatch, ifNoneMatch, "application/vnd.microsoft.appconfig.kvset+json, application/problem+json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyValueListResult)res.getValue()).getItems(), ((KeyValueListResult)res.getValue()).getNextLink(), (Object)((GetKeyValuesNextHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<KeyValue>> getKeyValuesNextSinglePageAsync(String nextLink, String acceptDatetime, String ifMatch, String ifNoneMatch, Context context) {
        String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        return this.service.getKeyValuesNext(nextLink, this.getEndpoint(), this.getSyncToken(), acceptDatetime, ifMatch, ifNoneMatch, "application/vnd.microsoft.appconfig.kvset+json, application/problem+json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyValueListResult)res.getValue()).getItems(), ((KeyValueListResult)res.getValue()).getNextLink(), (Object)((GetKeyValuesNextHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<KeyValue> getKeyValuesNextSinglePage(String nextLink, String acceptDatetime, String ifMatch, String ifNoneMatch) {
        String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        ResponseBase<GetKeyValuesNextHeaders, KeyValueListResult> res = this.service.getKeyValuesNextSync(nextLink, this.getEndpoint(), this.getSyncToken(), acceptDatetime, ifMatch, ifNoneMatch, "application/vnd.microsoft.appconfig.kvset+json, application/problem+json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyValueListResult)res.getValue()).getItems(), ((KeyValueListResult)res.getValue()).getNextLink(), (Object)((GetKeyValuesNextHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<KeyValue> getKeyValuesNextSinglePage(String nextLink, String acceptDatetime, String ifMatch, String ifNoneMatch, Context context) {
        String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        ResponseBase<GetKeyValuesNextHeaders, KeyValueListResult> res = this.service.getKeyValuesNextSync(nextLink, this.getEndpoint(), this.getSyncToken(), acceptDatetime, ifMatch, ifNoneMatch, "application/vnd.microsoft.appconfig.kvset+json, application/problem+json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyValueListResult)res.getValue()).getItems(), ((KeyValueListResult)res.getValue()).getNextLink(), (Object)((GetKeyValuesNextHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ConfigurationSnapshot>> getSnapshotsNextSinglePageAsync(String nextLink) {
        String accept = "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json";
        return FluxUtil.withContext(context -> this.service.getSnapshotsNext(nextLink, this.getEndpoint(), this.getSyncToken(), "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SnapshotListResult)res.getValue()).getItems(), ((SnapshotListResult)res.getValue()).getNextLink(), (Object)((GetSnapshotsNextHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ConfigurationSnapshot>> getSnapshotsNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json";
        return this.service.getSnapshotsNext(nextLink, this.getEndpoint(), this.getSyncToken(), "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SnapshotListResult)res.getValue()).getItems(), ((SnapshotListResult)res.getValue()).getNextLink(), (Object)((GetSnapshotsNextHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<ConfigurationSnapshot> getSnapshotsNextSinglePage(String nextLink) {
        String accept = "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json";
        ResponseBase<GetSnapshotsNextHeaders, SnapshotListResult> res = this.service.getSnapshotsNextSync(nextLink, this.getEndpoint(), this.getSyncToken(), "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SnapshotListResult)res.getValue()).getItems(), ((SnapshotListResult)res.getValue()).getNextLink(), (Object)((GetSnapshotsNextHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<ConfigurationSnapshot> getSnapshotsNextSinglePage(String nextLink, Context context) {
        String accept = "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json";
        ResponseBase<GetSnapshotsNextHeaders, SnapshotListResult> res = this.service.getSnapshotsNextSync(nextLink, this.getEndpoint(), this.getSyncToken(), "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SnapshotListResult)res.getValue()).getItems(), ((SnapshotListResult)res.getValue()).getNextLink(), (Object)((GetSnapshotsNextHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<Label>> getLabelsNextSinglePageAsync(String nextLink, String acceptDatetime) {
        String accept = "application/vnd.microsoft.appconfig.labelset+json, application/problem+json";
        return FluxUtil.withContext(context -> this.service.getLabelsNext(nextLink, this.getEndpoint(), this.getSyncToken(), acceptDatetime, "application/vnd.microsoft.appconfig.labelset+json, application/problem+json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LabelListResult)res.getValue()).getItems(), ((LabelListResult)res.getValue()).getNextLink(), (Object)((GetLabelsNextHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<Label>> getLabelsNextSinglePageAsync(String nextLink, String acceptDatetime, Context context) {
        String accept = "application/vnd.microsoft.appconfig.labelset+json, application/problem+json";
        return this.service.getLabelsNext(nextLink, this.getEndpoint(), this.getSyncToken(), acceptDatetime, "application/vnd.microsoft.appconfig.labelset+json, application/problem+json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LabelListResult)res.getValue()).getItems(), ((LabelListResult)res.getValue()).getNextLink(), (Object)((GetLabelsNextHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<Label> getLabelsNextSinglePage(String nextLink, String acceptDatetime) {
        String accept = "application/vnd.microsoft.appconfig.labelset+json, application/problem+json";
        ResponseBase<GetLabelsNextHeaders, LabelListResult> res = this.service.getLabelsNextSync(nextLink, this.getEndpoint(), this.getSyncToken(), acceptDatetime, "application/vnd.microsoft.appconfig.labelset+json, application/problem+json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LabelListResult)res.getValue()).getItems(), ((LabelListResult)res.getValue()).getNextLink(), (Object)((GetLabelsNextHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<Label> getLabelsNextSinglePage(String nextLink, String acceptDatetime, Context context) {
        String accept = "application/vnd.microsoft.appconfig.labelset+json, application/problem+json";
        ResponseBase<GetLabelsNextHeaders, LabelListResult> res = this.service.getLabelsNextSync(nextLink, this.getEndpoint(), this.getSyncToken(), acceptDatetime, "application/vnd.microsoft.appconfig.labelset+json, application/problem+json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LabelListResult)res.getValue()).getItems(), ((LabelListResult)res.getValue()).getNextLink(), (Object)((GetLabelsNextHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<KeyValue>> getRevisionsNextSinglePageAsync(String nextLink, String acceptDatetime) {
        String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        return FluxUtil.withContext(context -> this.service.getRevisionsNext(nextLink, this.getEndpoint(), this.getSyncToken(), acceptDatetime, "application/vnd.microsoft.appconfig.kvset+json, application/problem+json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyValueListResult)res.getValue()).getItems(), ((KeyValueListResult)res.getValue()).getNextLink(), (Object)((GetRevisionsNextHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<KeyValue>> getRevisionsNextSinglePageAsync(String nextLink, String acceptDatetime, Context context) {
        String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        return this.service.getRevisionsNext(nextLink, this.getEndpoint(), this.getSyncToken(), acceptDatetime, "application/vnd.microsoft.appconfig.kvset+json, application/problem+json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyValueListResult)res.getValue()).getItems(), ((KeyValueListResult)res.getValue()).getNextLink(), (Object)((GetRevisionsNextHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<KeyValue> getRevisionsNextSinglePage(String nextLink, String acceptDatetime) {
        String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        ResponseBase<GetRevisionsNextHeaders, KeyValueListResult> res = this.service.getRevisionsNextSync(nextLink, this.getEndpoint(), this.getSyncToken(), acceptDatetime, "application/vnd.microsoft.appconfig.kvset+json, application/problem+json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyValueListResult)res.getValue()).getItems(), ((KeyValueListResult)res.getValue()).getNextLink(), (Object)((GetRevisionsNextHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<KeyValue> getRevisionsNextSinglePage(String nextLink, String acceptDatetime, Context context) {
        String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        ResponseBase<GetRevisionsNextHeaders, KeyValueListResult> res = this.service.getRevisionsNextSync(nextLink, this.getEndpoint(), this.getSyncToken(), acceptDatetime, "application/vnd.microsoft.appconfig.kvset+json, application/problem+json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyValueListResult)res.getValue()).getItems(), ((KeyValueListResult)res.getValue()).getNextLink(), (Object)((GetRevisionsNextHeaders)res.getDeserializedHeaders()));
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="AzureAppConfiguratio")
    public static interface AzureAppConfigurationService {
        @Get(value="/keys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<GetKeysHeaders, KeyListResult>> getKeys(@HostParam(value="endpoint") String var1, @QueryParam(value="name") String var2, @HeaderParam(value="Sync-Token") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="After") String var5, @HeaderParam(value="Accept-Datetime") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/keys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<GetKeysHeaders, KeyListResult> getKeysSync(@HostParam(value="endpoint") String var1, @QueryParam(value="name") String var2, @HeaderParam(value="Sync-Token") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="After") String var5, @HeaderParam(value="Accept-Datetime") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Head(value="/keys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<CheckKeysHeaders, Void>> checkKeys(@HostParam(value="endpoint") String var1, @QueryParam(value="name") String var2, @HeaderParam(value="Sync-Token") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="After") String var5, @HeaderParam(value="Accept-Datetime") String var6, Context var7);

        @Head(value="/keys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<CheckKeysHeaders, Void> checkKeysSync(@HostParam(value="endpoint") String var1, @QueryParam(value="name") String var2, @HeaderParam(value="Sync-Token") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="After") String var5, @HeaderParam(value="Accept-Datetime") String var6, Context var7);

        @Get(value="/kv")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<GetKeyValuesHeaders, KeyValueListResult>> getKeyValues(@HostParam(value="endpoint") String var1, @QueryParam(value="key") String var2, @QueryParam(value="label") String var3, @HeaderParam(value="Sync-Token") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="After") String var6, @HeaderParam(value="Accept-Datetime") String var7, @QueryParam(value="$Select") String var8, @QueryParam(value="snapshot") String var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Get(value="/kv")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<GetKeyValuesHeaders, KeyValueListResult> getKeyValuesSync(@HostParam(value="endpoint") String var1, @QueryParam(value="key") String var2, @QueryParam(value="label") String var3, @HeaderParam(value="Sync-Token") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="After") String var6, @HeaderParam(value="Accept-Datetime") String var7, @QueryParam(value="$Select") String var8, @QueryParam(value="snapshot") String var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Head(value="/kv")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<CheckKeyValuesHeaders, Void>> checkKeyValues(@HostParam(value="endpoint") String var1, @QueryParam(value="key") String var2, @QueryParam(value="label") String var3, @HeaderParam(value="Sync-Token") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="After") String var6, @HeaderParam(value="Accept-Datetime") String var7, @QueryParam(value="$Select") String var8, @QueryParam(value="snapshot") String var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, Context var12);

        @Head(value="/kv")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<CheckKeyValuesHeaders, Void> checkKeyValuesSync(@HostParam(value="endpoint") String var1, @QueryParam(value="key") String var2, @QueryParam(value="label") String var3, @HeaderParam(value="Sync-Token") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="After") String var6, @HeaderParam(value="Accept-Datetime") String var7, @QueryParam(value="$Select") String var8, @QueryParam(value="snapshot") String var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, Context var12);

        @Get(value="/kv/{key}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<GetKeyValueHeaders, KeyValue>> getKeyValue(@HostParam(value="endpoint") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @HeaderParam(value="Sync-Token") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept-Datetime") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @QueryParam(value="$Select") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/kv/{key}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<GetKeyValueHeaders, KeyValue> getKeyValueSync(@HostParam(value="endpoint") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @HeaderParam(value="Sync-Token") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept-Datetime") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @QueryParam(value="$Select") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/kv/{key}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<PutKeyValueHeaders, KeyValue>> putKeyValue(@HostParam(value="endpoint") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @HeaderParam(value="Sync-Token") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, @BodyParam(value="application/json") KeyValue var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Put(value="/kv/{key}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<PutKeyValueHeaders, KeyValue> putKeyValueSync(@HostParam(value="endpoint") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @HeaderParam(value="Sync-Token") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, @BodyParam(value="application/json") KeyValue var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Delete(value="/kv/{key}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<DeleteKeyValueHeaders, KeyValue>> deleteKeyValue(@HostParam(value="endpoint") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @HeaderParam(value="Sync-Token") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Delete(value="/kv/{key}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<DeleteKeyValueHeaders, KeyValue> deleteKeyValueSync(@HostParam(value="endpoint") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @HeaderParam(value="Sync-Token") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Head(value="/kv/{key}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<CheckKeyValueHeaders, Void>> checkKeyValue(@HostParam(value="endpoint") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @HeaderParam(value="Sync-Token") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept-Datetime") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @QueryParam(value="$Select") String var9, Context var10);

        @Head(value="/kv/{key}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<CheckKeyValueHeaders, Void> checkKeyValueSync(@HostParam(value="endpoint") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @HeaderParam(value="Sync-Token") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept-Datetime") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @QueryParam(value="$Select") String var9, Context var10);

        @Get(value="/snapshots")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<GetSnapshotsHeaders, SnapshotListResult>> getSnapshots(@HostParam(value="endpoint") String var1, @QueryParam(value="name") String var2, @HeaderParam(value="Sync-Token") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="After") String var5, @QueryParam(value="$Select") String var6, @QueryParam(value="status") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/snapshots")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<GetSnapshotsHeaders, SnapshotListResult> getSnapshotsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="name") String var2, @HeaderParam(value="Sync-Token") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="After") String var5, @QueryParam(value="$Select") String var6, @QueryParam(value="status") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Head(value="/snapshots")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<CheckSnapshotsHeaders, Void>> checkSnapshots(@HostParam(value="endpoint") String var1, @HeaderParam(value="Sync-Token") String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="After") String var4, Context var5);

        @Head(value="/snapshots")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<CheckSnapshotsHeaders, Void> checkSnapshotsSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="Sync-Token") String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="After") String var4, Context var5);

        @Get(value="/snapshots/{name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<GetSnapshotHeaders, ConfigurationSnapshot>> getSnapshot(@HostParam(value="endpoint") String var1, @HeaderParam(value="Sync-Token") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="name") String var4, @HeaderParam(value="If-Match") String var5, @HeaderParam(value="If-None-Match") String var6, @QueryParam(value="$Select") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/snapshots/{name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<GetSnapshotHeaders, ConfigurationSnapshot> getSnapshotSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="Sync-Token") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="name") String var4, @HeaderParam(value="If-Match") String var5, @HeaderParam(value="If-None-Match") String var6, @QueryParam(value="$Select") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/snapshots/{name}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<CreateSnapshotHeaders, ConfigurationSnapshot>> createSnapshot(@HostParam(value="endpoint") String var1, @PathParam(value="name") String var2, @HeaderParam(value="Sync-Token") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") ConfigurationSnapshot var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Put(value="/snapshots/{name}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<CreateSnapshotHeaders, ConfigurationSnapshot> createSnapshotSync(@HostParam(value="endpoint") String var1, @PathParam(value="name") String var2, @HeaderParam(value="Sync-Token") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") ConfigurationSnapshot var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Patch(value="/snapshots/{name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<UpdateSnapshotHeaders, ConfigurationSnapshot>> updateSnapshot(@HostParam(value="endpoint") String var1, @PathParam(value="name") String var2, @HeaderParam(value="Sync-Token") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="If-Match") String var5, @HeaderParam(value="If-None-Match") String var6, @BodyParam(value="application/json") SnapshotUpdateParameters var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Patch(value="/snapshots/{name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<UpdateSnapshotHeaders, ConfigurationSnapshot> updateSnapshotSync(@HostParam(value="endpoint") String var1, @PathParam(value="name") String var2, @HeaderParam(value="Sync-Token") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="If-Match") String var5, @HeaderParam(value="If-None-Match") String var6, @BodyParam(value="application/json") SnapshotUpdateParameters var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Head(value="/snapshots/{name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<CheckSnapshotHeaders, Void>> checkSnapshot(@HostParam(value="endpoint") String var1, @PathParam(value="name") String var2, @HeaderParam(value="Sync-Token") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="If-Match") String var5, @HeaderParam(value="If-None-Match") String var6, Context var7);

        @Head(value="/snapshots/{name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<CheckSnapshotHeaders, Void> checkSnapshotSync(@HostParam(value="endpoint") String var1, @PathParam(value="name") String var2, @HeaderParam(value="Sync-Token") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="If-Match") String var5, @HeaderParam(value="If-None-Match") String var6, Context var7);

        @Get(value="/labels")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<GetLabelsHeaders, LabelListResult>> getLabels(@HostParam(value="endpoint") String var1, @QueryParam(value="name") String var2, @HeaderParam(value="Sync-Token") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="After") String var5, @HeaderParam(value="Accept-Datetime") String var6, @QueryParam(value="$Select") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/labels")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<GetLabelsHeaders, LabelListResult> getLabelsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="name") String var2, @HeaderParam(value="Sync-Token") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="After") String var5, @HeaderParam(value="Accept-Datetime") String var6, @QueryParam(value="$Select") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Head(value="/labels")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<CheckLabelsHeaders, Void>> checkLabels(@HostParam(value="endpoint") String var1, @QueryParam(value="name") String var2, @HeaderParam(value="Sync-Token") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="After") String var5, @HeaderParam(value="Accept-Datetime") String var6, @QueryParam(value="$Select") String var7, Context var8);

        @Head(value="/labels")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<CheckLabelsHeaders, Void> checkLabelsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="name") String var2, @HeaderParam(value="Sync-Token") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="After") String var5, @HeaderParam(value="Accept-Datetime") String var6, @QueryParam(value="$Select") String var7, Context var8);

        @Put(value="/locks/{key}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<PutLockHeaders, KeyValue>> putLock(@HostParam(value="endpoint") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @HeaderParam(value="Sync-Token") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/locks/{key}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<PutLockHeaders, KeyValue> putLockSync(@HostParam(value="endpoint") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @HeaderParam(value="Sync-Token") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Delete(value="/locks/{key}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<DeleteLockHeaders, KeyValue>> deleteLock(@HostParam(value="endpoint") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @HeaderParam(value="Sync-Token") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Delete(value="/locks/{key}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<DeleteLockHeaders, KeyValue> deleteLockSync(@HostParam(value="endpoint") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @HeaderParam(value="Sync-Token") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/revisions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<GetRevisionsHeaders, KeyValueListResult>> getRevisions(@HostParam(value="endpoint") String var1, @QueryParam(value="key") String var2, @QueryParam(value="label") String var3, @HeaderParam(value="Sync-Token") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="After") String var6, @HeaderParam(value="Accept-Datetime") String var7, @QueryParam(value="$Select") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/revisions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<GetRevisionsHeaders, KeyValueListResult> getRevisionsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="key") String var2, @QueryParam(value="label") String var3, @HeaderParam(value="Sync-Token") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="After") String var6, @HeaderParam(value="Accept-Datetime") String var7, @QueryParam(value="$Select") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Head(value="/revisions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<CheckRevisionsHeaders, Void>> checkRevisions(@HostParam(value="endpoint") String var1, @QueryParam(value="key") String var2, @QueryParam(value="label") String var3, @HeaderParam(value="Sync-Token") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="After") String var6, @HeaderParam(value="Accept-Datetime") String var7, @QueryParam(value="$Select") String var8, Context var9);

        @Head(value="/revisions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<CheckRevisionsHeaders, Void> checkRevisionsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="key") String var2, @QueryParam(value="label") String var3, @HeaderParam(value="Sync-Token") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="After") String var6, @HeaderParam(value="Accept-Datetime") String var7, @QueryParam(value="$Select") String var8, Context var9);

        @Get(value="/operations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<OperationDetails>> getOperationDetails(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @QueryParam(value="snapshot") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/operations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Response<OperationDetails> getOperationDetailsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @QueryParam(value="snapshot") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<GetKeysNextHeaders, KeyListResult>> getKeysNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Sync-Token") String var3, @HeaderParam(value="Accept-Datetime") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<GetKeysNextHeaders, KeyListResult> getKeysNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Sync-Token") String var3, @HeaderParam(value="Accept-Datetime") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<GetKeyValuesNextHeaders, KeyValueListResult>> getKeyValuesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Sync-Token") String var3, @HeaderParam(value="Accept-Datetime") String var4, @HeaderParam(value="If-Match") String var5, @HeaderParam(value="If-None-Match") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<GetKeyValuesNextHeaders, KeyValueListResult> getKeyValuesNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Sync-Token") String var3, @HeaderParam(value="Accept-Datetime") String var4, @HeaderParam(value="If-Match") String var5, @HeaderParam(value="If-None-Match") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<GetSnapshotsNextHeaders, SnapshotListResult>> getSnapshotsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Sync-Token") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<GetSnapshotsNextHeaders, SnapshotListResult> getSnapshotsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Sync-Token") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<GetLabelsNextHeaders, LabelListResult>> getLabelsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Sync-Token") String var3, @HeaderParam(value="Accept-Datetime") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<GetLabelsNextHeaders, LabelListResult> getLabelsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Sync-Token") String var3, @HeaderParam(value="Accept-Datetime") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<GetRevisionsNextHeaders, KeyValueListResult>> getRevisionsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Sync-Token") String var3, @HeaderParam(value="Accept-Datetime") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<GetRevisionsNextHeaders, KeyValueListResult> getRevisionsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Sync-Token") String var3, @HeaderParam(value="Accept-Datetime") String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

