/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.data.appconfiguration.implementation.ConfigurationSettingJsonDeserializer;
import com.azure.data.appconfiguration.implementation.ConfigurationSettingJsonSerializer;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import java.io.IOException;
import java.util.Map;

public final class SecretReferenceConfigurationSetting
extends ConfigurationSetting {
    private static final ClientLogger LOGGER = new ClientLogger(SecretReferenceConfigurationSetting.class);
    private String secretId;
    private static final String SECRET_REFERENCE_CONTENT_TYPE = "application/vnd.microsoft.appconfig.keyvaultref+json;charset=utf-8";

    public SecretReferenceConfigurationSetting(String key, String secretId) {
        this.secretId = secretId;
        super.setKey(key);
        super.setValue("{\"uri\":\"" + secretId + "\"}");
        super.setContentType(SECRET_REFERENCE_CONTENT_TYPE);
    }

    public String getSecretId() {
        return this.secretId;
    }

    public SecretReferenceConfigurationSetting setSecretId(String secretId) {
        this.secretId = secretId;
        this.updateSettingValue();
        return this;
    }

    @Override
    public SecretReferenceConfigurationSetting setKey(String key) {
        super.setKey(key);
        return this;
    }

    @Override
    public SecretReferenceConfigurationSetting setValue(String value) {
        super.setValue(value);
        SecretReferenceConfigurationSetting updatedSetting = ConfigurationSettingJsonDeserializer.readSecretReferenceConfigurationSettingValue(super.getKey(), value);
        this.secretId = updatedSetting.getSecretId();
        return this;
    }

    @Override
    public SecretReferenceConfigurationSetting setLabel(String label) {
        super.setLabel(label);
        return this;
    }

    @Override
    public SecretReferenceConfigurationSetting setContentType(String contentType) {
        super.setContentType(contentType);
        return this;
    }

    @Override
    public SecretReferenceConfigurationSetting setETag(String etag) {
        super.setETag(etag);
        return this;
    }

    @Override
    public SecretReferenceConfigurationSetting setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    private void updateSettingValue() {
        try {
            super.setValue(ConfigurationSettingJsonSerializer.writeSecretReferenceConfigurationSetting(this));
        }
        catch (IOException exception) {
            LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Can't parse Secret Reference configuration setting value.", exception));
        }
    }
}

