/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.data.appconfiguration.ConfigurationClientBuilder;
import com.azure.data.appconfiguration.implementation.ConfigurationClientImpl;
import com.azure.data.appconfiguration.implementation.SyncTokenPolicy;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import java.time.OffsetDateTime;
import java.util.Objects;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ConfigurationClientBuilder.class, isAsync=true, serviceInterfaces={ConfigurationClientImpl.ConfigurationService.class})
public final class ConfigurationAsyncClient {
    private final ClientLogger logger = new ClientLogger(ConfigurationAsyncClient.class);
    private final ConfigurationClientImpl serviceClient;
    private final SyncTokenPolicy syncTokenPolicy;

    ConfigurationAsyncClient(ConfigurationClientImpl serviceClient, SyncTokenPolicy syncTokenPolicy) {
        this.serviceClient = serviceClient;
        this.syncTokenPolicy = syncTokenPolicy;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> addConfigurationSetting(String key, String label, String value) {
        try {
            return FluxUtil.withContext(context -> this.serviceClient.addConfigurationSettingWithResponseAsync(new ConfigurationSetting().setKey(key).setLabel(label).setValue(value), (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> addConfigurationSetting(ConfigurationSetting setting) {
        return this.addConfigurationSettingWithResponse(setting).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConfigurationSetting>> addConfigurationSettingWithResponse(ConfigurationSetting setting) {
        try {
            return FluxUtil.withContext(context -> this.serviceClient.addConfigurationSettingWithResponseAsync(setting, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> setConfigurationSetting(String key, String label, String value) {
        try {
            return FluxUtil.withContext(context -> this.serviceClient.setConfigurationSettingWithResponseAsync(new ConfigurationSetting().setKey(key).setLabel(label).setValue(value), false, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> setConfigurationSetting(ConfigurationSetting setting) {
        return this.setConfigurationSettingWithResponse(setting, false).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConfigurationSetting>> setConfigurationSettingWithResponse(ConfigurationSetting setting, boolean ifUnchanged) {
        try {
            return FluxUtil.withContext(context -> this.serviceClient.setConfigurationSettingWithResponseAsync(setting, ifUnchanged, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> getConfigurationSetting(String key, String label) {
        try {
            return this.getConfigurationSetting(key, label, null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> getConfigurationSetting(String key, String label, OffsetDateTime acceptDateTime) {
        try {
            return FluxUtil.withContext(context -> this.serviceClient.getConfigurationSettingWithResponseAsync(new ConfigurationSetting().setKey(key).setLabel(label), acceptDateTime, false, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> getConfigurationSetting(ConfigurationSetting setting) {
        return this.getConfigurationSettingWithResponse(setting, null, false).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConfigurationSetting>> getConfigurationSettingWithResponse(ConfigurationSetting setting, OffsetDateTime acceptDateTime, boolean ifChanged) {
        try {
            return FluxUtil.withContext(context -> this.serviceClient.getConfigurationSettingWithResponseAsync(setting, acceptDateTime, ifChanged, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> deleteConfigurationSetting(String key, String label) {
        try {
            return FluxUtil.withContext(context -> this.serviceClient.deleteConfigurationSettingWithResponseAsync(new ConfigurationSetting().setKey(key).setLabel(label), false, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> deleteConfigurationSetting(ConfigurationSetting setting) {
        return this.deleteConfigurationSettingWithResponse(setting, false).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConfigurationSetting>> deleteConfigurationSettingWithResponse(ConfigurationSetting setting, boolean ifUnchanged) {
        try {
            return FluxUtil.withContext(context -> this.serviceClient.deleteConfigurationSettingWithResponseAsync(setting, ifUnchanged, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> setReadOnly(String key, String label, boolean isReadOnly) {
        try {
            return FluxUtil.withContext(context -> this.serviceClient.setReadOnlyWithResponseAsync(new ConfigurationSetting().setKey(key).setLabel(label), isReadOnly, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> setReadOnly(ConfigurationSetting setting, boolean isReadOnly) {
        return this.setReadOnlyWithResponse(setting, isReadOnly).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConfigurationSetting>> setReadOnlyWithResponse(ConfigurationSetting setting, boolean isReadOnly) {
        try {
            return FluxUtil.withContext(context -> this.serviceClient.setReadOnlyWithResponseAsync(setting, isReadOnly, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ConfigurationSetting> listConfigurationSettings(SettingSelector selector) {
        return this.serviceClient.listConfigurationSettingsAsync(selector);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ConfigurationSetting> listRevisions(SettingSelector selector) {
        return this.serviceClient.listRevisionsAsync(selector);
    }

    public void updateSyncToken(String token) {
        Objects.requireNonNull(token, "'token' cannot be null.");
        this.syncTokenPolicy.updateSyncToken(token);
    }
}

