/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.annotation.HeaderCollection;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.implementation.ReflectionSerializable;
import com.azure.core.implementation.ReflectionUtils;
import com.azure.core.implementation.ReflectiveInvoker;
import com.azure.core.implementation.TypeUtil;
import com.azure.core.implementation.jackson.HeaderCollectionHandler;
import com.azure.core.implementation.jackson.JacksonVersion;
import com.azure.core.implementation.jackson.JsonSerializableDeserializer;
import com.azure.core.implementation.jackson.MemberNameConverterImpl;
import com.azure.core.implementation.jackson.ObjectMapperFactory;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;

public final class ObjectMapperShim {
    private static final ClientLogger LOGGER = new ClientLogger(ObjectMapperShim.class);
    private static final int CACHE_SIZE_LIMIT = 10000;
    private static final Map<Type, JavaType> TYPE_TO_JAVA_TYPE_CACHE = new ConcurrentHashMap<Type, JavaType>();
    private static final Map<Type, ReflectiveInvoker> TYPE_TO_STRONGLY_TYPED_HEADERS_CONSTRUCTOR_CACHE = new ConcurrentHashMap<Type, ReflectiveInvoker>();
    private static final ReflectiveInvoker NO_CONSTRUCTOR_REFLECTIVE_INVOKER = ReflectionUtils.createNoOpInvoker();
    private final ObjectMapper mapper;
    private MemberNameConverterImpl memberNameConverter;

    public static ObjectMapperShim createJsonMapper(ObjectMapperShim innerMapperShim, BiConsumer<ObjectMapper, ObjectMapper> configure) {
        try {
            ObjectMapper mapper = ObjectMapperFactory.INSTANCE.createJsonMapper(innerMapperShim.mapper);
            configure.accept(mapper, innerMapperShim.mapper);
            return new ObjectMapperShim(mapper);
        }
        catch (LinkageError ex) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), ex));
        }
    }

    public static ObjectMapperShim createXmlMapper() {
        try {
            ObjectMapper mapper = ObjectMapperFactory.INSTANCE.createXmlMapper();
            return new ObjectMapperShim(mapper);
        }
        catch (LinkageError ex) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), ex));
        }
    }

    public static ObjectMapperShim createSimpleMapper() {
        try {
            ObjectMapper mapper = ObjectMapperFactory.INSTANCE.createSimpleMapper();
            return new ObjectMapperShim(mapper);
        }
        catch (LinkageError ex) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), ex));
        }
    }

    public static ObjectMapperShim createDefaultMapper() {
        try {
            ObjectMapper mapper = ObjectMapperFactory.INSTANCE.createDefaultMapper();
            return new ObjectMapperShim(mapper);
        }
        catch (LinkageError ex) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), ex));
        }
    }

    public static ObjectMapperShim createPrettyPrintMapper() {
        try {
            ObjectMapper mapper = ObjectMapperFactory.INSTANCE.createPrettyPrintMapper();
            return new ObjectMapperShim(mapper);
        }
        catch (LinkageError ex) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), ex));
        }
    }

    public static ObjectMapperShim createHeaderMapper() {
        try {
            ObjectMapper mapper = ObjectMapperFactory.INSTANCE.createHeaderMapper();
            return new ObjectMapperShim(mapper);
        }
        catch (LinkageError ex) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), ex));
        }
    }

    public ObjectMapperShim(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public String writeValueAsString(Object value) throws IOException {
        try {
            return this.mapper.writeValueAsString(value);
        }
        catch (LinkageError ex) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), ex));
        }
    }

    public byte[] writeValueAsBytes(Object value) throws IOException {
        try {
            return this.mapper.writeValueAsBytes(value);
        }
        catch (LinkageError ex) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), ex));
        }
    }

    public void writeValue(OutputStream out, Object value) throws IOException {
        try {
            this.mapper.writeValue(out, value);
        }
        catch (LinkageError ex) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), ex));
        }
    }

    public <T> T readValue(String content, Type valueType) throws IOException {
        try {
            JavaType javaType = this.createJavaType(valueType);
            return (T)this.mapper.readValue(content, javaType);
        }
        catch (LinkageError ex) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), ex));
        }
    }

    public <T> T readValue(byte[] src, Type valueType) throws IOException {
        try {
            JavaType javaType = this.createJavaType(valueType);
            return (T)this.mapper.readValue(src, javaType);
        }
        catch (LinkageError ex) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), ex));
        }
    }

    public <T> T readValue(InputStream src, Type valueType) throws IOException {
        try {
            JavaType javaType = this.createJavaType(valueType);
            return (T)this.mapper.readValue(src, javaType);
        }
        catch (LinkageError ex) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), ex));
        }
    }

    public JsonNode readTree(String content) throws IOException {
        try {
            return this.mapper.readTree(content);
        }
        catch (LinkageError ex) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), ex));
        }
    }

    public JsonNode readTree(byte[] content) throws IOException {
        try {
            return this.mapper.readTree(content);
        }
        catch (LinkageError ex) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), ex));
        }
    }

    private JavaType createJavaType(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof JavaType) {
            return (JavaType)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            JavaType[] javaTypeArguments = new JavaType[actualTypeArguments.length];
            for (int i = 0; i != actualTypeArguments.length; ++i) {
                javaTypeArguments[i] = this.createJavaType(actualTypeArguments[i]);
            }
            return ObjectMapperShim.getFromTypeCache(type, t -> this.mapper.getTypeFactory().constructParametricType((Class)parameterizedType.getRawType(), javaTypeArguments));
        }
        return ObjectMapperShim.getFromTypeCache(type, t -> {
            JavaType javaType = this.mapper.constructType(t);
            if (!javaType.isContainerType()) {
                Class clazz = javaType.getRawClass();
                if (ReflectionSerializable.supportsJsonSerializable(clazz)) {
                    return javaType.withValueHandler((Object)new JsonSerializableDeserializer(clazz));
                }
                return javaType;
            }
            JavaType initializeType = javaType;
            Stack<JavaType> containerTypes = new Stack<JavaType>();
            while (javaType.isContainerType()) {
                containerTypes.add(javaType);
                javaType = javaType.getContentType();
            }
            Class clazz = javaType.getRawClass();
            if (!ReflectionSerializable.supportsJsonSerializable(clazz)) {
                return initializeType;
            }
            javaType = javaType.withValueHandler((Object)new JsonSerializableDeserializer(clazz));
            JavaType toReturn = javaType;
            while (!containerTypes.isEmpty()) {
                toReturn = ((JavaType)containerTypes.pop()).withContentType(toReturn);
            }
            return toReturn;
        });
    }

    public <T> T deserialize(HttpHeaders headers, Type deserializedHeadersType) throws IOException {
        if (deserializedHeadersType == null) {
            return null;
        }
        try {
            ReflectiveInvoker constructor = ObjectMapperShim.getFromHeadersConstructorCache(deserializedHeadersType);
            if (constructor != NO_CONSTRUCTOR_REFLECTIVE_INVOKER) {
                return (T)constructor.invokeStatic(headers);
            }
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)exception);
            }
            LOGGER.log(LogLevel.VERBOSE, () -> "Failed to find or use invoker Constructor that accepts HttpHeaders for " + deserializedHeadersType + ".");
        }
        Object deserializedHeaders = this.mapper.convertValue((Object)headers, this.createJavaType(deserializedHeadersType));
        Class<?> deserializedHeadersClass = TypeUtil.getRawClass(deserializedHeadersType);
        Field[] declaredFields = deserializedHeadersClass.getDeclaredFields();
        ArrayList<HeaderCollectionHandler> headerCollectionHandlers = new ArrayList<HeaderCollectionHandler>();
        HashSet<Character> headerCollectionsFirstCharacters = new HashSet<Character>();
        for (Field declaredField : declaredFields) {
            HeaderCollection headerCollectionAnnotation;
            String headerCollectionPrefix;
            int headerCollectionPrefixLength;
            Type[] mapTypeArguments;
            if (!declaredField.isAnnotationPresent(HeaderCollection.class)) continue;
            Type declaredFieldType = declaredField.getGenericType();
            if (!TypeUtil.isTypeOrSubTypeOf(declaredField.getType(), Map.class) || (mapTypeArguments = TypeUtil.getTypeArguments(declaredFieldType)).length != 2 || mapTypeArguments[0] != String.class || mapTypeArguments[1] != String.class || (headerCollectionPrefixLength = (headerCollectionPrefix = (headerCollectionAnnotation = declaredField.getAnnotation(HeaderCollection.class)).value().toLowerCase(Locale.ROOT)).length()) == 0) continue;
            headerCollectionHandlers.add(new HeaderCollectionHandler(headerCollectionPrefix, declaredField));
            headerCollectionsFirstCharacters.add(Character.valueOf(headerCollectionPrefix.charAt(0)));
        }
        for (HttpHeader header : headers) {
            String headerNameLower = header.getName().toLowerCase(Locale.ROOT);
            if (!headerCollectionsFirstCharacters.contains(Character.valueOf(headerNameLower.charAt(0)))) continue;
            for (HeaderCollectionHandler headerCollectionHandler : headerCollectionHandlers) {
                if (!headerCollectionHandler.headerStartsWithPrefix(headerNameLower)) continue;
                headerCollectionHandler.addHeader(header.getName(), header.getValue());
            }
        }
        headerCollectionHandlers.forEach(h -> h.injectValuesIntoDeclaringField(deserializedHeaders, LOGGER));
        return (T)deserializedHeaders;
    }

    public String convertMemberName(Member member) {
        if (this.memberNameConverter == null) {
            this.memberNameConverter = new MemberNameConverterImpl(this.mapper);
        }
        try {
            return this.memberNameConverter.convertMemberName(member);
        }
        catch (LinkageError ex) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), ex));
        }
    }

    private static JavaType getFromTypeCache(Type key, Function<Type, JavaType> compute) {
        if (TYPE_TO_JAVA_TYPE_CACHE.size() >= 10000) {
            TYPE_TO_JAVA_TYPE_CACHE.clear();
        }
        return TYPE_TO_JAVA_TYPE_CACHE.computeIfAbsent(key, compute);
    }

    private static ReflectiveInvoker getFromHeadersConstructorCache(Type key) {
        if (TYPE_TO_STRONGLY_TYPED_HEADERS_CONSTRUCTOR_CACHE.size() >= 10000) {
            TYPE_TO_STRONGLY_TYPED_HEADERS_CONSTRUCTOR_CACHE.clear();
        }
        return TYPE_TO_STRONGLY_TYPED_HEADERS_CONSTRUCTOR_CACHE.computeIfAbsent(key, type -> {
            try {
                Class<?> headersClass = TypeUtil.getRawClass(type);
                return ReflectionUtils.getConstructorInvoker(headersClass, headersClass.getDeclaredConstructor(HttpHeaders.class));
            }
            catch (Throwable throwable) {
                if (throwable instanceof Error) {
                    throw LOGGER.logThrowableAsError((Error)throwable);
                }
                return NO_CONSTRUCTOR_REFLECTIVE_INVOKER;
            }
        });
    }
}

