/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wafv2.model.All;
import com.amazonaws.services.wafv2.model.transform.HeaderMatchPatternMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HeaderMatchPattern
implements Serializable,
Cloneable,
StructuredPojo {
    private All all;
    private List<String> includedHeaders;
    private List<String> excludedHeaders;

    public void setAll(All all) {
        this.all = all;
    }

    public All getAll() {
        return this.all;
    }

    public HeaderMatchPattern withAll(All all) {
        this.setAll(all);
        return this;
    }

    public List<String> getIncludedHeaders() {
        return this.includedHeaders;
    }

    public void setIncludedHeaders(Collection<String> includedHeaders) {
        if (includedHeaders == null) {
            this.includedHeaders = null;
            return;
        }
        this.includedHeaders = new ArrayList<String>(includedHeaders);
    }

    public HeaderMatchPattern withIncludedHeaders(String ... includedHeaders) {
        if (this.includedHeaders == null) {
            this.setIncludedHeaders(new ArrayList<String>(includedHeaders.length));
        }
        for (String ele : includedHeaders) {
            this.includedHeaders.add(ele);
        }
        return this;
    }

    public HeaderMatchPattern withIncludedHeaders(Collection<String> includedHeaders) {
        this.setIncludedHeaders(includedHeaders);
        return this;
    }

    public List<String> getExcludedHeaders() {
        return this.excludedHeaders;
    }

    public void setExcludedHeaders(Collection<String> excludedHeaders) {
        if (excludedHeaders == null) {
            this.excludedHeaders = null;
            return;
        }
        this.excludedHeaders = new ArrayList<String>(excludedHeaders);
    }

    public HeaderMatchPattern withExcludedHeaders(String ... excludedHeaders) {
        if (this.excludedHeaders == null) {
            this.setExcludedHeaders(new ArrayList<String>(excludedHeaders.length));
        }
        for (String ele : excludedHeaders) {
            this.excludedHeaders.add(ele);
        }
        return this;
    }

    public HeaderMatchPattern withExcludedHeaders(Collection<String> excludedHeaders) {
        this.setExcludedHeaders(excludedHeaders);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAll() != null) {
            sb.append("All: ").append(this.getAll()).append(",");
        }
        if (this.getIncludedHeaders() != null) {
            sb.append("IncludedHeaders: ").append(this.getIncludedHeaders()).append(",");
        }
        if (this.getExcludedHeaders() != null) {
            sb.append("ExcludedHeaders: ").append(this.getExcludedHeaders());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HeaderMatchPattern)) {
            return false;
        }
        HeaderMatchPattern other = (HeaderMatchPattern)obj;
        if (other.getAll() == null ^ this.getAll() == null) {
            return false;
        }
        if (other.getAll() != null && !other.getAll().equals(this.getAll())) {
            return false;
        }
        if (other.getIncludedHeaders() == null ^ this.getIncludedHeaders() == null) {
            return false;
        }
        if (other.getIncludedHeaders() != null && !other.getIncludedHeaders().equals(this.getIncludedHeaders())) {
            return false;
        }
        if (other.getExcludedHeaders() == null ^ this.getExcludedHeaders() == null) {
            return false;
        }
        return other.getExcludedHeaders() == null || other.getExcludedHeaders().equals(this.getExcludedHeaders());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAll() == null ? 0 : this.getAll().hashCode());
        hashCode = 31 * hashCode + (this.getIncludedHeaders() == null ? 0 : this.getIncludedHeaders().hashCode());
        hashCode = 31 * hashCode + (this.getExcludedHeaders() == null ? 0 : this.getExcludedHeaders().hashCode());
        return hashCode;
    }

    public HeaderMatchPattern clone() {
        try {
            return (HeaderMatchPattern)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HeaderMatchPatternMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

