/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.trustedadvisor;

import javax.annotation.Generated;

import com.amazonaws.services.trustedadvisor.model.*;

/**
 * Abstract implementation of {@code AWSTrustedAdvisorAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSTrustedAdvisorAsync extends AbstractAWSTrustedAdvisor implements AWSTrustedAdvisorAsync {

    protected AbstractAWSTrustedAdvisorAsync() {
    }

    @Override
    public java.util.concurrent.Future<BatchUpdateRecommendationResourceExclusionResult> batchUpdateRecommendationResourceExclusionAsync(
            BatchUpdateRecommendationResourceExclusionRequest request) {

        return batchUpdateRecommendationResourceExclusionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<BatchUpdateRecommendationResourceExclusionResult> batchUpdateRecommendationResourceExclusionAsync(
            BatchUpdateRecommendationResourceExclusionRequest request,
            com.amazonaws.handlers.AsyncHandler<BatchUpdateRecommendationResourceExclusionRequest, BatchUpdateRecommendationResourceExclusionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetOrganizationRecommendationResult> getOrganizationRecommendationAsync(GetOrganizationRecommendationRequest request) {

        return getOrganizationRecommendationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetOrganizationRecommendationResult> getOrganizationRecommendationAsync(GetOrganizationRecommendationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetOrganizationRecommendationRequest, GetOrganizationRecommendationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetRecommendationResult> getRecommendationAsync(GetRecommendationRequest request) {

        return getRecommendationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetRecommendationResult> getRecommendationAsync(GetRecommendationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetRecommendationRequest, GetRecommendationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListChecksResult> listChecksAsync(ListChecksRequest request) {

        return listChecksAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListChecksResult> listChecksAsync(ListChecksRequest request,
            com.amazonaws.handlers.AsyncHandler<ListChecksRequest, ListChecksResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListOrganizationRecommendationAccountsResult> listOrganizationRecommendationAccountsAsync(
            ListOrganizationRecommendationAccountsRequest request) {

        return listOrganizationRecommendationAccountsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListOrganizationRecommendationAccountsResult> listOrganizationRecommendationAccountsAsync(
            ListOrganizationRecommendationAccountsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListOrganizationRecommendationAccountsRequest, ListOrganizationRecommendationAccountsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListOrganizationRecommendationResourcesResult> listOrganizationRecommendationResourcesAsync(
            ListOrganizationRecommendationResourcesRequest request) {

        return listOrganizationRecommendationResourcesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListOrganizationRecommendationResourcesResult> listOrganizationRecommendationResourcesAsync(
            ListOrganizationRecommendationResourcesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListOrganizationRecommendationResourcesRequest, ListOrganizationRecommendationResourcesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListOrganizationRecommendationsResult> listOrganizationRecommendationsAsync(
            ListOrganizationRecommendationsRequest request) {

        return listOrganizationRecommendationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListOrganizationRecommendationsResult> listOrganizationRecommendationsAsync(
            ListOrganizationRecommendationsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListOrganizationRecommendationsRequest, ListOrganizationRecommendationsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListRecommendationResourcesResult> listRecommendationResourcesAsync(ListRecommendationResourcesRequest request) {

        return listRecommendationResourcesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListRecommendationResourcesResult> listRecommendationResourcesAsync(ListRecommendationResourcesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListRecommendationResourcesRequest, ListRecommendationResourcesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListRecommendationsResult> listRecommendationsAsync(ListRecommendationsRequest request) {

        return listRecommendationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListRecommendationsResult> listRecommendationsAsync(ListRecommendationsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListRecommendationsRequest, ListRecommendationsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateOrganizationRecommendationLifecycleResult> updateOrganizationRecommendationLifecycleAsync(
            UpdateOrganizationRecommendationLifecycleRequest request) {

        return updateOrganizationRecommendationLifecycleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateOrganizationRecommendationLifecycleResult> updateOrganizationRecommendationLifecycleAsync(
            UpdateOrganizationRecommendationLifecycleRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateOrganizationRecommendationLifecycleRequest, UpdateOrganizationRecommendationLifecycleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateRecommendationLifecycleResult> updateRecommendationLifecycleAsync(UpdateRecommendationLifecycleRequest request) {

        return updateRecommendationLifecycleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateRecommendationLifecycleResult> updateRecommendationLifecycleAsync(UpdateRecommendationLifecycleRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateRecommendationLifecycleRequest, UpdateRecommendationLifecycleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
