/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.TargetDevice;
import com.amazonaws.services.sagemaker.model.transform.OutputConfigMarshaller;
import java.io.Serializable;

public class OutputConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String s3OutputLocation;
    private String targetDevice;

    public void setS3OutputLocation(String s3OutputLocation) {
        this.s3OutputLocation = s3OutputLocation;
    }

    public String getS3OutputLocation() {
        return this.s3OutputLocation;
    }

    public OutputConfig withS3OutputLocation(String s3OutputLocation) {
        this.setS3OutputLocation(s3OutputLocation);
        return this;
    }

    public void setTargetDevice(String targetDevice) {
        this.targetDevice = targetDevice;
    }

    public String getTargetDevice() {
        return this.targetDevice;
    }

    public OutputConfig withTargetDevice(String targetDevice) {
        this.setTargetDevice(targetDevice);
        return this;
    }

    public OutputConfig withTargetDevice(TargetDevice targetDevice) {
        this.targetDevice = targetDevice.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3OutputLocation() != null) {
            sb.append("S3OutputLocation: ").append(this.getS3OutputLocation()).append(",");
        }
        if (this.getTargetDevice() != null) {
            sb.append("TargetDevice: ").append(this.getTargetDevice());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputConfig)) {
            return false;
        }
        OutputConfig other = (OutputConfig)obj;
        if (other.getS3OutputLocation() == null ^ this.getS3OutputLocation() == null) {
            return false;
        }
        if (other.getS3OutputLocation() != null && !other.getS3OutputLocation().equals(this.getS3OutputLocation())) {
            return false;
        }
        if (other.getTargetDevice() == null ^ this.getTargetDevice() == null) {
            return false;
        }
        return other.getTargetDevice() == null || other.getTargetDevice().equals(this.getTargetDevice());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3OutputLocation() == null ? 0 : this.getS3OutputLocation().hashCode());
        hashCode = 31 * hashCode + (this.getTargetDevice() == null ? 0 : this.getTargetDevice().hashCode());
        return hashCode;
    }

    public OutputConfig clone() {
        try {
            return (OutputConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

