/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.private5g.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.private5g.model.NameValuePair;
import com.amazonaws.services.private5g.model.NetworkResourceDefinition;
import com.amazonaws.services.private5g.model.transform.SitePlanMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SitePlan
implements Serializable,
Cloneable,
StructuredPojo {
    private List<NameValuePair> options;
    private List<NetworkResourceDefinition> resourceDefinitions;

    public List<NameValuePair> getOptions() {
        return this.options;
    }

    public void setOptions(Collection<NameValuePair> options) {
        if (options == null) {
            this.options = null;
            return;
        }
        this.options = new ArrayList<NameValuePair>(options);
    }

    public SitePlan withOptions(NameValuePair ... options) {
        if (this.options == null) {
            this.setOptions(new ArrayList<NameValuePair>(options.length));
        }
        for (NameValuePair ele : options) {
            this.options.add(ele);
        }
        return this;
    }

    public SitePlan withOptions(Collection<NameValuePair> options) {
        this.setOptions(options);
        return this;
    }

    public List<NetworkResourceDefinition> getResourceDefinitions() {
        return this.resourceDefinitions;
    }

    public void setResourceDefinitions(Collection<NetworkResourceDefinition> resourceDefinitions) {
        if (resourceDefinitions == null) {
            this.resourceDefinitions = null;
            return;
        }
        this.resourceDefinitions = new ArrayList<NetworkResourceDefinition>(resourceDefinitions);
    }

    public SitePlan withResourceDefinitions(NetworkResourceDefinition ... resourceDefinitions) {
        if (this.resourceDefinitions == null) {
            this.setResourceDefinitions(new ArrayList<NetworkResourceDefinition>(resourceDefinitions.length));
        }
        for (NetworkResourceDefinition ele : resourceDefinitions) {
            this.resourceDefinitions.add(ele);
        }
        return this;
    }

    public SitePlan withResourceDefinitions(Collection<NetworkResourceDefinition> resourceDefinitions) {
        this.setResourceDefinitions(resourceDefinitions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOptions() != null) {
            sb.append("Options: ").append(this.getOptions()).append(",");
        }
        if (this.getResourceDefinitions() != null) {
            sb.append("ResourceDefinitions: ").append(this.getResourceDefinitions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SitePlan)) {
            return false;
        }
        SitePlan other = (SitePlan)obj;
        if (other.getOptions() == null ^ this.getOptions() == null) {
            return false;
        }
        if (other.getOptions() != null && !other.getOptions().equals(this.getOptions())) {
            return false;
        }
        if (other.getResourceDefinitions() == null ^ this.getResourceDefinitions() == null) {
            return false;
        }
        return other.getResourceDefinitions() == null || other.getResourceDefinitions().equals(this.getResourceDefinitions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOptions() == null ? 0 : this.getOptions().hashCode());
        hashCode = 31 * hashCode + (this.getResourceDefinitions() == null ? 0 : this.getResourceDefinitions().hashCode());
        return hashCode;
    }

    public SitePlan clone() {
        try {
            return (SitePlan)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SitePlanMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

