/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptography.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.paymentcryptography.model.WrappingKeySpec;
import com.amazonaws.services.paymentcryptography.model.transform.ExportKeyCryptogramMarshaller;
import java.io.Serializable;

public class ExportKeyCryptogram
implements Serializable,
Cloneable,
StructuredPojo {
    private String certificateAuthorityPublicKeyIdentifier;
    private String wrappingKeyCertificate;
    private String wrappingSpec;

    public void setCertificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier) {
        this.certificateAuthorityPublicKeyIdentifier = certificateAuthorityPublicKeyIdentifier;
    }

    public String getCertificateAuthorityPublicKeyIdentifier() {
        return this.certificateAuthorityPublicKeyIdentifier;
    }

    public ExportKeyCryptogram withCertificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier) {
        this.setCertificateAuthorityPublicKeyIdentifier(certificateAuthorityPublicKeyIdentifier);
        return this;
    }

    public void setWrappingKeyCertificate(String wrappingKeyCertificate) {
        this.wrappingKeyCertificate = wrappingKeyCertificate;
    }

    public String getWrappingKeyCertificate() {
        return this.wrappingKeyCertificate;
    }

    public ExportKeyCryptogram withWrappingKeyCertificate(String wrappingKeyCertificate) {
        this.setWrappingKeyCertificate(wrappingKeyCertificate);
        return this;
    }

    public void setWrappingSpec(String wrappingSpec) {
        this.wrappingSpec = wrappingSpec;
    }

    public String getWrappingSpec() {
        return this.wrappingSpec;
    }

    public ExportKeyCryptogram withWrappingSpec(String wrappingSpec) {
        this.setWrappingSpec(wrappingSpec);
        return this;
    }

    public ExportKeyCryptogram withWrappingSpec(WrappingKeySpec wrappingSpec) {
        this.wrappingSpec = wrappingSpec.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCertificateAuthorityPublicKeyIdentifier() != null) {
            sb.append("CertificateAuthorityPublicKeyIdentifier: ").append(this.getCertificateAuthorityPublicKeyIdentifier()).append(",");
        }
        if (this.getWrappingKeyCertificate() != null) {
            sb.append("WrappingKeyCertificate: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getWrappingSpec() != null) {
            sb.append("WrappingSpec: ").append(this.getWrappingSpec());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportKeyCryptogram)) {
            return false;
        }
        ExportKeyCryptogram other = (ExportKeyCryptogram)obj;
        if (other.getCertificateAuthorityPublicKeyIdentifier() == null ^ this.getCertificateAuthorityPublicKeyIdentifier() == null) {
            return false;
        }
        if (other.getCertificateAuthorityPublicKeyIdentifier() != null && !other.getCertificateAuthorityPublicKeyIdentifier().equals(this.getCertificateAuthorityPublicKeyIdentifier())) {
            return false;
        }
        if (other.getWrappingKeyCertificate() == null ^ this.getWrappingKeyCertificate() == null) {
            return false;
        }
        if (other.getWrappingKeyCertificate() != null && !other.getWrappingKeyCertificate().equals(this.getWrappingKeyCertificate())) {
            return false;
        }
        if (other.getWrappingSpec() == null ^ this.getWrappingSpec() == null) {
            return false;
        }
        return other.getWrappingSpec() == null || other.getWrappingSpec().equals(this.getWrappingSpec());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCertificateAuthorityPublicKeyIdentifier() == null ? 0 : this.getCertificateAuthorityPublicKeyIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getWrappingKeyCertificate() == null ? 0 : this.getWrappingKeyCertificate().hashCode());
        hashCode = 31 * hashCode + (this.getWrappingSpec() == null ? 0 : this.getWrappingSpec().hashCode());
        return hashCode;
    }

    public ExportKeyCryptogram clone() {
        try {
            return (ExportKeyCryptogram)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExportKeyCryptogramMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

