/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.omics.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.omics.model.ShareDetails;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListSharesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ShareDetails> shares;
    private String nextToken;

    public List<ShareDetails> getShares() {
        return this.shares;
    }

    public void setShares(Collection<ShareDetails> shares) {
        if (shares == null) {
            this.shares = null;
            return;
        }
        this.shares = new ArrayList<ShareDetails>(shares);
    }

    public ListSharesResult withShares(ShareDetails ... shares) {
        if (this.shares == null) {
            this.setShares(new ArrayList<ShareDetails>(shares.length));
        }
        for (ShareDetails ele : shares) {
            this.shares.add(ele);
        }
        return this;
    }

    public ListSharesResult withShares(Collection<ShareDetails> shares) {
        this.setShares(shares);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListSharesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getShares() != null) {
            sb.append("Shares: ").append(this.getShares()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSharesResult)) {
            return false;
        }
        ListSharesResult other = (ListSharesResult)obj;
        if (other.getShares() == null ^ this.getShares() == null) {
            return false;
        }
        if (other.getShares() != null && !other.getShares().equals(this.getShares())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getShares() == null ? 0 : this.getShares().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListSharesResult clone() {
        try {
            return (ListSharesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

