/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.networkmanager.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.networkmanager.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * RouteTableIdentifierMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class RouteTableIdentifierMarshaller {

    private static final MarshallingInfo<String> TRANSITGATEWAYROUTETABLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TransitGatewayRouteTableArn").build();
    private static final MarshallingInfo<StructuredPojo> CORENETWORKSEGMENTEDGE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CoreNetworkSegmentEdge").build();
    private static final MarshallingInfo<StructuredPojo> CORENETWORKNETWORKFUNCTIONGROUP_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CoreNetworkNetworkFunctionGroup").build();

    private static final RouteTableIdentifierMarshaller instance = new RouteTableIdentifierMarshaller();

    public static RouteTableIdentifierMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(RouteTableIdentifier routeTableIdentifier, ProtocolMarshaller protocolMarshaller) {

        if (routeTableIdentifier == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(routeTableIdentifier.getTransitGatewayRouteTableArn(), TRANSITGATEWAYROUTETABLEARN_BINDING);
            protocolMarshaller.marshall(routeTableIdentifier.getCoreNetworkSegmentEdge(), CORENETWORKSEGMENTEDGE_BINDING);
            protocolMarshaller.marshall(routeTableIdentifier.getCoreNetworkNetworkFunctionGroup(), CORENETWORKNETWORKFUNCTIONGROUP_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
