/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.migrationhuborchestrator.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.migrationhuborchestrator.model.StepInput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateWorkflowRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String description;
    private String templateId;
    private String applicationConfigurationId;
    private Map<String, StepInput> inputParameters;
    private List<String> stepTargets;
    private Map<String, String> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateWorkflowRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateWorkflowRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public CreateWorkflowRequest withTemplateId(String templateId) {
        this.setTemplateId(templateId);
        return this;
    }

    public void setApplicationConfigurationId(String applicationConfigurationId) {
        this.applicationConfigurationId = applicationConfigurationId;
    }

    public String getApplicationConfigurationId() {
        return this.applicationConfigurationId;
    }

    public CreateWorkflowRequest withApplicationConfigurationId(String applicationConfigurationId) {
        this.setApplicationConfigurationId(applicationConfigurationId);
        return this;
    }

    public Map<String, StepInput> getInputParameters() {
        return this.inputParameters;
    }

    public void setInputParameters(Map<String, StepInput> inputParameters) {
        this.inputParameters = inputParameters;
    }

    public CreateWorkflowRequest withInputParameters(Map<String, StepInput> inputParameters) {
        this.setInputParameters(inputParameters);
        return this;
    }

    public CreateWorkflowRequest addInputParametersEntry(String key, StepInput value) {
        if (null == this.inputParameters) {
            this.inputParameters = new HashMap<String, StepInput>();
        }
        if (this.inputParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.inputParameters.put(key, value);
        return this;
    }

    public CreateWorkflowRequest clearInputParametersEntries() {
        this.inputParameters = null;
        return this;
    }

    public List<String> getStepTargets() {
        return this.stepTargets;
    }

    public void setStepTargets(Collection<String> stepTargets) {
        if (stepTargets == null) {
            this.stepTargets = null;
            return;
        }
        this.stepTargets = new ArrayList<String>(stepTargets);
    }

    public CreateWorkflowRequest withStepTargets(String ... stepTargets) {
        if (this.stepTargets == null) {
            this.setStepTargets(new ArrayList<String>(stepTargets.length));
        }
        for (String ele : stepTargets) {
            this.stepTargets.add(ele);
        }
        return this;
    }

    public CreateWorkflowRequest withStepTargets(Collection<String> stepTargets) {
        this.setStepTargets(stepTargets);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateWorkflowRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateWorkflowRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateWorkflowRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTemplateId() != null) {
            sb.append("TemplateId: ").append(this.getTemplateId()).append(",");
        }
        if (this.getApplicationConfigurationId() != null) {
            sb.append("ApplicationConfigurationId: ").append(this.getApplicationConfigurationId()).append(",");
        }
        if (this.getInputParameters() != null) {
            sb.append("InputParameters: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getStepTargets() != null) {
            sb.append("StepTargets: ").append(this.getStepTargets()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkflowRequest)) {
            return false;
        }
        CreateWorkflowRequest other = (CreateWorkflowRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTemplateId() == null ^ this.getTemplateId() == null) {
            return false;
        }
        if (other.getTemplateId() != null && !other.getTemplateId().equals(this.getTemplateId())) {
            return false;
        }
        if (other.getApplicationConfigurationId() == null ^ this.getApplicationConfigurationId() == null) {
            return false;
        }
        if (other.getApplicationConfigurationId() != null && !other.getApplicationConfigurationId().equals(this.getApplicationConfigurationId())) {
            return false;
        }
        if (other.getInputParameters() == null ^ this.getInputParameters() == null) {
            return false;
        }
        if (other.getInputParameters() != null && !other.getInputParameters().equals(this.getInputParameters())) {
            return false;
        }
        if (other.getStepTargets() == null ^ this.getStepTargets() == null) {
            return false;
        }
        if (other.getStepTargets() != null && !other.getStepTargets().equals(this.getStepTargets())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateId() == null ? 0 : this.getTemplateId().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationConfigurationId() == null ? 0 : this.getApplicationConfigurationId().hashCode());
        hashCode = 31 * hashCode + (this.getInputParameters() == null ? 0 : this.getInputParameters().hashCode());
        hashCode = 31 * hashCode + (this.getStepTargets() == null ? 0 : this.getStepTargets().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateWorkflowRequest clone() {
        return (CreateWorkflowRequest)super.clone();
    }
}

