/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lexmodelsv2.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.lexmodelsv2.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * IntentConfirmationSetting JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class IntentConfirmationSettingJsonUnmarshaller implements Unmarshaller<IntentConfirmationSetting, JsonUnmarshallerContext> {

    public IntentConfirmationSetting unmarshall(JsonUnmarshallerContext context) throws Exception {
        IntentConfirmationSetting intentConfirmationSetting = new IntentConfirmationSetting();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("promptSpecification", targetDepth)) {
                    context.nextToken();
                    intentConfirmationSetting.setPromptSpecification(PromptSpecificationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("declinationResponse", targetDepth)) {
                    context.nextToken();
                    intentConfirmationSetting.setDeclinationResponse(ResponseSpecificationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("active", targetDepth)) {
                    context.nextToken();
                    intentConfirmationSetting.setActive(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("confirmationResponse", targetDepth)) {
                    context.nextToken();
                    intentConfirmationSetting.setConfirmationResponse(ResponseSpecificationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("confirmationNextStep", targetDepth)) {
                    context.nextToken();
                    intentConfirmationSetting.setConfirmationNextStep(DialogStateJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("confirmationConditional", targetDepth)) {
                    context.nextToken();
                    intentConfirmationSetting.setConfirmationConditional(ConditionalSpecificationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("declinationNextStep", targetDepth)) {
                    context.nextToken();
                    intentConfirmationSetting.setDeclinationNextStep(DialogStateJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("declinationConditional", targetDepth)) {
                    context.nextToken();
                    intentConfirmationSetting.setDeclinationConditional(ConditionalSpecificationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("failureResponse", targetDepth)) {
                    context.nextToken();
                    intentConfirmationSetting.setFailureResponse(ResponseSpecificationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("failureNextStep", targetDepth)) {
                    context.nextToken();
                    intentConfirmationSetting.setFailureNextStep(DialogStateJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("failureConditional", targetDepth)) {
                    context.nextToken();
                    intentConfirmationSetting.setFailureConditional(ConditionalSpecificationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("codeHook", targetDepth)) {
                    context.nextToken();
                    intentConfirmationSetting.setCodeHook(DialogCodeHookInvocationSettingJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("elicitationCodeHook", targetDepth)) {
                    context.nextToken();
                    intentConfirmationSetting.setElicitationCodeHook(ElicitationCodeHookInvocationSettingJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return intentConfirmationSetting;
    }

    private static IntentConfirmationSettingJsonUnmarshaller instance;

    public static IntentConfirmationSettingJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new IntentConfirmationSettingJsonUnmarshaller();
        return instance;
    }
}
