/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.Correction;
import com.amazonaws.services.kendra.model.transform.SpellCorrectedQueryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SpellCorrectedQuery
implements Serializable,
Cloneable,
StructuredPojo {
    private String suggestedQueryText;
    private List<Correction> corrections;

    public void setSuggestedQueryText(String suggestedQueryText) {
        this.suggestedQueryText = suggestedQueryText;
    }

    public String getSuggestedQueryText() {
        return this.suggestedQueryText;
    }

    public SpellCorrectedQuery withSuggestedQueryText(String suggestedQueryText) {
        this.setSuggestedQueryText(suggestedQueryText);
        return this;
    }

    public List<Correction> getCorrections() {
        return this.corrections;
    }

    public void setCorrections(Collection<Correction> corrections) {
        if (corrections == null) {
            this.corrections = null;
            return;
        }
        this.corrections = new ArrayList<Correction>(corrections);
    }

    public SpellCorrectedQuery withCorrections(Correction ... corrections) {
        if (this.corrections == null) {
            this.setCorrections(new ArrayList<Correction>(corrections.length));
        }
        for (Correction ele : corrections) {
            this.corrections.add(ele);
        }
        return this;
    }

    public SpellCorrectedQuery withCorrections(Collection<Correction> corrections) {
        this.setCorrections(corrections);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSuggestedQueryText() != null) {
            sb.append("SuggestedQueryText: ").append(this.getSuggestedQueryText()).append(",");
        }
        if (this.getCorrections() != null) {
            sb.append("Corrections: ").append(this.getCorrections());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpellCorrectedQuery)) {
            return false;
        }
        SpellCorrectedQuery other = (SpellCorrectedQuery)obj;
        if (other.getSuggestedQueryText() == null ^ this.getSuggestedQueryText() == null) {
            return false;
        }
        if (other.getSuggestedQueryText() != null && !other.getSuggestedQueryText().equals(this.getSuggestedQueryText())) {
            return false;
        }
        if (other.getCorrections() == null ^ this.getCorrections() == null) {
            return false;
        }
        return other.getCorrections() == null || other.getCorrections().equals(this.getCorrections());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSuggestedQueryText() == null ? 0 : this.getSuggestedQueryText().hashCode());
        hashCode = 31 * hashCode + (this.getCorrections() == null ? 0 : this.getCorrections().hashCode());
        return hashCode;
    }

    public SpellCorrectedQuery clone() {
        try {
            return (SpellCorrectedQuery)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SpellCorrectedQueryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

