/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotanalytics;

import javax.annotation.Generated;

import com.amazonaws.services.iotanalytics.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSIoTAnalytics}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSIoTAnalytics implements AWSIoTAnalytics {

    protected AbstractAWSIoTAnalytics() {
    }

    @Override
    public BatchPutMessageResult batchPutMessage(BatchPutMessageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelPipelineReprocessingResult cancelPipelineReprocessing(CancelPipelineReprocessingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateChannelResult createChannel(CreateChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDatasetResult createDataset(CreateDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDatasetContentResult createDatasetContent(CreateDatasetContentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDatastoreResult createDatastore(CreateDatastoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePipelineResult createPipeline(CreatePipelineRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteChannelResult deleteChannel(DeleteChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDatasetResult deleteDataset(DeleteDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDatasetContentResult deleteDatasetContent(DeleteDatasetContentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDatastoreResult deleteDatastore(DeleteDatastoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePipelineResult deletePipeline(DeletePipelineRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeChannelResult describeChannel(DescribeChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDatasetResult describeDataset(DescribeDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDatastoreResult describeDatastore(DescribeDatastoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeLoggingOptionsResult describeLoggingOptions(DescribeLoggingOptionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePipelineResult describePipeline(DescribePipelineRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDatasetContentResult getDatasetContent(GetDatasetContentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListChannelsResult listChannels(ListChannelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDatasetContentsResult listDatasetContents(ListDatasetContentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDatasetsResult listDatasets(ListDatasetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDatastoresResult listDatastores(ListDatastoresRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPipelinesResult listPipelines(ListPipelinesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutLoggingOptionsResult putLoggingOptions(PutLoggingOptionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RunPipelineActivityResult runPipelineActivity(RunPipelineActivityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SampleChannelDataResult sampleChannelData(SampleChannelDataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartPipelineReprocessingResult startPipelineReprocessing(StartPipelineReprocessingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateChannelResult updateChannel(UpdateChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDatasetResult updateDataset(UpdateDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDatastoreResult updateDatastore(UpdateDatastoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePipelineResult updatePipeline(UpdatePipelineRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
