/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iot.model;

import java.io.Serializable;
import javax.annotation.Generated;

@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListMitigationActionsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * A set of actions that matched the specified filter criteria.
     * </p>
     */
    private java.util.List<MitigationActionIdentifier> actionIdentifiers;
    /**
     * <p>
     * The token for the next set of results.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * A set of actions that matched the specified filter criteria.
     * </p>
     * 
     * @return A set of actions that matched the specified filter criteria.
     */

    public java.util.List<MitigationActionIdentifier> getActionIdentifiers() {
        return actionIdentifiers;
    }

    /**
     * <p>
     * A set of actions that matched the specified filter criteria.
     * </p>
     * 
     * @param actionIdentifiers
     *        A set of actions that matched the specified filter criteria.
     */

    public void setActionIdentifiers(java.util.Collection<MitigationActionIdentifier> actionIdentifiers) {
        if (actionIdentifiers == null) {
            this.actionIdentifiers = null;
            return;
        }

        this.actionIdentifiers = new java.util.ArrayList<MitigationActionIdentifier>(actionIdentifiers);
    }

    /**
     * <p>
     * A set of actions that matched the specified filter criteria.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setActionIdentifiers(java.util.Collection)} or {@link #withActionIdentifiers(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param actionIdentifiers
     *        A set of actions that matched the specified filter criteria.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListMitigationActionsResult withActionIdentifiers(MitigationActionIdentifier... actionIdentifiers) {
        if (this.actionIdentifiers == null) {
            setActionIdentifiers(new java.util.ArrayList<MitigationActionIdentifier>(actionIdentifiers.length));
        }
        for (MitigationActionIdentifier ele : actionIdentifiers) {
            this.actionIdentifiers.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A set of actions that matched the specified filter criteria.
     * </p>
     * 
     * @param actionIdentifiers
     *        A set of actions that matched the specified filter criteria.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListMitigationActionsResult withActionIdentifiers(java.util.Collection<MitigationActionIdentifier> actionIdentifiers) {
        setActionIdentifiers(actionIdentifiers);
        return this;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @param nextToken
     *        The token for the next set of results.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @param nextToken
     *        The token for the next set of results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListMitigationActionsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getActionIdentifiers() != null)
            sb.append("ActionIdentifiers: ").append(getActionIdentifiers()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListMitigationActionsResult == false)
            return false;
        ListMitigationActionsResult other = (ListMitigationActionsResult) obj;
        if (other.getActionIdentifiers() == null ^ this.getActionIdentifiers() == null)
            return false;
        if (other.getActionIdentifiers() != null && other.getActionIdentifiers().equals(this.getActionIdentifiers()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getActionIdentifiers() == null) ? 0 : getActionIdentifiers().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListMitigationActionsResult clone() {
        try {
            return (ListMitigationActionsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
