/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.internetmonitor.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.internetmonitor.model.Network;

@SdkInternalApi
public class NetworkMarshaller {
    private static final MarshallingInfo<String> ASNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ASName").build();
    private static final MarshallingInfo<Long> ASNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ASNumber").build();
    private static final NetworkMarshaller instance = new NetworkMarshaller();

    public static NetworkMarshaller getInstance() {
        return instance;
    }

    public void marshall(Network network, ProtocolMarshaller protocolMarshaller) {
        if (network == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)network.getASName(), ASNAME_BINDING);
            protocolMarshaller.marshall((Object)network.getASNumber(), ASNUMBER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

