/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.internetmonitor.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.internetmonitor.model.InternetEventSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListInternetEventsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<InternetEventSummary> internetEvents;
    private String nextToken;

    public List<InternetEventSummary> getInternetEvents() {
        return this.internetEvents;
    }

    public void setInternetEvents(Collection<InternetEventSummary> internetEvents) {
        if (internetEvents == null) {
            this.internetEvents = null;
            return;
        }
        this.internetEvents = new ArrayList<InternetEventSummary>(internetEvents);
    }

    public ListInternetEventsResult withInternetEvents(InternetEventSummary ... internetEvents) {
        if (this.internetEvents == null) {
            this.setInternetEvents(new ArrayList<InternetEventSummary>(internetEvents.length));
        }
        for (InternetEventSummary ele : internetEvents) {
            this.internetEvents.add(ele);
        }
        return this;
    }

    public ListInternetEventsResult withInternetEvents(Collection<InternetEventSummary> internetEvents) {
        this.setInternetEvents(internetEvents);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListInternetEventsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInternetEvents() != null) {
            sb.append("InternetEvents: ").append(this.getInternetEvents()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInternetEventsResult)) {
            return false;
        }
        ListInternetEventsResult other = (ListInternetEventsResult)obj;
        if (other.getInternetEvents() == null ^ this.getInternetEvents() == null) {
            return false;
        }
        if (other.getInternetEvents() != null && !other.getInternetEvents().equals(this.getInternetEvents())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInternetEvents() == null ? 0 : this.getInternetEvents().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListInternetEventsResult clone() {
        try {
            return (ListInternetEventsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

