/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.inspector.model.Attribute;
import com.amazonaws.services.inspector.model.Severity;
import com.amazonaws.services.inspector.model.TimestampRange;
import com.amazonaws.services.inspector.model.transform.FindingFilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FindingFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> agentIds;
    private List<String> autoScalingGroups;
    private List<String> ruleNames;
    private List<String> severities;
    private List<String> rulesPackageArns;
    private List<Attribute> attributes;
    private List<Attribute> userAttributes;
    private TimestampRange creationTimeRange;

    public List<String> getAgentIds() {
        return this.agentIds;
    }

    public void setAgentIds(Collection<String> agentIds) {
        if (agentIds == null) {
            this.agentIds = null;
            return;
        }
        this.agentIds = new ArrayList<String>(agentIds);
    }

    public FindingFilter withAgentIds(String ... agentIds) {
        if (this.agentIds == null) {
            this.setAgentIds(new ArrayList<String>(agentIds.length));
        }
        for (String ele : agentIds) {
            this.agentIds.add(ele);
        }
        return this;
    }

    public FindingFilter withAgentIds(Collection<String> agentIds) {
        this.setAgentIds(agentIds);
        return this;
    }

    public List<String> getAutoScalingGroups() {
        return this.autoScalingGroups;
    }

    public void setAutoScalingGroups(Collection<String> autoScalingGroups) {
        if (autoScalingGroups == null) {
            this.autoScalingGroups = null;
            return;
        }
        this.autoScalingGroups = new ArrayList<String>(autoScalingGroups);
    }

    public FindingFilter withAutoScalingGroups(String ... autoScalingGroups) {
        if (this.autoScalingGroups == null) {
            this.setAutoScalingGroups(new ArrayList<String>(autoScalingGroups.length));
        }
        for (String ele : autoScalingGroups) {
            this.autoScalingGroups.add(ele);
        }
        return this;
    }

    public FindingFilter withAutoScalingGroups(Collection<String> autoScalingGroups) {
        this.setAutoScalingGroups(autoScalingGroups);
        return this;
    }

    public List<String> getRuleNames() {
        return this.ruleNames;
    }

    public void setRuleNames(Collection<String> ruleNames) {
        if (ruleNames == null) {
            this.ruleNames = null;
            return;
        }
        this.ruleNames = new ArrayList<String>(ruleNames);
    }

    public FindingFilter withRuleNames(String ... ruleNames) {
        if (this.ruleNames == null) {
            this.setRuleNames(new ArrayList<String>(ruleNames.length));
        }
        for (String ele : ruleNames) {
            this.ruleNames.add(ele);
        }
        return this;
    }

    public FindingFilter withRuleNames(Collection<String> ruleNames) {
        this.setRuleNames(ruleNames);
        return this;
    }

    public List<String> getSeverities() {
        return this.severities;
    }

    public void setSeverities(Collection<String> severities) {
        if (severities == null) {
            this.severities = null;
            return;
        }
        this.severities = new ArrayList<String>(severities);
    }

    public FindingFilter withSeverities(String ... severities) {
        if (this.severities == null) {
            this.setSeverities(new ArrayList<String>(severities.length));
        }
        for (String ele : severities) {
            this.severities.add(ele);
        }
        return this;
    }

    public FindingFilter withSeverities(Collection<String> severities) {
        this.setSeverities(severities);
        return this;
    }

    public FindingFilter withSeverities(Severity ... severities) {
        ArrayList<String> severitiesCopy = new ArrayList<String>(severities.length);
        for (Severity value : severities) {
            severitiesCopy.add(value.toString());
        }
        if (this.getSeverities() == null) {
            this.setSeverities(severitiesCopy);
        } else {
            this.getSeverities().addAll(severitiesCopy);
        }
        return this;
    }

    public List<String> getRulesPackageArns() {
        return this.rulesPackageArns;
    }

    public void setRulesPackageArns(Collection<String> rulesPackageArns) {
        if (rulesPackageArns == null) {
            this.rulesPackageArns = null;
            return;
        }
        this.rulesPackageArns = new ArrayList<String>(rulesPackageArns);
    }

    public FindingFilter withRulesPackageArns(String ... rulesPackageArns) {
        if (this.rulesPackageArns == null) {
            this.setRulesPackageArns(new ArrayList<String>(rulesPackageArns.length));
        }
        for (String ele : rulesPackageArns) {
            this.rulesPackageArns.add(ele);
        }
        return this;
    }

    public FindingFilter withRulesPackageArns(Collection<String> rulesPackageArns) {
        this.setRulesPackageArns(rulesPackageArns);
        return this;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection<Attribute> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        this.attributes = new ArrayList<Attribute>(attributes);
    }

    public FindingFilter withAttributes(Attribute ... attributes) {
        if (this.attributes == null) {
            this.setAttributes(new ArrayList<Attribute>(attributes.length));
        }
        for (Attribute ele : attributes) {
            this.attributes.add(ele);
        }
        return this;
    }

    public FindingFilter withAttributes(Collection<Attribute> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public List<Attribute> getUserAttributes() {
        return this.userAttributes;
    }

    public void setUserAttributes(Collection<Attribute> userAttributes) {
        if (userAttributes == null) {
            this.userAttributes = null;
            return;
        }
        this.userAttributes = new ArrayList<Attribute>(userAttributes);
    }

    public FindingFilter withUserAttributes(Attribute ... userAttributes) {
        if (this.userAttributes == null) {
            this.setUserAttributes(new ArrayList<Attribute>(userAttributes.length));
        }
        for (Attribute ele : userAttributes) {
            this.userAttributes.add(ele);
        }
        return this;
    }

    public FindingFilter withUserAttributes(Collection<Attribute> userAttributes) {
        this.setUserAttributes(userAttributes);
        return this;
    }

    public void setCreationTimeRange(TimestampRange creationTimeRange) {
        this.creationTimeRange = creationTimeRange;
    }

    public TimestampRange getCreationTimeRange() {
        return this.creationTimeRange;
    }

    public FindingFilter withCreationTimeRange(TimestampRange creationTimeRange) {
        this.setCreationTimeRange(creationTimeRange);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAgentIds() != null) {
            sb.append("AgentIds: ").append(this.getAgentIds()).append(",");
        }
        if (this.getAutoScalingGroups() != null) {
            sb.append("AutoScalingGroups: ").append(this.getAutoScalingGroups()).append(",");
        }
        if (this.getRuleNames() != null) {
            sb.append("RuleNames: ").append(this.getRuleNames()).append(",");
        }
        if (this.getSeverities() != null) {
            sb.append("Severities: ").append(this.getSeverities()).append(",");
        }
        if (this.getRulesPackageArns() != null) {
            sb.append("RulesPackageArns: ").append(this.getRulesPackageArns()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getUserAttributes() != null) {
            sb.append("UserAttributes: ").append(this.getUserAttributes()).append(",");
        }
        if (this.getCreationTimeRange() != null) {
            sb.append("CreationTimeRange: ").append(this.getCreationTimeRange());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingFilter)) {
            return false;
        }
        FindingFilter other = (FindingFilter)obj;
        if (other.getAgentIds() == null ^ this.getAgentIds() == null) {
            return false;
        }
        if (other.getAgentIds() != null && !other.getAgentIds().equals(this.getAgentIds())) {
            return false;
        }
        if (other.getAutoScalingGroups() == null ^ this.getAutoScalingGroups() == null) {
            return false;
        }
        if (other.getAutoScalingGroups() != null && !other.getAutoScalingGroups().equals(this.getAutoScalingGroups())) {
            return false;
        }
        if (other.getRuleNames() == null ^ this.getRuleNames() == null) {
            return false;
        }
        if (other.getRuleNames() != null && !other.getRuleNames().equals(this.getRuleNames())) {
            return false;
        }
        if (other.getSeverities() == null ^ this.getSeverities() == null) {
            return false;
        }
        if (other.getSeverities() != null && !other.getSeverities().equals(this.getSeverities())) {
            return false;
        }
        if (other.getRulesPackageArns() == null ^ this.getRulesPackageArns() == null) {
            return false;
        }
        if (other.getRulesPackageArns() != null && !other.getRulesPackageArns().equals(this.getRulesPackageArns())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getUserAttributes() == null ^ this.getUserAttributes() == null) {
            return false;
        }
        if (other.getUserAttributes() != null && !other.getUserAttributes().equals(this.getUserAttributes())) {
            return false;
        }
        if (other.getCreationTimeRange() == null ^ this.getCreationTimeRange() == null) {
            return false;
        }
        return other.getCreationTimeRange() == null || other.getCreationTimeRange().equals(this.getCreationTimeRange());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAgentIds() == null ? 0 : this.getAgentIds().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingGroups() == null ? 0 : this.getAutoScalingGroups().hashCode());
        hashCode = 31 * hashCode + (this.getRuleNames() == null ? 0 : this.getRuleNames().hashCode());
        hashCode = 31 * hashCode + (this.getSeverities() == null ? 0 : this.getSeverities().hashCode());
        hashCode = 31 * hashCode + (this.getRulesPackageArns() == null ? 0 : this.getRulesPackageArns().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getUserAttributes() == null ? 0 : this.getUserAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTimeRange() == null ? 0 : this.getCreationTimeRange().hashCode());
        return hashCode;
    }

    public FindingFilter clone() {
        try {
            return (FindingFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FindingFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

