/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.health.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.health.model.transform.AccountEntityAggregateMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AccountEntityAggregate
implements Serializable,
Cloneable,
StructuredPojo {
    private String accountId;
    private Integer count;
    private Map<String, Integer> statuses;

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public AccountEntityAggregate withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public Integer getCount() {
        return this.count;
    }

    public AccountEntityAggregate withCount(Integer count) {
        this.setCount(count);
        return this;
    }

    public Map<String, Integer> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(Map<String, Integer> statuses) {
        this.statuses = statuses;
    }

    public AccountEntityAggregate withStatuses(Map<String, Integer> statuses) {
        this.setStatuses(statuses);
        return this;
    }

    public AccountEntityAggregate addStatusesEntry(String key, Integer value) {
        if (null == this.statuses) {
            this.statuses = new HashMap<String, Integer>();
        }
        if (this.statuses.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.statuses.put(key, value);
        return this;
    }

    public AccountEntityAggregate clearStatusesEntries() {
        this.statuses = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getCount() != null) {
            sb.append("Count: ").append(this.getCount()).append(",");
        }
        if (this.getStatuses() != null) {
            sb.append("Statuses: ").append(this.getStatuses());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountEntityAggregate)) {
            return false;
        }
        AccountEntityAggregate other = (AccountEntityAggregate)obj;
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getCount() == null ^ this.getCount() == null) {
            return false;
        }
        if (other.getCount() != null && !other.getCount().equals(this.getCount())) {
            return false;
        }
        if (other.getStatuses() == null ^ this.getStatuses() == null) {
            return false;
        }
        return other.getStatuses() == null || other.getStatuses().equals(this.getStatuses());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getCount() == null ? 0 : this.getCount().hashCode());
        hashCode = 31 * hashCode + (this.getStatuses() == null ? 0 : this.getStatuses().hashCode());
        return hashCode;
    }

    public AccountEntityAggregate clone() {
        try {
            return (AccountEntityAggregate)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AccountEntityAggregateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

