/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.guardduty.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.guardduty.model.ScanFilePath;
import com.amazonaws.services.guardduty.model.transform.ScanThreatNameMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ScanThreatName
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String severity;
    private Integer itemCount;
    private List<ScanFilePath> filePaths;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ScanThreatName withName(String name) {
        this.setName(name);
        return this;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public String getSeverity() {
        return this.severity;
    }

    public ScanThreatName withSeverity(String severity) {
        this.setSeverity(severity);
        return this;
    }

    public void setItemCount(Integer itemCount) {
        this.itemCount = itemCount;
    }

    public Integer getItemCount() {
        return this.itemCount;
    }

    public ScanThreatName withItemCount(Integer itemCount) {
        this.setItemCount(itemCount);
        return this;
    }

    public List<ScanFilePath> getFilePaths() {
        return this.filePaths;
    }

    public void setFilePaths(Collection<ScanFilePath> filePaths) {
        if (filePaths == null) {
            this.filePaths = null;
            return;
        }
        this.filePaths = new ArrayList<ScanFilePath>(filePaths);
    }

    public ScanThreatName withFilePaths(ScanFilePath ... filePaths) {
        if (this.filePaths == null) {
            this.setFilePaths(new ArrayList<ScanFilePath>(filePaths.length));
        }
        for (ScanFilePath ele : filePaths) {
            this.filePaths.add(ele);
        }
        return this;
    }

    public ScanThreatName withFilePaths(Collection<ScanFilePath> filePaths) {
        this.setFilePaths(filePaths);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getSeverity() != null) {
            sb.append("Severity: ").append(this.getSeverity()).append(",");
        }
        if (this.getItemCount() != null) {
            sb.append("ItemCount: ").append(this.getItemCount()).append(",");
        }
        if (this.getFilePaths() != null) {
            sb.append("FilePaths: ").append(this.getFilePaths());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanThreatName)) {
            return false;
        }
        ScanThreatName other = (ScanThreatName)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getSeverity() == null ^ this.getSeverity() == null) {
            return false;
        }
        if (other.getSeverity() != null && !other.getSeverity().equals(this.getSeverity())) {
            return false;
        }
        if (other.getItemCount() == null ^ this.getItemCount() == null) {
            return false;
        }
        if (other.getItemCount() != null && !other.getItemCount().equals(this.getItemCount())) {
            return false;
        }
        if (other.getFilePaths() == null ^ this.getFilePaths() == null) {
            return false;
        }
        return other.getFilePaths() == null || other.getFilePaths().equals(this.getFilePaths());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getSeverity() == null ? 0 : this.getSeverity().hashCode());
        hashCode = 31 * hashCode + (this.getItemCount() == null ? 0 : this.getItemCount().hashCode());
        hashCode = 31 * hashCode + (this.getFilePaths() == null ? 0 : this.getFilePaths().hashCode());
        return hashCode;
    }

    public ScanThreatName clone() {
        try {
            return (ScanThreatName)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScanThreatNameMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

