/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.eks.model.ClientStat;
import java.util.Date;

@SdkInternalApi
public class ClientStatMarshaller {
    private static final MarshallingInfo<String> USERAGENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("userAgent").build();
    private static final MarshallingInfo<Integer> NUMBEROFREQUESTSLAST30DAYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numberOfRequestsLast30Days").build();
    private static final MarshallingInfo<Date> LASTREQUESTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastRequestTime").timestampFormat("unixTimestamp").build();
    private static final ClientStatMarshaller instance = new ClientStatMarshaller();

    public static ClientStatMarshaller getInstance() {
        return instance;
    }

    public void marshall(ClientStat clientStat, ProtocolMarshaller protocolMarshaller) {
        if (clientStat == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)clientStat.getUserAgent(), USERAGENT_BINDING);
            protocolMarshaller.marshall((Object)clientStat.getNumberOfRequestsLast30Days(), NUMBEROFREQUESTSLAST30DAYS_BINDING);
            protocolMarshaller.marshall((Object)clientStat.getLastRequestTime(), LASTREQUESTTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

