/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.eks.model.PodIdentityAssociationSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListPodIdentityAssociationsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<PodIdentityAssociationSummary> associations;
    private String nextToken;

    public List<PodIdentityAssociationSummary> getAssociations() {
        return this.associations;
    }

    public void setAssociations(Collection<PodIdentityAssociationSummary> associations) {
        if (associations == null) {
            this.associations = null;
            return;
        }
        this.associations = new ArrayList<PodIdentityAssociationSummary>(associations);
    }

    public ListPodIdentityAssociationsResult withAssociations(PodIdentityAssociationSummary ... associations) {
        if (this.associations == null) {
            this.setAssociations(new ArrayList<PodIdentityAssociationSummary>(associations.length));
        }
        for (PodIdentityAssociationSummary ele : associations) {
            this.associations.add(ele);
        }
        return this;
    }

    public ListPodIdentityAssociationsResult withAssociations(Collection<PodIdentityAssociationSummary> associations) {
        this.setAssociations(associations);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListPodIdentityAssociationsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAssociations() != null) {
            sb.append("Associations: ").append(this.getAssociations()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPodIdentityAssociationsResult)) {
            return false;
        }
        ListPodIdentityAssociationsResult other = (ListPodIdentityAssociationsResult)obj;
        if (other.getAssociations() == null ^ this.getAssociations() == null) {
            return false;
        }
        if (other.getAssociations() != null && !other.getAssociations().equals(this.getAssociations())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAssociations() == null ? 0 : this.getAssociations().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListPodIdentityAssociationsResult clone() {
        try {
            return (ListPodIdentityAssociationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

