/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eks.model.FargateProfileIssue;
import com.amazonaws.services.eks.model.transform.FargateProfileHealthMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FargateProfileHealth
implements Serializable,
Cloneable,
StructuredPojo {
    private List<FargateProfileIssue> issues;

    public List<FargateProfileIssue> getIssues() {
        return this.issues;
    }

    public void setIssues(Collection<FargateProfileIssue> issues) {
        if (issues == null) {
            this.issues = null;
            return;
        }
        this.issues = new ArrayList<FargateProfileIssue>(issues);
    }

    public FargateProfileHealth withIssues(FargateProfileIssue ... issues) {
        if (this.issues == null) {
            this.setIssues(new ArrayList<FargateProfileIssue>(issues.length));
        }
        for (FargateProfileIssue ele : issues) {
            this.issues.add(ele);
        }
        return this;
    }

    public FargateProfileHealth withIssues(Collection<FargateProfileIssue> issues) {
        this.setIssues(issues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIssues() != null) {
            sb.append("Issues: ").append(this.getIssues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FargateProfileHealth)) {
            return false;
        }
        FargateProfileHealth other = (FargateProfileHealth)obj;
        if (other.getIssues() == null ^ this.getIssues() == null) {
            return false;
        }
        return other.getIssues() == null || other.getIssues().equals(this.getIssues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIssues() == null ? 0 : this.getIssues().hashCode());
        return hashCode;
    }

    public FargateProfileHealth clone() {
        try {
            return (FargateProfileHealth)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FargateProfileHealthMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

